/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.generation.spring.SchemaGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MuleStudioPluginXmlGenerator
extends AbstractMessageGenerator {
    public static final String PLUGIN_XML_FILE_NAME = "plugin.xml";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.context.hasOption("skipStudioPluginPackage");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element pluginElement = document.createElement("plugin");
            document.appendChild(pluginElement);
            Element extensionElement = document.createElement("extension");
            extensionElement.setAttribute("point", "org.mule.tooling.core.contribution");
            pluginElement.appendChild(extensionElement);
            Element externalContributionElement = document.createElement("externalContribution");
            externalContributionElement.setAttribute("contributionJar", "%JAR_NAME%");
            externalContributionElement.setAttribute("contributionLibPathInMule", "/plugins");
            externalContributionElement.setAttribute("contributionLibs", "%ZIP_NAME%");
            externalContributionElement.setAttribute("contributionSources", "%SOURCES_JAR%");
            externalContributionElement.setAttribute("contributionJavaDocs", "%JAVADOC_JAR%");
            externalContributionElement.setAttribute("contributionNamespace", SchemaGenerator.getNamespace(typeElement));
            externalContributionElement.setAttribute("contributionNamespaceFile", SchemaGenerator.getVersionedLocation(typeElement));
            externalContributionElement.setAttribute("contributionNamespacePrefix", typeElement.name());
            externalContributionElement.setAttribute("contributionType", "cloud-connector");
            externalContributionElement.setAttribute("path", "editors.xml");
            externalContributionElement.setAttribute("version", "%PROJECT_VERSION%");
            externalContributionElement.setAttribute("name", this.context.getNameUtils().friendlyNameFromCamelCase(typeElement.name()));
            extensionElement.appendChild(externalContributionElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(this.context.getCodeModel().getCodeWriter().openBinary(null, PLUGIN_XML_FILE_NAME));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio plugin.xml", e);
        }
    }
}

