/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MuleStudioFeatureGenerator
extends AbstractMessageGenerator {
    public static final String FEATURE_XML_FILENAME = "feature.xml";
    public static final String STUDIO_PREFIX = "org.mule.tooling.ui.extension.";
    public static final String LABEL_SUFFIX = " Mule Studio Extension";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.context.hasOption("skipStudioPluginPackage");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element feature = document.createElement("feature");
            feature.setAttribute("id", STUDIO_PREFIX + typeElement.name());
            feature.setAttribute("label", this.context.getNameUtils().friendlyNameFromCamelCase(typeElement.name()) + LABEL_SUFFIX);
            feature.setAttribute("version", "%VERSION%");
            feature.setAttribute("provider-name", "Mulesoft, Inc.");
            document.appendChild(feature);
            Element license = document.createElement("license");
            license.setTextContent("%LICENSE%");
            license.setNodeValue("%LICENSE%");
            feature.appendChild(license);
            Element plugin = document.createElement("plugin");
            plugin.setAttribute("id", STUDIO_PREFIX + typeElement.name());
            plugin.setAttribute("download-size", "0");
            plugin.setAttribute("install-size", "0");
            plugin.setAttribute("version", "%VERSION%");
            plugin.setAttribute("unpack", "true");
            feature.appendChild(plugin);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(this.context.getCodeModel().getCodeWriter().openBinary(null, FEATURE_XML_FILENAME));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new GenerationException("Error generating Mule Studio plugin.xml", e);
        }
    }
}

