/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.expression;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.ExpressionEvaluator;
import org.mule.api.annotations.ExpressionLanguage;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.transformer.TransformerException;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.expression.ExpressionUtils;

public class ExpressionEvaluatorGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(ExpressionLanguage.class) && typeElement.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        String name = typeElement.getAnnotation(ExpressionLanguage.class).name();
        ExecutableElement executableElement = typeElement.getMethodsAnnotatedWith(ExpressionEvaluator.class).get(0);
        DefinedClass moduleObject = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        DefinedClass evaluatorClass = this.getEvaluatorClass(name, typeElement);
        this.context.note("Generating expression evaluator " + evaluatorClass.fullName() + " for language at class " + typeElement.getSimpleName().toString());
        FieldVariable module = this.generateModuleField((TypeReference)moduleObject, evaluatorClass);
        org.mule.devkit.model.code.Method setMuleContext = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.context.getCodeModel().VOID, "setMuleContext");
        Variable muleContext = setMuleContext.param((org.mule.devkit.model.code.Type)this.ref(MuleContext.class), "muleContext");
        Conditional ifModuleIsContextAware = setMuleContext.body()._if(Op._instanceof((Expression)module, (org.mule.devkit.model.code.Type)this.ref(MuleContextAware.class)));
        ifModuleIsContextAware._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(MuleContextAware.class), (Expression)module).invoke("setMuleContext").arg((Expression)muleContext));
        org.mule.devkit.model.code.Method start = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.context.getCodeModel().VOID, "start");
        start._throws(this.ref(MuleException.class));
        Conditional ifModuleIsStartable = start.body()._if(Op._instanceof((Expression)module, (org.mule.devkit.model.code.Type)this.ref(Startable.class)));
        ifModuleIsStartable._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Startable.class), (Expression)module).invoke("start"));
        org.mule.devkit.model.code.Method stop = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.context.getCodeModel().VOID, "stop");
        stop._throws(this.ref(MuleException.class));
        Conditional ifModuleIsStoppable = stop.body()._if(Op._instanceof((Expression)module, (org.mule.devkit.model.code.Type)this.ref(Stoppable.class)));
        ifModuleIsStoppable._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Stoppable.class), (Expression)module).invoke("stop"));
        org.mule.devkit.model.code.Method init = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.context.getCodeModel().VOID, "initialise");
        init._throws(this.ref(InitialisationException.class));
        Conditional ifModuleIsInitialisable = init.body()._if(Op._instanceof((Expression)module, (org.mule.devkit.model.code.Type)this.ref(Initialisable.class)));
        ifModuleIsInitialisable._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Initialisable.class), (Expression)module).invoke("initialise"));
        org.mule.devkit.model.code.Method dispose = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.context.getCodeModel().VOID, "dispose");
        Conditional ifModuleIsDisposable = dispose.body()._if(Op._instanceof((Expression)module, (org.mule.devkit.model.code.Type)this.ref(Disposable.class)));
        ifModuleIsDisposable._then().add((Statement)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(Disposable.class), (Expression)module).invoke("dispose"));
        this.generateConstructor((TypeReference)moduleObject, evaluatorClass, module);
        this.generateGetName(name, evaluatorClass);
        this.generateSetName(evaluatorClass);
        this.generateComputeClassHierarchyMethod(evaluatorClass);
        this.generateIsListClassMethod(evaluatorClass);
        this.generateIsMapClassMethod(evaluatorClass);
        this.generateIsListMethod(evaluatorClass);
        this.generateIsMapMethod(evaluatorClass);
        this.generateIsAssignableFrom(evaluatorClass);
        this.generateTransformMethod(evaluatorClass);
        org.mule.devkit.model.code.Method evaluate = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ref(Object.class), "evaluate");
        Variable expression = evaluate.param((org.mule.devkit.model.code.Type)this.ref(String.class), "expression");
        Variable message = evaluate.param((org.mule.devkit.model.code.Type)this.ref(MuleMessage.class), "message");
        TryStatement tryStatement = evaluate.body()._try();
        Invocation newArray = ExpressionFactory._new((TypeReference)this.ref(Class.class).array());
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (variableElement.asType().getKind() == TypeKind.BOOLEAN || variableElement.asType().getKind() == TypeKind.BYTE || variableElement.asType().getKind() == TypeKind.SHORT || variableElement.asType().getKind() == TypeKind.CHAR || variableElement.asType().getKind() == TypeKind.INT || variableElement.asType().getKind() == TypeKind.FLOAT || variableElement.asType().getKind() == TypeKind.LONG || variableElement.asType().getKind() == TypeKind.DOUBLE) {
                newArray.arg((Expression)this.ref(variableElement.asType()).boxify().staticRef("TYPE"));
                continue;
            }
            newArray.arg(this.ref(variableElement.asType()).boxify().dotclass());
        }
        Variable parameterClasses = tryStatement.body().decl((org.mule.devkit.model.code.Type)this.ref(Class.class).array(), "parameterClasses", (Expression)newArray);
        boolean bl = false;
        Invocation getMethod = module.invoke("getClass").invoke("getMethod").arg(executableElement.getSimpleName().toString()).arg((Expression)parameterClasses);
        Variable moduleEvaluate = tryStatement.body().decl((org.mule.devkit.model.code.Type)this.ref(Method.class), "evaluateMethod", (Expression)getMethod);
        ArrayList<Variable> types = new ArrayList<Variable>();
        for (VariableElement variableElement : executableElement.getParameters()) {
            Variable variable = tryStatement.body().decl((org.mule.devkit.model.code.Type)this.ref(Type.class), variableElement.getSimpleName().toString() + "Type", (Expression)moduleEvaluate.invoke("getGenericParameterTypes").component(ExpressionFactory.lit((int)types.size())));
            types.add(variable);
        }
        boolean bl2 = false;
        Invocation evaluateInvoke = module.invoke(executableElement.getSimpleName().toString());
        for (VariableElement variableElement : executableElement.getParameters()) {
            void var24_27;
            if (variableElement.getAnnotation(Payload.class) != null) {
                evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)message.invoke("getPayload"))));
            } else if (variableElement.getAnnotation(ExceptionPayload.class) != null) {
                evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)message.invoke("getExceptionPayload"))));
            } else if (variableElement.getAnnotation(CorrelationId.class) != null) {
                evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)message.invoke("getCorrelationId"))));
            } else if (variableElement.getAnnotation(CorrelationSequence.class) != null) {
                evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)message.invoke("getCorrelationSequence"))));
            } else if (variableElement.getAnnotation(CorrelationGroupSize.class) != null) {
                evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)message.invoke("getCorrelationGroupSize"))));
            } else if (variableElement.getAnnotation(MessageUniqueId.class) != null) {
                evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)message.invoke("getUniqueId"))));
            } else if (variableElement.getAnnotation(MessageRootId.class) != null) {
                evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)message.invoke("getMessageRootId"))));
            } else if (((Object)variableElement.asType()).toString().startsWith(MuleMessage.class.getName())) {
                evaluateInvoke.arg((Expression)message);
            } else if (variableElement.getAnnotation(InboundHeaders.class) != null) {
                InboundHeaders inboundHeaders = variableElement.getAnnotation(InboundHeaders.class);
                if (this.context.getTypeMirrorUtils().isArrayOrList(variableElement.asType())) {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INBOUND:" + inboundHeaders.value()).arg((Expression)message).arg(this.ref(List.class).dotclass()))));
                } else if (this.context.getTypeMirrorUtils().isMap(variableElement.asType())) {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INBOUND:" + inboundHeaders.value()).arg((Expression)message).arg(this.ref(Map.class).dotclass()))));
                } else {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INBOUND:" + inboundHeaders.value()).arg((Expression)message))));
                }
            } else if (variableElement.getAnnotation(SessionHeaders.class) != null) {
                SessionHeaders sessionHeaders = variableElement.getAnnotation(SessionHeaders.class);
                if (this.context.getTypeMirrorUtils().isArrayOrList(variableElement.asType())) {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("SESSION:" + sessionHeaders.value()).arg((Expression)message).arg(this.ref(List.class).dotclass()))));
                } else if (this.context.getTypeMirrorUtils().isMap(variableElement.asType())) {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("SESSION:" + sessionHeaders.value()).arg((Expression)message).arg(this.ref(Map.class).dotclass()))));
                } else {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("SESSION:" + sessionHeaders.value()).arg((Expression)message))));
                }
            } else if (variableElement.getAnnotation(OutboundHeaders.class) != null) {
                evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("OUTBOUND:*").arg((Expression)message).arg(this.ref(Map.class).dotclass()))));
            } else if (variableElement.getAnnotation(InvocationHeaders.class) != null) {
                InvocationHeaders invocationHeaders = variableElement.getAnnotation(InvocationHeaders.class);
                if (this.context.getTypeMirrorUtils().isArrayOrList(variableElement.asType())) {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INVOCATION:" + invocationHeaders.value()).arg((Expression)message).arg(this.ref(List.class).dotclass()))));
                } else if (this.context.getTypeMirrorUtils().isMap(variableElement.asType())) {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INVOCATION:" + invocationHeaders.value()).arg((Expression)message).arg(this.ref(Map.class).dotclass()))));
                } else {
                    evaluateInvoke.arg((Expression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(variableElement.asType()).boxify(), (Expression)ExpressionFactory.invoke((String)"transform").arg((Expression)message).arg((Expression)types.get((int)var24_27)).arg((Expression)this.ref(ExpressionUtils.class).staticInvoke("getPropertyWithScope").arg("INVOCATION:" + invocationHeaders.value()).arg((Expression)message))));
                }
            } else if (((Object)variableElement.asType()).toString().contains("String")) {
                evaluateInvoke.arg((Expression)expression);
            }
            ++var24_27;
        }
        tryStatement.body()._return((Expression)evaluateInvoke);
        this.catchAndRethrowAsRuntimeException(tryStatement, NoSuchMethodException.class);
        this.catchAndRethrowAsRuntimeException(tryStatement, TransformerException.class);
        this.context.registerAtBoot(evaluatorClass);
    }

    private void catchAndRethrowAsRuntimeException(TryStatement tryStatement, Class clazz) {
        CatchBlock catchBlock = tryStatement._catch(this.ref(clazz));
        Variable e = catchBlock.param("e");
        catchBlock.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)e));
    }

    private FieldVariable generateModuleField(TypeReference typeElement, DefinedClass evaluatorClass) {
        return evaluatorClass.field(4, (org.mule.devkit.model.code.Type)typeElement, "module", ExpressionFactory._null());
    }

    private void generateConstructor(TypeReference typeElement, DefinedClass evaluatorClass, FieldVariable module) {
        org.mule.devkit.model.code.Method constructor = evaluatorClass.constructor(1);
        constructor.body().assign((AssignmentTarget)module, (Expression)ExpressionFactory._new((TypeReference)typeElement));
    }

    private void generateGetName(String name, DefinedClass evaluatorClass) {
        org.mule.devkit.model.code.Method getName = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.ref(String.class), "getName");
        getName.body()._return(ExpressionFactory.lit((String)name));
    }

    private void generateSetName(DefinedClass evaluatorClass) {
        org.mule.devkit.model.code.Method setName = evaluatorClass.method(1, (org.mule.devkit.model.code.Type)this.context.getCodeModel().VOID, "setName");
        setName.param((org.mule.devkit.model.code.Type)this.ref(String.class), "name");
        setName.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private DefinedClass getEvaluatorClass(String name, Element variableElement) {
        String evaluatorClassName = this.context.getNameUtils().generateClassNameInPackage(variableElement, this.context.getNameUtils().camel(name) + "ExpressionEvaluator");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(evaluatorClassName) + ".expressions");
        DefinedClass evaluator = pkg._class(this.context.getNameUtils().getClassName(evaluatorClassName), new Class[]{org.mule.api.expression.ExpressionEvaluator.class});
        evaluator._implements(this.ref(MuleContextAware.class));
        evaluator._implements(this.ref(Startable.class));
        evaluator._implements(this.ref(Stoppable.class));
        evaluator._implements(this.ref(Initialisable.class));
        evaluator._implements(this.ref(Disposable.class));
        return evaluator;
    }
}

