/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.annotations.rest.HttpMethod;
import org.mule.api.annotations.rest.RestCall;
import org.mule.api.annotations.rest.RestExceptionOn;
import org.mule.api.annotations.rest.RestHeaderParam;
import org.mule.api.annotations.rest.RestHttpClient;
import org.mule.api.annotations.rest.RestQueryParam;
import org.mule.api.annotations.rest.RestUriParam;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.WhileLoop;
import org.mule.registry.TypeBasedTransformerResolver;
import org.mule.transformer.types.DataTypeFactory;

public class RestAdapterGenerator
extends AbstractModuleGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.isModuleOrConnector() && typeElement.hasMethodsAnnotatedWith(RestCall.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        DefinedClass restClientAdapterClass = this.getRestClientAdapterClass(typeElement);
        FieldVariable responseTimeout = restClientAdapterClass.field(4, (Type)this.context.getCodeModel().INT, "responseTimeout");
        FieldVariable muleContext = restClientAdapterClass.field(4, (Type)this.ref(MuleContext.class), "muleContext");
        Object httpClient = null;
        httpClient = !typeElement.hasFieldAnnotatedWith(RestHttpClient.class) ? restClientAdapterClass.field(516, (Type)this.ref(HttpClient.class), "httpClient") : ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)typeElement.getFieldsAnnotatedWith(RestHttpClient.class).get(0).getSimpleName().toString())));
        this.generateSetMuleContext(restClientAdapterClass, muleContext);
        org.mule.devkit.model.code.Method initialise = restClientAdapterClass.method(1, (Type)this.context.getCodeModel().VOID, "initialise");
        initialise.annotate(this.ref(Override.class));
        initialise.body().add((Statement)ExpressionFactory._super().invoke("initialise"));
        if (!typeElement.hasFieldAnnotatedWith(RestHttpClient.class)) {
            initialise.body().assign((AssignmentTarget)httpClient, (Expression)ExpressionFactory._new((TypeReference)this.ref(HttpClient.class)));
        } else {
            initialise.body().invoke("set" + StringUtils.capitalize((String)typeElement.getFieldsAnnotatedWith(RestHttpClient.class).get(0).getSimpleName().toString())).arg((Expression)ExpressionFactory._new((TypeReference)this.ref(HttpClient.class)));
        }
        initialise.body().add((Statement)httpClient.invoke("getParams").invoke("setParameter").arg("http.protocol.version").arg((Expression)this.ref(HttpVersion.class).staticRef("HTTP_1_1")));
        initialise.body().add((Statement)httpClient.invoke("getParams").invoke("setParameter").arg("http.socket.timeout").arg((Expression)responseTimeout));
        initialise.body().add((Statement)httpClient.invoke("getParams").invoke("setParameter").arg("http.protocol.content-charset").arg("UTF-8"));
        initialise.body().add((Statement)httpClient.invoke("getParams").invoke("setCookiePolicy").arg((Expression)this.ref(CookiePolicy.class).staticRef("BROWSER_COMPATIBILITY")));
        this.generateSetter(restClientAdapterClass, responseTimeout);
        this.generateRestCallImplementations(typeElement, (Expression)httpClient, (Variable)muleContext, restClientAdapterClass);
    }

    private void generateSetMuleContext(DefinedClass restClientAdapterClass, FieldVariable muleContext) {
        org.mule.devkit.model.code.Method setMuleContext = restClientAdapterClass.method(1, (Type)this.context.getCodeModel().VOID, "setMuleContext");
        setMuleContext.annotate(Override.class);
        Variable context = setMuleContext.param((Type)this.ref(MuleContext.class), "context");
        setMuleContext.body().assign((AssignmentTarget)muleContext, (Expression)context);
    }

    private void generateRestCallImplementations(DevKitTypeElement typeElement, Expression httpClient, Variable muleContext, DefinedClass capabilitiesAdapter) {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(RestCall.class)) {
            org.mule.devkit.model.code.Method override = capabilitiesAdapter.method(1, this.ref(executableElement.getReturnType()), executableElement.getSimpleName().toString());
            override._throws(this.ref(IOException.class));
            RestCall restCall = executableElement.getAnnotation(RestCall.class);
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (variableElement.getAnnotation(OAuthAccessToken.class) != null || variableElement.getAnnotation(OAuthAccessTokenSecret.class) != null) continue;
                variables.put(variableElement.getSimpleName().toString(), override.param(this.ref(variableElement.asType()), variableElement.getSimpleName().toString()));
            }
            Variable method = override.body().decl((Type)this.ref(org.apache.commons.httpclient.HttpMethod.class), "method", ExpressionFactory._null());
            Variable variable = override.body().decl((Type)this.ref(List.class).narrow(this.ref(NameValuePair.class)), "queryString", (Expression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(this.ref(NameValuePair.class))));
            this.generateMethodAssignment(override, restCall, method);
            this.generateParametersCode(typeElement, variables, executableElement, override, restCall, method, variable);
            if (restCall.method() == HttpMethod.POST || restCall.method() == HttpMethod.PUT) {
                VariableElement payloadParameter = null;
                for (VariableElement variableElement : executableElement.getParameters()) {
                    if (variableElement.getAnnotation(RestUriParam.class) != null || variableElement.getAnnotation(RestHeaderParam.class) != null || variableElement.getAnnotation(RestQueryParam.class) != null) continue;
                    payloadParameter = variableElement;
                    break;
                }
                if (payloadParameter != null) {
                    if (!restCall.contentType().equals("*/*")) {
                        TryStatement tryToTransform = override.body()._try();
                        Variable variable2 = tryToTransform.body().decl((Type)this.ref(DataType.class), "payloadInputDataType", (Expression)this.ref(DataTypeFactory.class).staticInvoke("createFromObject").arg((Expression)variables.get(payloadParameter.getSimpleName().toString())));
                        Variable payloadOutputDataType = tryToTransform.body().decl((Type)this.ref(DataType.class), "payloadOutputDataType", (Expression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(String.class).dotclass()).arg(restCall.contentType()));
                        Variable typeBasedResolver = tryToTransform.body().decl((Type)this.ref(TransformerResolver.class), "typeBasedResolver", (Expression)muleContext.invoke("getRegistry").invoke("lookupObject").arg(this.ref(TypeBasedTransformerResolver.class).dotclass()));
                        Variable payloadTransformer = tryToTransform.body().decl((Type)this.ref(Transformer.class), "payloadTransformer", (Expression)typeBasedResolver.invoke("resolve").arg((Expression)variable2).arg((Expression)payloadOutputDataType));
                        tryToTransform.body()._if(Op.eq((Expression)payloadTransformer, (Expression)ExpressionFactory._null()))._then().assign((AssignmentTarget)payloadTransformer, (Expression)muleContext.invoke("getRegistry").invoke("lookupTransformer").arg((Expression)variable2).arg((Expression)payloadOutputDataType));
                        Variable payloadRequestEntity = tryToTransform.body().decl((Type)this.ref(RequestEntity.class), "payloadRequestEntity", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringRequestEntity.class)).arg((Expression)ExpressionFactory.cast((Type)this.ref(String.class), (Expression)payloadTransformer.invoke("transform").arg((Expression)variables.get(payloadParameter.getSimpleName().toString())))).arg(restCall.contentType()).arg(ExpressionFactory.lit((String)"UTF-8")));
                        tryToTransform.body().add((Statement)ExpressionFactory.cast((Type)this.ref(PostMethod.class), (Expression)method).invoke("setRequestEntity").arg((Expression)payloadRequestEntity));
                        CatchBlock catchResolverException = tryToTransform._catch(this.ref(ResolverException.class));
                        Variable resolverException = catchResolverException.param("rese");
                        catchResolverException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)resolverException.invoke("getMessage")).arg((Expression)resolverException));
                        CatchBlock catchRegistrationException = tryToTransform._catch(this.ref(RegistrationException.class));
                        Variable registrationException = catchRegistrationException.param("re");
                        catchRegistrationException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)registrationException.invoke("getMessage")).arg((Expression)registrationException));
                        CatchBlock catchTransformerException = tryToTransform._catch(this.ref(TransformerException.class));
                        Variable transformerException = catchTransformerException.param("te");
                        catchTransformerException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)transformerException.invoke("getMessage")).arg((Expression)transformerException));
                    } else {
                        Variable payloadRequestEntity = override.body().decl((Type)this.ref(RequestEntity.class), "payloadRequestEntity", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringRequestEntity.class)).arg((Expression)((Variable)variables.get(payloadParameter.getSimpleName().toString())).invoke("toString")));
                        override.body().add((Statement)ExpressionFactory.cast((Type)this.ref(PostMethod.class), (Expression)method).invoke("setRequestEntity").arg((Expression)payloadRequestEntity));
                    }
                }
            }
            Variable statusCode = override.body().decl((Type)this.context.getCodeModel().INT, "statusCode", (Expression)httpClient.invoke("executeMethod").arg((Expression)method));
            this.generateParseResponseCode(typeElement, executableElement, override, method, statusCode, muleContext);
            override.body()._return(ExpressionFactory._null());
        }
    }

    private void generateParametersCode(DevKitTypeElement typeElement, Map<String, Variable> variables, ExecutableElement executableElement, org.mule.devkit.model.code.Method override, RestCall restCall, Variable method, Variable queryString) {
        RestHeaderParam restHeaderParam;
        RestUriParam restUriParam;
        Variable uri = override.body().decl((Type)this.ref(String.class), "uri", ExpressionFactory.lit((String)restCall.uri()));
        for (VariableElement variableElement : executableElement.getParameters()) {
            restUriParam = variableElement.getAnnotation(RestUriParam.class);
            if (restUriParam == null || !restCall.uri().contains("{" + restUriParam.value() + "}")) continue;
            override.body().assign((AssignmentTarget)uri, (Expression)uri.invoke("replace").arg("{" + restUriParam.value() + "}").arg((Expression)variables.get(variableElement.getSimpleName().toString())));
        }
        for (VariableElement variableElement : typeElement.getFieldsAnnotatedWith(RestUriParam.class)) {
            restUriParam = variableElement.getAnnotation(RestUriParam.class);
            if (restUriParam == null || !restCall.uri().contains("{" + restUriParam.value() + "}")) continue;
            override.body().assign((AssignmentTarget)uri, (Expression)uri.invoke("replace").arg("{" + restUriParam.value() + "}").arg((Expression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)variableElement.getSimpleName().toString())))));
        }
        override.body().add((Statement)method.invoke("setURI").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(URI.class)).arg((Expression)uri).arg(ExpressionFactory.FALSE)));
        for (VariableElement variableElement : executableElement.getParameters()) {
            restUriParam = variableElement.getAnnotation(RestUriParam.class);
            if (restUriParam == null || restCall.uri().contains("{" + restUriParam.value() + "}")) continue;
            this.addQueryParameter(override.body(), queryString, (Expression)variables.get(variableElement.getSimpleName().toString()), variableElement);
        }
        for (VariableElement variableElement : typeElement.getFieldsAnnotatedWith(RestUriParam.class)) {
            restUriParam = variableElement.getAnnotation(RestUriParam.class);
            if (restUriParam == null || restCall.uri().contains("{" + restUriParam.value() + "}")) continue;
            this.addQueryParameter(override.body(), queryString, (Expression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)variableElement.getSimpleName().toString()))), variableElement);
        }
        for (VariableElement variableElement : executableElement.getParameters()) {
            restHeaderParam = variableElement.getAnnotation(RestHeaderParam.class);
            if (restHeaderParam == null) continue;
            override.body().add((Statement)method.invoke("addRequestHeader").arg(restHeaderParam.value()).arg((Expression)variables.get(variableElement.getSimpleName().toString())));
        }
        for (VariableElement variableElement : typeElement.getFieldsAnnotatedWith(RestHeaderParam.class)) {
            restHeaderParam = variableElement.getAnnotation(RestHeaderParam.class);
            if (restHeaderParam == null) continue;
            override.body().add((Statement)method.invoke("addRequestHeader").arg(restHeaderParam.value()).arg((Expression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)variableElement.getSimpleName().toString())))));
        }
        if (restCall.method() == HttpMethod.GET) {
            override.body().add((Statement)method.invoke("setQueryString").arg((Expression)queryString.invoke("toArray").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(NameValuePair.class).array()))));
        } else if (restCall.method() == HttpMethod.PUT) {
            override.body().add((Statement)ExpressionFactory.cast((Type)this.ref(PutMethod.class), (Expression)method).invoke("addParameters").arg((Expression)queryString.invoke("toArray").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(NameValuePair.class).array()))));
        } else if (restCall.method() == HttpMethod.DELETE) {
            override.body().add((Statement)method.invoke("setQueryString").arg((Expression)queryString.invoke("toArray").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(NameValuePair.class).array()))));
        } else if (restCall.method() == HttpMethod.POST) {
            override.body().add((Statement)ExpressionFactory.cast((Type)this.ref(PostMethod.class), (Expression)method).invoke("addParameters").arg((Expression)queryString.invoke("toArray").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(NameValuePair.class).array()))));
        } else if (restCall.method() == HttpMethod.TRACE) {
            override.body().add((Statement)method.invoke("setQueryString").arg((Expression)queryString.invoke("toArray").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(NameValuePair.class).array()))));
        }
    }

    private void generateMethodAssignment(org.mule.devkit.model.code.Method override, RestCall restCall, Variable method) {
        if (restCall.method() == HttpMethod.GET) {
            override.body().assign((AssignmentTarget)method, (Expression)ExpressionFactory._new((TypeReference)this.ref(GetMethod.class)));
        } else if (restCall.method() == HttpMethod.PUT) {
            override.body().assign((AssignmentTarget)method, (Expression)ExpressionFactory._new((TypeReference)this.ref(PutMethod.class)));
        } else if (restCall.method() == HttpMethod.DELETE) {
            override.body().assign((AssignmentTarget)method, (Expression)ExpressionFactory._new((TypeReference)this.ref(DeleteMethod.class)));
        } else if (restCall.method() == HttpMethod.POST) {
            override.body().assign((AssignmentTarget)method, (Expression)ExpressionFactory._new((TypeReference)this.ref(PostMethod.class)));
        } else if (restCall.method() == HttpMethod.TRACE) {
            override.body().assign((AssignmentTarget)method, (Expression)ExpressionFactory._new((TypeReference)this.ref(TraceMethod.class)));
        }
    }

    private void generateParseResponseCode(TypeElement typeElement, ExecutableElement executableElement, org.mule.devkit.model.code.Method override, Variable method, Variable statusCode, Variable muleContext) {
        Conditional ifMethodExecuted = override.body()._if(Op.cand((Expression)Op.ne((Expression)method, (Expression)ExpressionFactory._null()), (Expression)method.invoke("hasBeenUsed")));
        Variable bufferedReader = ifMethodExecuted._then().decl((Type)this.ref(BufferedReader.class), "bufferedReader", ExpressionFactory._null());
        Variable stringWriter = ifMethodExecuted._then().decl((Type)this.ref(StringWriter.class), "stringWriter", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringWriter.class)));
        Variable bufferedWriter = ifMethodExecuted._then().decl((Type)this.ref(BufferedWriter.class), "bufferedWriter", (Expression)ExpressionFactory._new((TypeReference)this.ref(BufferedWriter.class)).arg((Expression)stringWriter).arg(ExpressionFactory.lit((int)8192)));
        TryStatement readStream = ifMethodExecuted._then()._try();
        Variable line = readStream.body().decl((Type)this.ref(String.class), "line", ExpressionFactory.lit((String)""));
        readStream.body().assign((AssignmentTarget)bufferedReader, (Expression)ExpressionFactory._new((TypeReference)this.ref(BufferedReader.class)).arg((Expression)ExpressionFactory._new((TypeReference)this.ref(InputStreamReader.class)).arg((Expression)method.invoke("getResponseBodyAsStream"))));
        WhileLoop whileLoop = readStream.body()._while(Op.ne((Expression)ExpressionFactory.assign((AssignmentTarget)line, (Expression)bufferedReader.invoke("readLine")), (Expression)ExpressionFactory._null()));
        whileLoop.body().add((Statement)bufferedWriter.invoke("write").arg((Expression)line));
        whileLoop.body().add((Statement)bufferedWriter.invoke("newLine"));
        readStream._finally().add((Statement)bufferedWriter.invoke("flush"));
        readStream._finally().add((Statement)bufferedWriter.invoke("close"));
        readStream._finally()._if(Op.ne((Expression)bufferedReader, (Expression)ExpressionFactory._null()))._then().add((Statement)bufferedReader.invoke("close"));
        Variable output = ifMethodExecuted._then().decl((Type)this.ref(String.class), "output", (Expression)stringWriter.invoke("toString"));
        this.generateExeptionOnBlock(executableElement, statusCode, ifMethodExecuted, output);
        this.generateTransformAndReturn(typeElement, executableElement, muleContext, ifMethodExecuted, output);
    }

    private void generateTransformAndReturn(TypeElement moduleClass, ExecutableElement executableElement, Variable muleContext, Conditional block, Variable output) {
        Conditional shouldTransform = block._then()._if(Op.cand((Expression)Op.ne((Expression)output, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(executableElement.getReturnType()).boxify().dotclass().invoke("isAssignableFrom").arg(this.ref(String.class).dotclass()))));
        Variable outputDataType = shouldTransform._then().decl((Type)this.ref(DataType.class), "outputDataType", ExpressionFactory._null());
        TryStatement tryToTransform = shouldTransform._then()._try();
        Invocation getMethod = this.ref(moduleClass.asType()).boxify().dotclass().invoke("getMethod").arg(executableElement.getSimpleName().toString());
        for (VariableElement variableElement : executableElement.getParameters()) {
            getMethod.arg(this.ref(variableElement.asType()).boxify().dotclass());
        }
        Variable method = tryToTransform.body().decl((Type)this.ref(Method.class), "reflectedMethod", (Expression)getMethod);
        tryToTransform.body().assign((AssignmentTarget)outputDataType, (Expression)this.ref(DataTypeFactory.class).staticInvoke("createFromReturnType").arg((Expression)method));
        Variable variable = tryToTransform.body().decl((Type)this.ref(TransformerResolver.class), "typeBasedResolver", (Expression)muleContext.invoke("getRegistry").invoke("lookupObject").arg(this.ref(TypeBasedTransformerResolver.class).dotclass()));
        Variable transformer = tryToTransform.body().decl((Type)this.ref(Transformer.class), "payloadTransformer", (Expression)variable.invoke("resolve").arg((Expression)this.ref(DataType.class).staticRef("STRING_DATA_TYPE")).arg((Expression)outputDataType));
        tryToTransform.body()._if(Op.eq((Expression)transformer, (Expression)ExpressionFactory._null()))._then().assign((AssignmentTarget)transformer, (Expression)muleContext.invoke("getRegistry").invoke("lookupTransformer").arg((Expression)this.ref(DataType.class).staticRef("STRING_DATA_TYPE")).arg((Expression)outputDataType));
        tryToTransform.body()._return((Expression)ExpressionFactory.cast((Type)this.ref(executableElement.getReturnType()), (Expression)transformer.invoke("transform").arg((Expression)output)));
        CatchBlock catchResolverException = tryToTransform._catch(this.ref(ResolverException.class));
        Variable resolverException = catchResolverException.param("rese");
        catchResolverException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)resolverException.invoke("getMessage")).arg((Expression)resolverException));
        CatchBlock catchRegistrationException = tryToTransform._catch(this.ref(RegistrationException.class));
        Variable registrationException = catchRegistrationException.param("re");
        catchRegistrationException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)registrationException.invoke("getMessage")).arg((Expression)registrationException));
        CatchBlock catchTransformerException = tryToTransform._catch(this.ref(TransformerException.class));
        Variable transformerException = catchTransformerException.param("te");
        catchTransformerException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg(Op.plus((Expression)ExpressionFactory.lit((String)"Unable to transform output from String to "), (Expression)outputDataType.invoke("toString"))).arg((Expression)transformerException));
        CatchBlock catchNoSuchMethodException = tryToTransform._catch(this.ref(NoSuchMethodException.class));
        Variable noSuchMethodException = catchNoSuchMethodException.param("nsme");
        catchNoSuchMethodException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg(ExpressionFactory.lit((String)("Unable to find method named " + executableElement.getSimpleName().toString()))).arg((Expression)noSuchMethodException));
        shouldTransform._else()._return((Expression)ExpressionFactory.cast((Type)this.ref(executableElement.getReturnType()), (Expression)ExpressionFactory.cast((Type)this.ref(Object.class), (Expression)output)));
    }

    private void generateExeptionOnBlock(ExecutableElement executableElement, Variable statusCode, Conditional block, Variable message) {
        RestExceptionOn restExceptionOn = executableElement.getAnnotation(RestExceptionOn.class);
        String restExceptionOnAnnotationName = RestExceptionOn.class.getName();
        DeclaredType exception = null;
        List<? extends AnnotationMirror> annotationMirrors = executableElement.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!restExceptionOnAnnotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"exception".equals(entry.getKey().getSimpleName().toString())) continue;
                exception = (DeclaredType)entry.getValue().getValue();
                continue block0;
            }
        }
        if (restExceptionOn != null && restExceptionOn.statusCodeIs().length > 0) {
            for (int expectedStatusCode : restExceptionOn.statusCodeIs()) {
                Conditional ifStatusCode = block._then()._if(Op.eq((Expression)statusCode, (Expression)ExpressionFactory.lit((int)expectedStatusCode)));
                if (exception == null) {
                    ifStatusCode._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)message));
                    continue;
                }
                ifStatusCode._then()._throw((Expression)ExpressionFactory._new((Type)this.ref(exception)).arg((Expression)message));
            }
        }
        if (restExceptionOn != null && restExceptionOn.statusCodeIsNot().length > 0) {
            Expression notEq = null;
            for (int expectedStatusCode : restExceptionOn.statusCodeIsNot()) {
                notEq = notEq == null ? Op.ne((Expression)statusCode, (Expression)ExpressionFactory.lit((int)expectedStatusCode)) : Op.cand((Expression)notEq, (Expression)Op.ne((Expression)statusCode, (Expression)ExpressionFactory.lit((int)expectedStatusCode)));
            }
            Conditional conditional = block._then()._if(notEq);
            if (exception == null) {
                conditional._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)message));
            } else {
                conditional._then()._throw((Expression)ExpressionFactory._new((Type)this.ref(exception)).arg((Expression)message));
            }
        }
    }

    private void addQueryParameter(Block body, Variable queryString, Expression variable, VariableElement parameter) {
        RestUriParam restUriParam = parameter.getAnnotation(RestUriParam.class);
        Invocation rvalue = variable.invoke("toString");
        if (restUriParam != null) {
            if (restUriParam.separatedBy() != null && !StringUtils.isEmpty((String)restUriParam.separatedBy())) {
                rvalue = this.ref(StringUtils.class).staticInvoke("join").arg((Expression)variable.invoke("toArray")).arg(restUriParam.separatedBy());
            }
            Conditional ifNotNull = body._if(Op.ne((Expression)variable, (Expression)ExpressionFactory._null()));
            ifNotNull._then().add((Statement)queryString.invoke("add").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(NameValuePair.class)).arg(restUriParam.value()).arg((Expression)rvalue)));
        }
    }

    private DefinedClass getRestClientAdapterClass(TypeElement typeElement) {
        String restClientAdapterClassName = this.context.getNameUtils().generateClassName(typeElement, ".adapters", "RestClientAdapter");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(restClientAdapterClassName));
        DefinedClass previous = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        if (previous == null) {
            previous = (TypeReference)this.ref(typeElement.asType());
        }
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(restClientAdapterClassName), (TypeReference)previous);
        clazz._implements(this.ref(Initialisable.class));
        clazz._implements(this.ref(Disposable.class));
        clazz._implements(this.ref(MuleContextAware.class));
        this.context.setClassRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement), clazz);
        return clazz;
    }
}

