/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import javax.lang.model.element.TypeElement;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.callback.HttpCallback;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.transport.Connector;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.util.NumberUtils;

public class HttpCallbackAdapterGenerator
extends AbstractModuleGenerator {
    public static final String LOCAL_PORT_FIELD_NAME = "localPort";
    public static final String REMOTE_PORT_FIELD_NAME = "remotePort";
    public static final String DOMAIN_FIELD_NAME = "domain";
    public static final String ASYNC_FIELD_NAME = "async";
    public static final String CONNECTOR_FIELD_NAME = "connector";
    private static final int DEFAULT_LOCAL_PORT = 8080;
    private static final int DEFAULT_REMOTE_PORT = 80;

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class) || typeElement.hasProcessorMethodWithParameter(HttpCallback.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        DefinedClass httpCallbackAdapter = this.getHttpCallbackAdapterClass(typeElement);
        FieldVariable localPort = this.localPortFieldWithGetterAndSetter(httpCallbackAdapter);
        FieldVariable remotePort = this.remotePortFieldWithGetterAndSetter(httpCallbackAdapter);
        FieldVariable domain = this.domainFieldWithGetterAndSetter(httpCallbackAdapter);
        this.connectorFieldWithGetterAndSetter(httpCallbackAdapter);
        FieldVariable logger = FieldBuilder.newLoggerField((DefinedClass)httpCallbackAdapter);
        this.asyncFieldWithGetterAndSetter(httpCallbackAdapter);
        this.generateInitialiseMethod(httpCallbackAdapter, localPort, remotePort, domain, logger);
    }

    private void generateInitialiseMethod(DefinedClass httpCallbackAdapter, FieldVariable localPort, FieldVariable remotePort, FieldVariable domain, FieldVariable logger) {
        Method initialise = httpCallbackAdapter.method(1, (Type)this.context.getCodeModel().VOID, "initialise");
        if (this.ref(Initialisable.class).isAssignableFrom(httpCallbackAdapter._extends())) {
            initialise.body().invoke(ExpressionFactory._super(), "initialise");
        }
        Block ifLocalPortIsNull = initialise.body()._if(Op.eq((Expression)localPort, (Expression)ExpressionFactory._null()))._then();
        this.initialiseLocalPort(localPort, logger, ifLocalPortIsNull);
        Block ifRemotePortIsNull = initialise.body()._if(Op.eq((Expression)remotePort, (Expression)ExpressionFactory._null()))._then();
        ifRemotePortIsNull.invoke((Expression)logger, "info").arg(ExpressionFactory.lit((String)"Using default remotePort: 80"));
        ifRemotePortIsNull.assign((AssignmentTarget)remotePort, ExpressionFactory.lit((int)80));
        Block ifDomainIsNull = initialise.body()._if(Op.eq((Expression)domain, (Expression)ExpressionFactory._null()))._then();
        this.assignDomainSystemVariable(domain, logger, ifDomainIsNull);
    }

    private void initialiseLocalPort(FieldVariable localPort, FieldVariable logger, Block ifPortIsNull) {
        Variable portSystemVar = ifPortIsNull.decl((Type)this.ref(String.class), "portSystemVar", (Expression)this.ref(System.class).staticInvoke("getProperty").arg("http.port"));
        Conditional conditional = ifPortIsNull._if((Expression)this.ref(NumberUtils.class).staticInvoke("isDigits").arg((Expression)portSystemVar));
        conditional._then().block().assign((AssignmentTarget)localPort, (Expression)this.ref(Integer.class).staticInvoke("parseInt").arg((Expression)portSystemVar));
        Block thenBlock = conditional._else().block();
        thenBlock.invoke((Expression)logger, "warn").arg(ExpressionFactory.lit((String)"Environment variable 'http.port' not found, using default localPort: 8080"));
        thenBlock.assign((AssignmentTarget)localPort, ExpressionFactory.lit((int)8080));
    }

    private void assignDomainSystemVariable(FieldVariable domain, FieldVariable logger, Block ifDomainIsNull) {
        Variable domainSystemVar = ifDomainIsNull.decl((Type)this.ref(String.class), "domainSystemVar", (Expression)this.ref(System.class).staticInvoke("getProperty").arg("fullDomain"));
        Conditional conditional = ifDomainIsNull._if(Op.ne((Expression)domainSystemVar, (Expression)ExpressionFactory._null()));
        conditional._then().block().assign((AssignmentTarget)domain, (Expression)domainSystemVar);
        Block thenBlock = conditional._else().block();
        thenBlock.invoke((Expression)logger, "warn").arg("Environment variable 'fullDomain' not found, using default: localhost");
        thenBlock.assign((AssignmentTarget)domain, ExpressionFactory.lit((String)"localhost"));
    }

    private DefinedClass getHttpCallbackAdapterClass(TypeElement typeElement) {
        String httpCallbackAdapterClassName = this.context.getNameUtils().generateClassName(typeElement, ".adapters", "HttpCallbackAdapter");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(httpCallbackAdapterClassName));
        DefinedClass classToExtend = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        DefinedClass oauthAdapter = pkg._class(this.context.getNameUtils().getClassName(httpCallbackAdapterClassName), (TypeReference)classToExtend);
        oauthAdapter._implements(this.ref(Initialisable.class));
        this.context.setClassRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement), oauthAdapter);
        return oauthAdapter;
    }

    private FieldVariable localPortFieldWithGetterAndSetter(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(Integer.class).name(LOCAL_PORT_FIELD_NAME).getterAndSetter().build();
    }

    private FieldVariable remotePortFieldWithGetterAndSetter(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(Integer.class).name(REMOTE_PORT_FIELD_NAME).getterAndSetter().build();
    }

    private FieldVariable domainFieldWithGetterAndSetter(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name(DOMAIN_FIELD_NAME).getterAndSetter().build();
    }

    private FieldVariable connectorFieldWithGetterAndSetter(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(Connector.class).name(CONNECTOR_FIELD_NAME).getterAndSetter().build();
    }

    private FieldVariable asyncFieldWithGetterAndSetter(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(Boolean.class).name(ASYNC_FIELD_NAME).initialValue(ExpressionFactory.lit((boolean)false)).getterAndSetter().build();
    }
}

