/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.client.MuleClient;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreManager;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;
import org.mule.util.queue.QueueManager;

public class InjectValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.getFieldsAnnotatedWith(Inject.class).size() > 0;
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        for (VariableElement variable : typeElement.getFieldsAnnotatedWith(Inject.class)) {
            if (!(((Object)variable.asType()).toString().equals(MuleContext.class.getName()) || ((Object)variable.asType()).toString().equals(ObjectStoreManager.class.getName()) || ((Object)variable.asType()).toString().equals(TransactionManager.class.getName()) || ((Object)variable.asType()).toString().equals(QueueManager.class.getName()) || ((Object)variable.asType()).toString().equals(MuleConfiguration.class.getName()) || ((Object)variable.asType()).toString().equals(LifecycleManager.class.getName()) || ((Object)variable.asType()).toString().equals(ClassLoader.class.getName()) || ((Object)variable.asType()).toString().equals(ExpressionManager.class.getName()) || ((Object)variable.asType()).toString().equals(EndpointFactory.class.getName()) || ((Object)variable.asType()).toString().equals(MuleClient.class.getName()) || ((Object)variable.asType()).toString().equals(SystemExceptionHandler.class.getName()) || ((Object)variable.asType()).toString().equals(SecurityManager.class.getName()) || ((Object)variable.asType()).toString().equals(WorkManager.class.getName()) || ((Object)variable.asType()).toString().equals(ObjectStore.class.getName()) || ((Object)variable.asType()).toString().equals(Registry.class.getName()))) {
                throw new ValidationException((Element)variable, "I don't know how to inject the type " + ((Object)variable.asType()).toString() + " in field " + variable.getSimpleName().toString() + ". " + "The only types I know how to inject are: MuleContext, ObjectStoreManager, ObjectStore, TransactionManager, QueueManager, MuleConfiguration, LifecycleManager, ClassLoader," + "ExpressionManager, EndpointFactory, MuleClient, SystemExceptionHandler, SecurityManager, WorkManager, Registry");
            }
            boolean found = false;
            for (ExecutableElement method : typeElement.getMethods()) {
                if (!method.getSimpleName().toString().equals("set" + StringUtils.capitalize((String)variable.getSimpleName().toString()))) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new ValidationException((Element)variable, "Cannot find a setter method for " + variable.getSimpleName().toString() + " but its being marked as injectable.");
            }
            if (!((Object)variable.asType()).toString().equals(ObjectStore.class.getName())) continue;
            boolean getterFound = false;
            for (ExecutableElement method : typeElement.getMethods()) {
                if (!method.getSimpleName().toString().equals("get" + StringUtils.capitalize((String)variable.getSimpleName().toString()))) continue;
                getterFound = true;
                break;
            }
            if (getterFound) continue;
            throw new ValidationException((Element)variable, "Cannot find a getter method for " + variable.getSimpleName().toString() + " but its being marked as an injectable Object Store.");
        }
    }
}

