/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.mule.api.annotations.ExpressionEnricher;
import org.mule.api.annotations.ExpressionEvaluator;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class ExpressionLanguageValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return true;
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        boolean expressionStringFound;
        if (typeElement.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() > 1) {
            throw new ValidationException((Element)typeElement, "An @ExpressionLanguage can only contain one @ExpressionEvaluator.");
        }
        if (typeElement.getMethodsAnnotatedWith(ExpressionEnricher.class).size() > 1) {
            throw new ValidationException((Element)typeElement, "An @ExpressionLanguage can only contain one @ExpressionEnricher.");
        }
        if (typeElement.getMethodsAnnotatedWith(ExpressionEvaluator.class).size() == 0 && typeElement.getMethodsAnnotatedWith(ExpressionEnricher.class).size() == 0) {
            throw new ValidationException((Element)typeElement, "An @ExpressionLanguage must contain one @ExpressionEnricher or one @ExpressionEvaluator or both.");
        }
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(ExpressionEvaluator.class)) {
            if (executableElement.getParameters().size() == 0) {
                throw new ValidationException((Element)executableElement, "An @ExpressionEvaluator must receive at least a String that represents the expression to evaluate.");
            }
            if (((Object)executableElement.getReturnType()).toString().equals("void")) {
                throw new ValidationException((Element)executableElement, "@ExpressionEvaluator cannot be void");
            }
            expressionStringFound = false;
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (variableElement.getAnnotation(Payload.class) != null || variableElement.getAnnotation(OutboundHeaders.class) != null || variableElement.getAnnotation(InboundHeaders.class) != null || variableElement.getAnnotation(SessionHeaders.class) != null || variableElement.getAnnotation(InvocationHeaders.class) != null || variableElement.getAnnotation(ExceptionPayload.class) != null || variableElement.getAnnotation(CorrelationId.class) != null || variableElement.getAnnotation(CorrelationSequence.class) != null) continue;
                if (((Object)variableElement.asType()).toString().contains("String")) {
                    if (expressionStringFound) {
                        throw new ValidationException((Element)executableElement, "An @ExpressionEvaluator can receive only one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
                    }
                    expressionStringFound = true;
                    continue;
                }
                throw new ValidationException((Element)executableElement, "An @ExpressionEvaluator can receive only one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
            }
        }
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(ExpressionEnricher.class)) {
            if (executableElement.getParameters().size() == 0) {
                throw new ValidationException((Element)executableElement, "An @ExpressionEnricher must receive at least a String that represents the expression and Object that represents the object to be used for enrichment.");
            }
            if (!((Object)executableElement.getReturnType()).toString().equals("void")) {
                throw new ValidationException((Element)executableElement, "@ExpressionEnricher must be void");
            }
            expressionStringFound = false;
            boolean enrichObjectFound = false;
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (variableElement.getAnnotation(Payload.class) != null || variableElement.getAnnotation(OutboundHeaders.class) != null || variableElement.getAnnotation(InboundHeaders.class) != null || variableElement.getAnnotation(SessionHeaders.class) != null || variableElement.getAnnotation(InvocationHeaders.class) != null || variableElement.getAnnotation(ExceptionPayload.class) != null || variableElement.getAnnotation(CorrelationId.class) != null || variableElement.getAnnotation(CorrelationSequence.class) != null) continue;
                if (((Object)variableElement.asType()).toString().contains("String")) {
                    if (expressionStringFound) {
                        throw new ValidationException((Element)executableElement, "An @ExpressionEnricher can receive only one Object and one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
                    }
                    expressionStringFound = true;
                    continue;
                }
                if (((Object)variableElement.asType()).toString().contains("Object")) {
                    if (enrichObjectFound) {
                        throw new ValidationException((Element)executableElement, "An @ExpressionEnricher can receive only one Object and one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
                    }
                    enrichObjectFound = true;
                    continue;
                }
                throw new ValidationException((Element)executableElement, "An @ExpressionEnricher can receive only one Object and one String and the rest of the arguments must be annotated with either @Payload, @InboundHeaders, @OutboundHeaders, @SessionHeader or @InvocationHeaders.");
            }
        }
    }
}

