/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.utils;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.xml.bind.annotation.XmlType;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.SourceCallback;

public class TypeMirrorUtils {
    private static final List<Class<?>> PARAMETER_TYPES_TO_IGNORE = Arrays.asList(SourceCallback.class, MuleMessage.class);
    private static final List<Class<? extends Annotation>> PARAMETERS_ANNOTATIONS_TO_IGNORE = Arrays.asList(InboundHeaders.class, InvocationHeaders.class, OutboundHeaders.class, SessionHeaders.class, Payload.class, OAuthAccessToken.class, OAuthAccessTokenSecret.class, ExceptionPayload.class, CorrelationId.class, CorrelationSequence.class, CorrelationGroupSize.class, MessageUniqueId.class, MessageRootId.class);
    private Types types;

    public TypeMirrorUtils(Types types) {
        this.types = types;
    }

    public boolean isXmlType(TypeMirror type) {
        DeclaredType declaredType;
        XmlType xmlType;
        return type.getKind() == TypeKind.DECLARED && (xmlType = (declaredType = (DeclaredType)type).asElement().getAnnotation(XmlType.class)) != null;
    }

    public boolean isCollection(TypeMirror type) {
        return this.isArrayOrList(type) || this.isMap(type);
    }

    public boolean isNestedProcessor(TypeMirror type) {
        if (((Object)type).toString().startsWith(NestedProcessor.class.getName())) {
            return true;
        }
        if (((Object)type).toString().startsWith(List.class.getName())) {
            DeclaredType variableType = (DeclaredType)type;
            List<? extends TypeMirror> variableTypeParameters = variableType.getTypeArguments();
            if (variableTypeParameters.isEmpty()) {
                return false;
            }
            if (((Object)variableTypeParameters.get(0)).toString().startsWith(NestedProcessor.class.getName())) {
                return true;
            }
        }
        return false;
    }

    public boolean isArrayOrList(TypeMirror type) {
        if (((Object)type).toString().equals("byte[]")) {
            return false;
        }
        if (type.getKind() == TypeKind.ARRAY) {
            return true;
        }
        if (((Object)type).toString().startsWith(List.class.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.isArrayOrList(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean isMap(TypeMirror type) {
        if (((Object)type).toString().startsWith(Map.class.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.isMap(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnum(TypeMirror type) {
        if (((Object)type).toString().startsWith(Enum.class.getName())) {
            return true;
        }
        List<? extends TypeMirror> inherits = this.types.directSupertypes(type);
        for (TypeMirror typeMirror : inherits) {
            if (!this.isEnum(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean ignoreParameter(Element element) {
        String variableType = ((Object)element.asType()).toString();
        for (Class<?> clazz : PARAMETER_TYPES_TO_IGNORE) {
            if (!variableType.contains(clazz.getName())) continue;
            return true;
        }
        for (Class<Object> clazz : PARAMETERS_ANNOTATIONS_TO_IGNORE) {
            if (element.getAnnotation(clazz) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isString(Element element) {
        String className = ((Object)element.asType()).toString();
        return className.startsWith(String.class.getName());
    }

    public boolean isBoolean(Element element) {
        String className = ((Object)element.asType()).toString();
        return className.startsWith(Boolean.class.getName()) || className.startsWith("boolean");
    }

    public boolean isInteger(Element element) {
        String className = ((Object)element.asType()).toString();
        return className.startsWith(Integer.class.getName()) || className.startsWith("int");
    }

    public boolean isLong(Element element) {
        String className = ((Object)element.asType()).toString();
        return className.startsWith(Long.class.getName()) || className.startsWith("long");
    }

    public boolean isFloat(Element element) {
        String className = ((Object)element.asType()).toString();
        return className.startsWith(Float.class.getName()) || className.startsWith("float");
    }

    public boolean isDouble(Element element) {
        String className = ((Object)element.asType()).toString();
        return className.startsWith(Double.class.getName()) || className.startsWith("double");
    }

    public boolean isChar(Element element) {
        String className = ((Object)element.asType()).toString();
        return className.startsWith(Character.class.getName()) || className.startsWith("char");
    }

    public boolean isEnum(Element element) {
        return this.isEnum(element.asType());
    }

    public boolean isCollection(Element element) {
        return this.isCollection(element.asType());
    }

    public boolean isHttpCallback(Element element) {
        return ((Object)element.asType()).toString().startsWith(HttpCallback.class.getName());
    }

    public boolean isURL(Element element) {
        return ((Object)element.asType()).toString().startsWith(URL.class.getName());
    }

    public boolean isDate(Element element) {
        return ((Object)element.asType()).toString().startsWith(Date.class.getName());
    }

    public String getJavaType(Element element) {
        return ((Object)element.asType()).toString();
    }

    public String getJavaType(ExecutableElement element) {
        return ((Object)element.getReturnType()).toString();
    }
}

