/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.DefaultDevKitTypeElement;
import org.mule.devkit.generation.TypeElementImpl;

public class NameUtils {
    private Elements elements;
    private static final List<Inflection> plural = new ArrayList<Inflection>();
    private static final List<Inflection> singular = new ArrayList<Inflection>();
    private static final List<String> uncountable = new ArrayList<String>();

    public NameUtils(Elements elements) {
        this.elements = elements;
    }

    private static void plural(String pattern, String replacement) {
        plural.add(0, new Inflection(pattern, replacement));
    }

    private static void singular(String pattern, String replacement) {
        singular.add(0, new Inflection(pattern, replacement));
    }

    private static void irregular(String s, String p) {
        NameUtils.plural("(" + s.substring(0, 1) + ")" + s.substring(1) + "$", "$1" + p.substring(1));
        NameUtils.singular("(" + p.substring(0, 1) + ")" + p.substring(1) + "$", "$1" + s.substring(1));
    }

    private static void uncountable(String word) {
        uncountable.add(word);
    }

    public String camel(String uncamelCaseName) {
        String result = "";
        String[] parts = uncamelCaseName.split("-");
        for (int i = 0; i < parts.length; ++i) {
            result = result + StringUtils.capitalize((String)parts[i].toLowerCase());
        }
        return result;
    }

    public String uncamel(String camelCaseName) {
        String result = "";
        String[] parts = camelCaseName.split("(?<!^)(?=[A-Z])");
        for (int i = 0; i < parts.length; ++i) {
            result = result + parts[i].toLowerCase() + (i < parts.length - 1 ? "-" : "");
        }
        return result;
    }

    public String friendlyNameFromCamelCase(String camelCaseName) {
        return StringUtils.capitalize((String)this.uncamel(camelCaseName)).replaceAll("-", " ");
    }

    public String getClassName(String fullyQualifiedClassName) {
        int lastDot = fullyQualifiedClassName.lastIndexOf(46);
        return fullyQualifiedClassName.substring(lastDot + 1);
    }

    public String getPackageName(String fullyQualifiedClassName) {
        int lastDot = fullyQualifiedClassName.lastIndexOf(46);
        return fullyQualifiedClassName.substring(0, lastDot);
    }

    public String pluralize(String word) {
        if (this.isUncountable(word)) {
            return word;
        }
        for (Inflection inflection : plural) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public String singularize(String word) {
        if (this.isUncountable(word)) {
            return word;
        }
        for (Inflection inflection : singular) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public boolean isUncountable(String word) {
        for (String w : uncountable) {
            if (!w.equalsIgnoreCase(word)) continue;
            return true;
        }
        return false;
    }

    public String generateClassName(ExecutableElement executableElement, String append) {
        TypeElement parentClass = ElementFilter.typesIn(Arrays.asList(executableElement.getEnclosingElement())).get(0);
        String packageName = this.getPackageName(this.getBinaryName(parentClass));
        String className = StringUtils.capitalize((String)executableElement.getSimpleName().toString()) + append;
        return packageName + "." + className;
    }

    public String generateClassName(ExecutableElement executableElement, String extraPackage, String append) {
        TypeElement parentClass = ElementFilter.typesIn(Arrays.asList(executableElement.getEnclosingElement())).get(0);
        String packageName = this.getPackageName(this.elements.getBinaryName(parentClass).toString());
        String className = StringUtils.capitalize((String)executableElement.getSimpleName().toString()) + append;
        return packageName + extraPackage + "." + className;
    }

    public String generateClassNameInPackage(Element element, String className) {
        String packageName;
        Element enclosingElement = element.getEnclosingElement();
        if (enclosingElement.getKind() == ElementKind.CLASS) {
            packageName = this.getPackageName(this.getBinaryName((TypeElement)enclosingElement));
        } else if (enclosingElement.getEnclosingElement() != null) {
            TypeElement parentClass = ElementFilter.typesIn(Arrays.asList(enclosingElement.getEnclosingElement())).get(0);
            packageName = this.getPackageName(this.getBinaryName(parentClass));
        } else {
            DeclaredType declaredType = (DeclaredType)element.asType();
            packageName = this.getPackageName(declaredType.toString());
        }
        return packageName + "." + className;
    }

    public String generateClassNameInPackage(TypeElement typeElement, String extraPackage, String className) {
        String packageName = this.getPackageName(this.getBinaryName(typeElement));
        return packageName + extraPackage + "." + className;
    }

    public String generateModuleObjectRoleKey(TypeElement typeElement) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + "." + className + "ModuleObject";
    }

    public String generateConnectorObjectRoleKey(TypeElement typeElement) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + "." + className + "Connector";
    }

    public String generateConnectionParametersRoleKey(TypeElement typeElement) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + "." + className + "ConnectionKey";
    }

    public String generateConnectionManagerRoleKey(TypeElement typeElement) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + "." + className + "ConnectionManager";
    }

    public String getBinaryName(TypeElement typeElement) {
        if (typeElement instanceof TypeElementImpl) {
            typeElement = ((DefaultDevKitTypeElement)typeElement).unWrap();
        }
        return this.elements.getBinaryName(typeElement).toString();
    }

    public String generateConfigDefParserRoleKey(TypeElement typeElement) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + "." + className + "ConfigDefinitionParser";
    }

    public String generatePoolingProfileDefParserRoleKey(TypeElement typeElement) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + "." + className + "PoolingProfileDefinitionParser";
    }

    public String generatePojoFactoryKey(TypeElement typeElement) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + "." + className + "Factory";
    }

    public String generatePoolObjectRoleKey(TypeElement typeElement) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + "." + className + "PoolObject";
    }

    public String generateClassName(TypeElement typeElement, String extraPackage, String classNameAppend) {
        String typeFullName = this.getBinaryName(typeElement);
        String pkg = this.getPackageName(typeFullName);
        String className = this.getClassName(typeFullName);
        return pkg + extraPackage + "." + className + classNameAppend;
    }

    static {
        NameUtils.plural("$", "s");
        NameUtils.plural("s$", "s");
        NameUtils.plural("(ax|test)is$", "$1es");
        NameUtils.plural("(octop|vir)us$", "$1i");
        NameUtils.plural("(alias|status)$", "$1es");
        NameUtils.plural("(bu)s$", "$1ses");
        NameUtils.plural("(buffal|tomat)o$", "$1oes");
        NameUtils.plural("([ti])um$", "$1a");
        NameUtils.plural("sis$", "ses");
        NameUtils.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        NameUtils.plural("(hive)$", "$1s");
        NameUtils.plural("([^aeiouy]|qu)y$", "$1ies");
        NameUtils.plural("(x|ch|ss|sh)$", "$1es");
        NameUtils.plural("(matr|vert|ind)ix|ex$", "$1ices");
        NameUtils.plural("([m|l])ouse$", "$1ice");
        NameUtils.plural("^(ox)$", "$1en");
        NameUtils.plural("(quiz)$", "$1zes");
        NameUtils.singular("s$", "");
        NameUtils.singular("(n)ews$", "$1ews");
        NameUtils.singular("([ti])a$", "$1um");
        NameUtils.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        NameUtils.singular("(^analy)ses$", "$1sis");
        NameUtils.singular("([^f])ves$", "$1fe");
        NameUtils.singular("(hive)s$", "$1");
        NameUtils.singular("(tive)s$", "$1");
        NameUtils.singular("([lr])ves$", "$1f");
        NameUtils.singular("([^aeiouy]|qu)ies$", "$1y");
        NameUtils.singular("(s)eries$", "$1eries");
        NameUtils.singular("(m)ovies$", "$1ovie");
        NameUtils.singular("(x|ch|ss|sh)es$", "$1");
        NameUtils.singular("([m|l])ice$", "$1ouse");
        NameUtils.singular("(bus)es$", "$1");
        NameUtils.singular("(o)es$", "$1");
        NameUtils.singular("(shoe)s$", "$1");
        NameUtils.singular("(cris|ax|test)es$", "$1is");
        NameUtils.singular("(octop|vir)i$", "$1us");
        NameUtils.singular("(alias|status)es$", "$1");
        NameUtils.singular("^(ox)en", "$1");
        NameUtils.singular("(vert|ind)ices$", "$1ex");
        NameUtils.singular("(matr)ices$", "$1ix");
        NameUtils.singular("(quiz)zes$", "$1");
        NameUtils.irregular("person", "people");
        NameUtils.irregular("man", "men");
        NameUtils.irregular("child", "children");
        NameUtils.irregular("sex", "sexes");
        NameUtils.irregular("move", "moves");
        NameUtils.uncountable("equipment");
        NameUtils.uncountable("information");
        NameUtils.uncountable("rice");
        NameUtils.uncountable("money");
        NameUtils.uncountable("species");
        NameUtils.uncountable("series");
        NameUtils.uncountable("fish");
        NameUtils.uncountable("sheep");
    }

    private static class Inflection {
        private String pattern;
        private String replacement;
        private boolean ignoreCase;

        public Inflection(String pattern) {
            this(pattern, null, true);
        }

        public Inflection(String pattern, String replacement) {
            this(pattern, replacement, true);
        }

        public Inflection(String pattern, String replacement, boolean ignoreCase) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.ignoreCase = ignoreCase;
        }

        public boolean match(String word) {
            int flags = 0;
            if (this.ignoreCase) {
                flags |= 2;
            }
            return Pattern.compile(this.pattern, flags).matcher(word).find();
        }

        public String replace(String word) {
            int flags = 0;
            if (this.ignoreCase) {
                flags |= 2;
            }
            return Pattern.compile(this.pattern, flags).matcher(word).replaceAll(this.replacement);
        }
    }
}

