/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.Transformer;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.config.spring.parsers.specific.MessageProcessorDefinitionParser;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class NamespaceHandlerGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(Module.class) || typeElement.hasAnnotation(Connector.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        DefinedClass namespaceHandlerClass = this.getNamespaceHandlerClass(typeElement);
        Method init = namespaceHandlerClass.method(1, (Type)this.context.getCodeModel().VOID, "init");
        init.javadoc().add((Object)"Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. \n@see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)");
        this.registerConfig(init, typeElement);
        this.registerBeanDefinitionParserForEachProcessor(typeElement, init);
        this.registerBeanDefinitionParserForEachSource(typeElement, init);
        this.registerBeanDefinitionParserForEachTransformer(typeElement, init);
    }

    private DefinedClass getNamespaceHandlerClass(DevKitTypeElement typeElement) {
        String namespaceHandlerName = this.context.getNameUtils().generateClassName(typeElement, ".config", "NamespaceHandler");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(namespaceHandlerName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(namespaceHandlerName), NamespaceHandlerSupport.class);
        String targetNamespace = typeElement.namespace();
        if (targetNamespace == null || targetNamespace.length() == 0) {
            targetNamespace = "http://www.mulesoft.org/schema/mule/" + typeElement.name();
        }
        clazz.javadoc().add((Object)("Registers bean definitions parsers for handling elements in <code>" + targetNamespace + "</code>."));
        return clazz;
    }

    private void registerConfig(Method init, TypeElement pojo) {
        DefinedClass configBeanDefinitionParser = this.context.getClassForRole(this.context.getNameUtils().generateConfigDefParserRoleKey(pojo));
        init.body().invoke("registerBeanDefinitionParser").arg("config").arg((Expression)ExpressionFactory._new((TypeReference)configBeanDefinitionParser));
    }

    private void registerBeanDefinitionParserForEachProcessor(DevKitTypeElement typeElement, Method init) {
        if (typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class)) {
            DefinedClass authorizeMessageProcessorClass = this.context.getClassForRole("AuthorizeDefinitionParser");
            init.body().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)"authorize")).arg((Expression)ExpressionFactory._new((TypeReference)authorizeMessageProcessorClass));
        }
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            this.registerBeanDefinitionParserForProcessor(init, executableElement);
        }
    }

    private void registerBeanDefinitionParserForEachSource(DevKitTypeElement typeElement, Method init) {
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Source.class)) {
            this.registerBeanDefinitionParserForSource(init, executableElement);
        }
    }

    private void registerBeanDefinitionParserForEachTransformer(DevKitTypeElement typeElement, Method init) {
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Transformer.class)) {
            Invocation registerMuleBeanDefinitionParser = init.body().invoke("registerBeanDefinitionParser");
            registerMuleBeanDefinitionParser.arg(ExpressionFactory.lit((String)this.context.getNameUtils().uncamel(executableElement.getSimpleName().toString())));
            String transformerClassName = this.context.getNameUtils().generateClassName(executableElement, "Transformer");
            transformerClassName = this.context.getNameUtils().getPackageName(transformerClassName) + ".transformers" + "." + this.context.getNameUtils().getClassName(transformerClassName);
            registerMuleBeanDefinitionParser.arg((Expression)ExpressionFactory._new((TypeReference)this.ref(MessageProcessorDefinitionParser.class)).arg(this.ref(transformerClassName).boxify().dotclass()));
        }
    }

    private void registerBeanDefinitionParserForProcessor(Method init, ExecutableElement executableElement) {
        DefinedClass beanDefinitionParser = this.getBeanDefinitionParserClass(executableElement);
        Processor processor = executableElement.getAnnotation(Processor.class);
        String elementName = executableElement.getSimpleName().toString();
        if (processor.name().length() != 0) {
            elementName = processor.name();
        }
        init.body().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)this.context.getNameUtils().uncamel(elementName))).arg((Expression)ExpressionFactory._new((TypeReference)beanDefinitionParser));
    }

    private void registerBeanDefinitionParserForSource(Method init, ExecutableElement executableElement) {
        DefinedClass beanDefinitionParser = this.getBeanDefinitionParserClass(executableElement);
        Source source = executableElement.getAnnotation(Source.class);
        String elementName = executableElement.getSimpleName().toString();
        if (source.name().length() != 0) {
            elementName = source.name();
        }
        init.body().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)this.context.getNameUtils().uncamel(elementName))).arg((Expression)ExpressionFactory._new((TypeReference)beanDefinitionParser));
    }
}

