/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio.editor;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.Transformer;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.editor.AbstractTransformerBuilder;
import org.mule.devkit.generation.mule.studio.editor.ConfigRefBuilder;
import org.mule.devkit.generation.mule.studio.editor.EndpointTypeBuilder;
import org.mule.devkit.generation.mule.studio.editor.EndpointTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.editor.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.generation.mule.studio.editor.GlobalEndpointTypeBuilder;
import org.mule.devkit.generation.mule.studio.editor.GlobalEndpointTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.editor.GlobalEndpointTypeWithNameBuilder;
import org.mule.devkit.generation.mule.studio.editor.GlobalTransformerTypeBuilder;
import org.mule.devkit.generation.mule.studio.editor.GlobalTransformerTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.editor.OAuthPatternTypeBuilder;
import org.mule.devkit.generation.mule.studio.editor.OAuthPatternTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.editor.PatternTypeBuilder;
import org.mule.devkit.generation.mule.studio.editor.PatternTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.editor.PatternTypes;
import org.mule.devkit.model.studio.EndpointType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.NamespaceType;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.PatternType;

public class MuleStudioEditorXmlGenerator
extends AbstractMessageGenerator {
    public static final String EDITOR_XML_FILE_NAME = "editors.xml";
    public static final String URI_PREFIX = "http://www.mulesoft.org/schema/mule/";
    public static final String GLOBAL_CLOUD_CONNECTOR_LOCAL_ID = "config";
    public static final String ATTRIBUTE_CATEGORY_DEFAULT_CAPTION = "General";
    public static final String ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION = "General";
    public static final String CONNECTION_ATTRIBUTE_CATEGORY_CAPTION = "Connection";
    public static final String GROUP_DEFAULT_CAPTION = "Generic";
    private ObjectFactory objectFactory = new ObjectFactory();

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.context.hasOption("skipStudioPluginPackage");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        String moduleName = typeElement.name();
        boolean isOAuth = typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class);
        NamespaceType namespace = new NamespaceType();
        namespace.setPrefix(moduleName);
        namespace.setUrl(URI_PREFIX + moduleName);
        PatternTypeOperationsBuilder operationsBuilder = isOAuth ? new OAuthPatternTypeOperationsBuilder(this.context, typeElement, PatternTypes.CLOUD_CONNECTOR) : new PatternTypeOperationsBuilder(this.context, typeElement, PatternTypes.CLOUD_CONNECTOR);
        GlobalType globalCloudConnector = new GlobalCloudConnectorTypeBuilder(this.context, typeElement).build();
        namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalCloudConnector(globalCloudConnector));
        namespace.getConnectorOrEndpointOrGlobal().add(operationsBuilder.build());
        namespace.getConnectorOrEndpointOrGlobal().add(new ConfigRefBuilder(this.context, typeElement).build());
        this.processProcessorMethods(typeElement, namespace, isOAuth);
        this.processTransformerMethods(typeElement, namespace);
        this.processSourceMethods(typeElement, namespace);
        this.context.getStudioModel().setNamespaceType(namespace);
        this.context.getStudioModel().setOutputFileName(EDITOR_XML_FILE_NAME);
    }

    private void processProcessorMethods(DevKitTypeElement typeElement, NamespaceType namespace, boolean isOAuth) {
        for (ExecutableElement processorMethod : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            PatternType cloudConnector = new PatternTypeBuilder(this.context, processorMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeCloudConnector(cloudConnector));
        }
        if (isOAuth) {
            PatternType authorize = new OAuthPatternTypeBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeCloudConnector(authorize));
        }
    }

    private void processTransformerMethods(DevKitTypeElement typeElement, NamespaceType namespace) {
        List<ExecutableElement> transformerMethods = typeElement.getMethodsAnnotatedWith(Transformer.class);
        if (!transformerMethods.isEmpty()) {
            namespace.getConnectorOrEndpointOrGlobal().add(new PatternTypeOperationsBuilder(this.context, typeElement, PatternTypes.TRANSFORMER).build());
            namespace.getConnectorOrEndpointOrGlobal().add(new AbstractTransformerBuilder(this.context, typeElement).build());
            GlobalType globalTransformer = new GlobalTransformerTypeOperationsBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalTransformer(globalTransformer));
        }
        for (ExecutableElement transformerMethod : transformerMethods) {
            PatternType transformer = new PatternTypeBuilder(this.context, transformerMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeTransformer(transformer));
            GlobalType globalTransformer = new GlobalTransformerTypeBuilder(this.context, transformerMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalTransformer(globalTransformer));
        }
    }

    private void processSourceMethods(DevKitTypeElement typeElement, NamespaceType namespace) {
        List<ExecutableElement> sourceMethods = typeElement.getMethodsAnnotatedWith(Source.class);
        if (!sourceMethods.isEmpty()) {
            GlobalType abstractGlobalEndpoint = new GlobalEndpointTypeWithNameBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalEndpoint(abstractGlobalEndpoint));
            EndpointType endpointTypeListingOps = new EndpointTypeOperationsBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createEndpoint(endpointTypeListingOps));
            GlobalType globalEndpointListingOps = new GlobalEndpointTypeOperationsBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalEndpoint(globalEndpointListingOps));
        }
        for (ExecutableElement sourceMethod : sourceMethods) {
            EndpointType endpoint = new EndpointTypeBuilder(this.context, sourceMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createEndpoint(endpoint));
            GlobalType globalEndpoint = new GlobalEndpointTypeBuilder(this.context, sourceMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalEndpoint(globalEndpoint));
        }
    }
}

