/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.xml.bind.JAXBElement;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.display.Placement;
import org.mule.api.annotations.param.Default;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.editor.EnumElementComparator;
import org.mule.devkit.generation.mule.studio.editor.MuleStudioUtils;
import org.mule.devkit.generation.mule.studio.editor.VariableComparator;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.ModeElementType;
import org.mule.devkit.model.studio.ModeType;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.ObjectListAttributeType;
import org.mule.devkit.model.studio.StringListAttributeType;
import org.mule.devkit.model.studio.StringMapAttributeType;
import org.mule.devkit.utils.JavaDocUtils;
import org.mule.devkit.utils.NameUtils;
import org.mule.devkit.utils.TypeMirrorUtils;
import org.mule.util.StringUtils;

public abstract class BaseStudioXmlBuilder {
    public static final String GENERAL_GROUP_NAME = "General";
    public static final String CONNECTION_GROUP_NAME = "Connection";
    public static final String CONNECTION_GROUP_LABEL = "Use these fields to override the credentials defined in the %s connector.";
    protected ObjectFactory objectFactory;
    protected MuleStudioUtils helper;
    protected DevKitTypeElement typeElement;
    protected ExecutableElement executableElement;
    protected NameUtils nameUtils;
    protected JavaDocUtils javaDocUtils;
    protected TypeMirrorUtils typeMirrorUtils;
    protected Types typeUtils;
    protected String moduleName;
    protected GeneratorContext context;

    protected BaseStudioXmlBuilder(GeneratorContext context) {
        this.context = context;
        this.nameUtils = context.getNameUtils();
        this.javaDocUtils = context.getJavaDocUtils();
        this.typeMirrorUtils = context.getTypeMirrorUtils();
        this.typeUtils = context.getTypeUtils();
        this.helper = new MuleStudioUtils(context);
        this.objectFactory = new ObjectFactory();
    }

    protected BaseStudioXmlBuilder(GeneratorContext context, DevKitTypeElement typeElement) {
        this(context);
        this.typeElement = typeElement;
        this.moduleName = typeElement.name();
    }

    protected Group createGroupWithModeSwitch(List<ExecutableElement> methods) {
        ModeType modeSwitch = new ModeType();
        modeSwitch.getMode().addAll(this.getModes(methods));
        modeSwitch.setCaption(this.helper.formatCaption("Operation"));
        modeSwitch.setName(StringUtils.capitalize((String)this.moduleName) + " operations to execute");
        modeSwitch.setDescription(this.helper.formatDescription("Operation"));
        Group group = new Group();
        group.setId(this.typeElement.name() + "ConnectorGeneric");
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupModeSwitch(modeSwitch));
        group.setCaption(this.helper.formatCaption("Generic"));
        return group;
    }

    protected List<ModeElementType> getModes(List<ExecutableElement> methods) {
        ArrayList<ModeElementType> modes = new ArrayList<ModeElementType>();
        for (ExecutableElement method : methods) {
            ModeElementType mode = new ModeElementType();
            mode.setModeId("http://www.mulesoft.org/schema/mule/" + this.typeElement.name() + '/' + this.helper.getLocalId(method));
            mode.setModeLabel(StringUtils.capitalize((String)this.helper.getFriendlyName(method)));
            modes.add(mode);
        }
        return modes;
    }

    protected BaseStudioXmlBuilder(GeneratorContext context, ExecutableElement executableElement, DevKitTypeElement typeElement) {
        this(context, typeElement);
        this.executableElement = executableElement;
    }

    protected List<AttributeCategory> processMethodParameters() {
        return this.processVariableElements(this.getParametersSorted());
    }

    protected List<AttributeCategory> processConfigurableFields(Group defaultGroup) {
        List<AttributeCategory> attributeCategories = this.processVariableElements(this.getConfigurableFieldsSorted());
        for (AttributeCategory attributeCategory : attributeCategories) {
            if (!attributeCategory.getCaption().equals(GENERAL_GROUP_NAME)) continue;
            attributeCategory.setDescription(this.helper.formatDescription(this.typeElement.name() + " configuration properties"));
            List groups = attributeCategory.getGroup();
            if (groups.isEmpty()) {
                groups.add(defaultGroup);
                continue;
            }
            groups.add(0, defaultGroup);
        }
        if (attributeCategories.isEmpty()) {
            AttributeCategory attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.getFormattedCaption(this.typeElement));
            attributeCategory.setDescription(this.helper.formatDescription(this.typeElement.name() + " configuration properties"));
            attributeCategory.getGroup().add(defaultGroup);
            attributeCategories.add(attributeCategory);
        }
        return attributeCategories;
    }

    private List<AttributeCategory> processVariableElements(List<? extends VariableElement> variableElements) {
        LinkedHashMap<String, Group> groupsByName = new LinkedHashMap<String, Group>();
        LinkedHashMap<String, AttributeCategory> attributeCategoriesByName = new LinkedHashMap<String, AttributeCategory>();
        this.getOrCreateDefaultAttributeCategory(attributeCategoriesByName);
        this.processConnectionAttributes(groupsByName, attributeCategoriesByName);
        for (VariableElement variableElement : variableElements) {
            JAXBElement<? extends AttributeType> jaxbElement = this.createJaxbElement(variableElement);
            AttributeCategory attributeCategory = this.getOrCreateAttributeCategory(attributeCategoriesByName, variableElement.getAnnotation(Placement.class));
            Group group = this.getOrCreateGroup(groupsByName, variableElement);
            group.getRegexpOrEncodingOrModeSwitch().add(jaxbElement);
            if (attributeCategory.getGroup().contains(group)) continue;
            attributeCategory.getGroup().add(group);
        }
        return new ArrayList<AttributeCategory>(attributeCategoriesByName.values());
    }

    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
    }

    private AttributeCategory getOrCreateDefaultAttributeCategory(Map<String, AttributeCategory> attributeCategoriesByName) {
        return this.getOrCreateAttributeCategory(attributeCategoriesByName, null);
    }

    private AttributeCategory getOrCreateAttributeCategory(Map<String, AttributeCategory> attributeCategoriesByName, Placement placement) {
        if (placement == null || StringUtils.isBlank((String)placement.tab())) {
            if (!attributeCategoriesByName.containsKey(GENERAL_GROUP_NAME)) {
                AttributeCategory attributeCategoryGeneral = new AttributeCategory();
                attributeCategoryGeneral.setCaption(this.helper.formatCaption(GENERAL_GROUP_NAME));
                attributeCategoryGeneral.setDescription(this.helper.formatDescription(GENERAL_GROUP_NAME));
                attributeCategoriesByName.put(GENERAL_GROUP_NAME, attributeCategoryGeneral);
            }
            return attributeCategoriesByName.get(GENERAL_GROUP_NAME);
        }
        String attributeCategoryName = StringUtils.isNotBlank((String)placement.tab()) ? placement.tab() : GENERAL_GROUP_NAME;
        if (!attributeCategoriesByName.containsKey(attributeCategoryName)) {
            AttributeCategory attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.formatCaption(attributeCategoryName));
            attributeCategory.setDescription(this.helper.formatDescription(attributeCategoryName));
            attributeCategoriesByName.put(attributeCategoryName, attributeCategory);
        }
        return attributeCategoriesByName.get(attributeCategoryName);
    }

    private Group getOrCreateGroup(Map<String, Group> groupsByName, VariableElement parameter) {
        Placement placement = parameter.getAnnotation(Placement.class);
        if (placement == null || StringUtils.isBlank((String)placement.group())) {
            if (!groupsByName.containsKey(GENERAL_GROUP_NAME)) {
                Group groupGeneral = new Group();
                groupGeneral.setCaption(this.helper.formatCaption(GENERAL_GROUP_NAME));
                groupGeneral.setId(StringUtils.uncapitalize((String)GENERAL_GROUP_NAME));
                groupsByName.put(GENERAL_GROUP_NAME, groupGeneral);
            }
            return groupsByName.get(GENERAL_GROUP_NAME);
        }
        String groupName = placement.group();
        if (!groupsByName.containsKey(groupName)) {
            Group group = new Group();
            group.setCaption(groupName);
            group.setId(StringUtils.uncapitalize((String)groupName));
            groupsByName.put(groupName, group);
        }
        return groupsByName.get(groupName);
    }

    private JAXBElement<? extends AttributeType> createJaxbElement(VariableElement parameter) {
        EnumType attributeType;
        if (this.typeMirrorUtils.isEnum(parameter)) {
            attributeType = this.createEnumType(parameter);
        } else if (this.isListOfMaps(parameter)) {
            ObjectListAttributeType objectListAttributeType = new ObjectListAttributeType();
            objectListAttributeType.setJavaType(this.typeMirrorUtils.getJavaType(parameter));
            if (this.executableElement != null) {
                objectListAttributeType.setDescription(this.helper.formatDescription(this.javaDocUtils.getParameterSummary(parameter.getSimpleName().toString(), this.executableElement)));
            } else {
                objectListAttributeType.setDescription(this.helper.formatDescription(this.javaDocUtils.getSummary(parameter)));
            }
            objectListAttributeType.setLocalName(this.helper.getLocalId(this.executableElement, parameter));
            objectListAttributeType.setCaption(this.helper.getFormattedCaption(parameter));
            objectListAttributeType.setListName(this.nameUtils.uncamel(parameter.getSimpleName().toString()));
            objectListAttributeType.setItemName(this.nameUtils.uncamel(this.nameUtils.singularize(parameter.getSimpleName().toString())));
            objectListAttributeType.setInnerName(this.nameUtils.uncamel("inner-" + this.nameUtils.singularize(parameter.getSimpleName().toString())));
            Default annotation = parameter.getAnnotation(Default.class);
            if (annotation != null) {
                objectListAttributeType.setDefaultValue(annotation.value());
            }
            attributeType = objectListAttributeType;
        } else if (this.isSimpleList(parameter)) {
            StringListAttributeType stringList = new StringListAttributeType();
            stringList.setJavaType(this.typeMirrorUtils.getJavaType(parameter));
            if (this.executableElement != null) {
                stringList.setDescription(this.helper.formatDescription(this.javaDocUtils.getParameterSummary(parameter.getSimpleName().toString(), this.executableElement)));
            } else {
                stringList.setDescription(this.helper.formatDescription(this.javaDocUtils.getSummary(parameter)));
            }
            stringList.setLocalName(this.helper.getLocalId(this.executableElement, parameter));
            stringList.setCaption(this.helper.getFormattedCaption(parameter));
            stringList.setListName(this.nameUtils.uncamel(parameter.getSimpleName().toString()));
            stringList.setItemName(this.nameUtils.uncamel(this.nameUtils.singularize(parameter.getSimpleName().toString())));
            Default annotation = parameter.getAnnotation(Default.class);
            if (annotation != null) {
                stringList.setDefaultValue(annotation.value());
            }
            attributeType = stringList;
        } else if (this.isSimpleMap(parameter)) {
            StringMapAttributeType stringMap = new StringMapAttributeType();
            stringMap.setJavaType(this.typeMirrorUtils.getJavaType(parameter));
            if (this.executableElement != null) {
                stringMap.setDescription(this.helper.formatDescription(this.javaDocUtils.getParameterSummary(parameter.getSimpleName().toString(), this.executableElement)));
            } else {
                stringMap.setDescription(this.helper.formatDescription(this.javaDocUtils.getSummary(parameter)));
            }
            stringMap.setLocalName(this.helper.getLocalId(this.executableElement, parameter));
            stringMap.setCaption(this.helper.getFormattedCaption(parameter));
            stringMap.setMapName(this.nameUtils.uncamel(parameter.getSimpleName().toString()));
            stringMap.setItemName(this.nameUtils.uncamel(this.nameUtils.singularize(parameter.getSimpleName().toString())));
            attributeType = stringMap;
            Default annotation = parameter.getAnnotation(Default.class);
            if (annotation != null) {
                stringMap.setDefaultValue(annotation.value());
            }
        } else {
            attributeType = this.createAttributeType(parameter);
        }
        return this.helper.createJAXBElement((AttributeType)attributeType);
    }

    private boolean isListOfMaps(VariableElement parameter) {
        TypeMirror typeMirror = parameter.asType();
        if (!(typeMirror instanceof DeclaredType)) {
            return false;
        }
        List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
        return this.typeMirrorUtils.isArrayOrList(typeMirror) && !typeArguments.isEmpty() && this.typeMirrorUtils.isMap(typeArguments.get(0));
    }

    private boolean isSimpleMap(VariableElement parameter) {
        TypeMirror typeMirror = parameter.asType();
        if (!(typeMirror instanceof DeclaredType)) {
            return false;
        }
        List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
        return this.typeMirrorUtils.isMap(typeMirror) && (typeArguments.isEmpty() || !this.typeMirrorUtils.isCollection(typeArguments.get(1)));
    }

    private boolean isSimpleList(VariableElement parameter) {
        TypeMirror typeMirror = parameter.asType();
        if (!(typeMirror instanceof DeclaredType)) {
            return false;
        }
        List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
        return this.typeMirrorUtils.isArrayOrList(typeMirror) && (typeArguments.isEmpty() || !this.typeMirrorUtils.isCollection(typeArguments.get(0)));
    }

    private List<? extends VariableElement> getParametersSorted() {
        ArrayList<? extends VariableElement> parameters = new ArrayList<VariableElement>(this.executableElement.getParameters());
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            if (!this.typeMirrorUtils.ignoreParameter((Element)iterator.next())) continue;
            iterator.remove();
        }
        Collections.sort(parameters, new VariableComparator(this.context));
        return parameters;
    }

    private AttributeType createAttributeType(VariableElement parameter) {
        AttributeType attributeType = this.helper.createAttributeTypeIgnoreEnumsAndCollections(parameter);
        if (attributeType != null) {
            this.helper.setAttributeTypeInfo(parameter, attributeType);
        }
        return attributeType;
    }

    protected List<AttributeType> getConnectionAttributes(DevKitTypeElement typeElement) {
        ArrayList<AttributeType> parameters = new ArrayList<AttributeType>();
        ExecutableElement connectMethod = typeElement.getMethodsAnnotatedWith(Connect.class).get(0);
        for (VariableElement variableElement : connectMethod.getParameters()) {
            AttributeType parameter = this.helper.createAttributeTypeIgnoreEnumsAndCollections(variableElement);
            this.helper.setAttributeTypeInfo(variableElement, parameter);
            parameter.setRequired(Boolean.valueOf(false));
            parameters.add(parameter);
        }
        return parameters;
    }

    private EnumType createEnumType(VariableElement parameter) {
        EnumType enumType = new EnumType();
        enumType.setSupportsExpressions(Boolean.valueOf(true));
        enumType.setAllowsCustom(Boolean.valueOf(true));
        this.helper.setAttributeTypeInfo(parameter, (AttributeType)enumType);
        for (Element element : this.typeUtils.asElement(parameter.asType()).getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            String enumConstant = element.getSimpleName().toString();
            EnumElement enumElement = new EnumElement();
            enumElement.setValue(enumConstant);
            enumType.getOption().add(enumElement);
        }
        Collections.sort(enumType.getOption(), new EnumElementComparator());
        return enumType;
    }

    private List<VariableElement> getConfigurableFieldsSorted() {
        List<VariableElement> configurableFields = this.typeElement.getFieldsAnnotatedWith(Configurable.class);
        Collections.sort(configurableFields, new VariableComparator(this.context));
        return configurableFields;
    }
}

