/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.lang.model.element.TypeElement;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.PlainTextMessageSigner;
import oauth.signpost.signature.QueryStringSigningStrategy;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuthConsumerKey;
import org.mule.api.annotations.oauth.OAuthConsumerSecret;
import org.mule.api.annotations.oauth.OAuthMessageSigner;
import org.mule.api.annotations.oauth.OAuthScope;
import org.mule.api.annotations.oauth.OAuthSigningStrategy;
import org.mule.api.oauth.OAuth1Adapter;
import org.mule.api.oauth.UnableToAcquireAccessTokenException;
import org.mule.api.oauth.UnableToAcquireRequestTokenException;
import org.mule.devkit.generation.AbstractOAuthAdapterGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.builders.FieldBuilder;

public class OAuth1AdapterGenerator
extends AbstractOAuthAdapterGenerator {
    private static final String REQUEST_TOKEN_FIELD_NAME = "requestToken";
    private static final String REQUEST_TOKEN_SECRET_FIELD_NAME = "requestTokenSecret";
    private static final String CONSUMER_FIELD_NAME = "consumer";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(OAuth.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass oauthAdapter = this.getOAuthAdapterClass(typeElement, "OAuth1Adapter", OAuth1Adapter.class);
        OAuth oauth = typeElement.getAnnotation(OAuth.class);
        this.authorizationCodePatternConstant(oauthAdapter, oauth.verifierRegex());
        this.muleContextField(oauthAdapter);
        FieldVariable logger = this.generateLoggerField(oauthAdapter);
        FieldVariable requestToken = this.requestTokenField(oauthAdapter);
        FieldVariable requestTokenSecret = this.requestTokenSecretField(oauthAdapter);
        FieldVariable oauthVerifier = this.authorizationCodeField(oauthAdapter);
        FieldVariable saveAccessTokenCallback = this.saveAccessTokenCallbackField(oauthAdapter);
        FieldVariable restoreAccessTokenCallback = this.restoreAccessTokenCallbackField(oauthAdapter);
        FieldVariable redirectUrl = this.redirectUrlField(oauthAdapter);
        FieldVariable oauthAccessToken = this.accessTokenField(oauthAdapter);
        FieldVariable oauthAccessTokenSecret = this.oauthAccessTokenSecretField(oauthAdapter);
        this.consumerField(oauthAdapter);
        this.oauthCallbackField(oauthAdapter);
        DefinedClass messageProcessor = this.generateMessageProcessorInnerClass(oauthAdapter);
        Method createConsumer = this.generateCreateConsumerMethod(oauthAdapter, oauth, typeElement);
        this.generateStartMethod(oauthAdapter);
        this.generateStopMethod(oauthAdapter);
        this.generateInitialiseMethod(oauthAdapter, messageProcessor, createConsumer, oauth);
        this.generateGetAuthorizationUrlMethod(oauthAdapter, requestToken, requestTokenSecret, redirectUrl, typeElement, oauth, logger);
        this.generateRestoreAccessTokenMethod(oauthAdapter, restoreAccessTokenCallback, logger);
        this.generateFetchAccessTokenMethod(oauthAdapter, requestToken, requestTokenSecret, saveAccessTokenCallback, oauthVerifier, typeElement, oauth, logger);
        this.generateHasBeenAuthorizedMethod(oauthAdapter, oauthAccessToken);
        this.generateOverrides(typeElement, oauthAdapter, oauthAccessToken, oauthAccessTokenSecret);
    }

    private FieldVariable requestTokenField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name(REQUEST_TOKEN_FIELD_NAME).build();
    }

    private FieldVariable requestTokenSecretField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name(REQUEST_TOKEN_SECRET_FIELD_NAME).build();
    }

    private FieldVariable oauthAccessTokenSecretField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("accessTokenSecret").getterAndSetter().build();
    }

    private FieldVariable consumerField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(OAuthConsumer.class).name(CONSUMER_FIELD_NAME).build();
    }

    private Method generateCreateConsumerMethod(DefinedClass oauthAdapter, OAuth oauth, TypeElement typeElement) {
        Method createConsumer = oauthAdapter.method(4, (Type)this.context.getCodeModel().VOID, "createConsumer");
        Invocation getConsumerKey = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(typeElement, OAuthConsumerKey.class));
        Invocation getConsumerSecret = ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(typeElement, OAuthConsumerSecret.class));
        FieldVariable consumer = (FieldVariable)oauthAdapter.fields().get(CONSUMER_FIELD_NAME);
        createConsumer.body().assign((AssignmentTarget)consumer, (Expression)ExpressionFactory._new((TypeReference)this.ref(DefaultOAuthConsumer.class)).arg((Expression)getConsumerKey).arg((Expression)getConsumerSecret));
        if (oauth.messageSigner().equals((Object)OAuthMessageSigner.HMAC_SHA1)) {
            createConsumer.body().invoke((Expression)consumer, "setMessageSigner").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(HmacSha1MessageSigner.class)));
        } else if (oauth.messageSigner().equals((Object)OAuthMessageSigner.PLAIN_TEXT)) {
            createConsumer.body().invoke((Expression)consumer, "setMessageSigner").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(PlainTextMessageSigner.class)));
        }
        if (oauth.signingStrategy().equals((Object)OAuthSigningStrategy.AUTHORIZATION_HEADER)) {
            createConsumer.body().invoke((Expression)consumer, "setSigningStrategy").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(AuthorizationHeaderSigningStrategy.class)));
        } else if (oauth.signingStrategy().equals((Object)OAuthSigningStrategy.QUERY_STRING)) {
            createConsumer.body().invoke((Expression)consumer, "setSigningStrategy").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(QueryStringSigningStrategy.class)));
        }
        return createConsumer;
    }

    private void generateInitialiseMethod(DefinedClass oauthAdapter, DefinedClass messageProcessor, Method createConsumer, OAuth oauth) {
        Method initialise = this.generateInitialiseMethod(oauthAdapter, messageProcessor, oauth.callbackPath());
        initialise.body().invoke(createConsumer);
    }

    private void generateGetAuthorizationUrlMethod(DefinedClass oauthAdapter, FieldVariable requestToken, FieldVariable requestTokenSecret, FieldVariable redirectUrl, DevKitTypeElement typeElement, OAuth oauth, FieldVariable logger) {
        Method getAuthorizationUrl = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "getAuthorizationUrl");
        getAuthorizationUrl._throws(this.ref(UnableToAcquireRequestTokenException.class));
        getAuthorizationUrl.type((Type)this.ref(String.class));
        Variable provider = this.generateProvider(oauth, getAuthorizationUrl.body(), typeElement);
        Variable authorizationUrl = getAuthorizationUrl.body().decl((Type)this.ref(String.class), "authorizationUrl");
        TryStatement tryRetrieveRequestToken = getAuthorizationUrl.body()._try();
        FieldVariable consumer = (FieldVariable)oauthAdapter.fields().get(CONSUMER_FIELD_NAME);
        Conditional ifDebugEnabled = tryRetrieveRequestToken.body()._if((Expression)logger.invoke("isDebugEnabled"));
        Variable messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to acquire a request token "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[consumer = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)consumer.invoke("getConsumerKey")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[consumerSecret = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)consumer.invoke("getConsumerSecret")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        tryRetrieveRequestToken.body().assign((AssignmentTarget)authorizationUrl, (Expression)provider.invoke("retrieveRequestToken").arg((Expression)consumer).arg((Expression)redirectUrl));
        this.generateReThrow(tryRetrieveRequestToken, OAuthMessageSignerException.class, UnableToAcquireRequestTokenException.class);
        this.generateReThrow(tryRetrieveRequestToken, OAuthNotAuthorizedException.class, UnableToAcquireRequestTokenException.class);
        this.generateReThrow(tryRetrieveRequestToken, OAuthExpectationFailedException.class, UnableToAcquireRequestTokenException.class);
        this.generateReThrow(tryRetrieveRequestToken, OAuthCommunicationException.class, UnableToAcquireRequestTokenException.class);
        ifDebugEnabled = tryRetrieveRequestToken.body()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Request token acquired "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[requestToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)consumer.invoke("getToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[requestTokenSecret = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)consumer.invoke("getTokenSecret")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        getAuthorizationUrl.body().assign((AssignmentTarget)requestToken, (Expression)consumer.invoke("getToken"));
        getAuthorizationUrl.body().assign((AssignmentTarget)requestTokenSecret, (Expression)consumer.invoke("getTokenSecret"));
        getAuthorizationUrl.body()._return((Expression)authorizationUrl);
    }

    private void generateRestoreAccessTokenMethod(DefinedClass oauthAdapter, FieldVariable restoreAccessTokenCallbackField, FieldVariable logger) {
        Method restoreAccessTokenMethod = oauthAdapter.method(1, (Type)this.context.getCodeModel().BOOLEAN, "restoreAccessToken");
        Conditional ifRestoreCallbackNotNull = restoreAccessTokenMethod.body()._if(Op.ne((Expression)restoreAccessTokenCallbackField, (Expression)ExpressionFactory._null()));
        Conditional ifDebugEnabled = ifRestoreCallbackNotNull._then()._if((Expression)logger.invoke("isDebugEnabled"));
        Variable messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to restore access token..."));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        TryStatement tryToRestore = ifRestoreCallbackNotNull._then()._try();
        tryToRestore.body().add((Statement)restoreAccessTokenCallbackField.invoke("restoreAccessToken"));
        tryToRestore.body().assign((AssignmentTarget)oauthAdapter.fields().get("accessToken"), (Expression)restoreAccessTokenCallbackField.invoke("getAccessToken"));
        tryToRestore.body().assign((AssignmentTarget)oauthAdapter.fields().get("accessTokenSecret"), (Expression)restoreAccessTokenCallbackField.invoke("getAccessTokenSecret"));
        ifDebugEnabled = tryToRestore.body()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Access token and secret has been restored successfully "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)restoreAccessTokenCallbackField.invoke("getAccessToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessTokenSecret = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)restoreAccessTokenCallbackField.invoke("getAccessTokenSecret")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        tryToRestore.body()._return(ExpressionFactory.TRUE);
        CatchBlock logIfCannotRestore = tryToRestore._catch(this.ref(Exception.class));
        Variable e = logIfCannotRestore.param("e");
        logIfCannotRestore.body().add((Statement)logger.invoke("error").arg("Cannot restore access token, an unexpected error occurred").arg((Expression)e));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        restoreAccessTokenMethod.body()._return(ExpressionFactory.FALSE);
    }

    private void generateFetchAccessTokenMethod(DefinedClass oauthAdapter, FieldVariable requestToken, FieldVariable requestTokenSecret, FieldVariable saveAccessTokenCallback, FieldVariable oauthVerifier, DevKitTypeElement typeElement, OAuth oauth, FieldVariable logger) {
        Method fetchAccessToken = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "fetchAccessToken");
        fetchAccessToken._throws(this.ref(UnableToAcquireAccessTokenException.class));
        fetchAccessToken.body().invoke("restoreAccessToken");
        Conditional ifAccessTokenNullOrSecretNull = fetchAccessToken.body()._if(Op.cor((Expression)Op.eq((Expression)((Expression)oauthAdapter.fields().get("accessToken")), (Expression)ExpressionFactory._null()), (Expression)Op.eq((Expression)((Expression)oauthAdapter.fields().get("accessTokenSecret")), (Expression)ExpressionFactory._null())));
        Variable provider = this.generateProvider(oauth, ifAccessTokenNullOrSecretNull._then(), typeElement);
        FieldVariable consumer = (FieldVariable)oauthAdapter.fields().get(CONSUMER_FIELD_NAME);
        ifAccessTokenNullOrSecretNull._then().invoke((Expression)consumer, "setTokenWithSecret").arg((Expression)requestToken).arg((Expression)requestTokenSecret);
        TryStatement tryRetrieveAccessToken = ifAccessTokenNullOrSecretNull._then()._try();
        Conditional ifDebugEnabled = tryRetrieveAccessToken.body()._if((Expression)logger.invoke("isDebugEnabled"));
        Variable messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Retrieving access token..."));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        tryRetrieveAccessToken.body().invoke((Expression)provider, "retrieveAccessToken").arg((Expression)consumer).arg((Expression)oauthVerifier);
        this.generateReThrow(tryRetrieveAccessToken, OAuthMessageSignerException.class, UnableToAcquireAccessTokenException.class);
        this.generateReThrow(tryRetrieveAccessToken, OAuthNotAuthorizedException.class, UnableToAcquireAccessTokenException.class);
        this.generateReThrow(tryRetrieveAccessToken, OAuthExpectationFailedException.class, UnableToAcquireAccessTokenException.class);
        this.generateReThrow(tryRetrieveAccessToken, OAuthCommunicationException.class, UnableToAcquireAccessTokenException.class);
        ifAccessTokenNullOrSecretNull._then().assign((AssignmentTarget)oauthAdapter.fields().get("accessToken"), (Expression)consumer.invoke("getToken"));
        ifAccessTokenNullOrSecretNull._then().assign((AssignmentTarget)oauthAdapter.fields().get("accessTokenSecret"), (Expression)consumer.invoke("getTokenSecret"));
        ifDebugEnabled = ifAccessTokenNullOrSecretNull._then()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Access token retrieved successfully "));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)oauthAdapter.fields().get("accessToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessTokenSecret = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)oauthAdapter.fields().get("accessTokenSecret")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        Conditional ifSaveCallbackNotNull = ifAccessTokenNullOrSecretNull._then()._if(Op.ne((Expression)saveAccessTokenCallback, (Expression)ExpressionFactory._null()));
        Invocation saveAccessToken = saveAccessTokenCallback.invoke("saveAccessToken").arg((Expression)oauthAdapter.fields().get("accessToken")).arg((Expression)oauthAdapter.fields().get("accessTokenSecret"));
        TryStatement tryToSave = ifSaveCallbackNotNull._then()._try();
        ifDebugEnabled = ifSaveCallbackNotNull._then()._if((Expression)logger.invoke("isDebugEnabled"));
        messageStringBuilder = ifDebugEnabled._then().decl((Type)this.ref(StringBuilder.class), "messageStringBuilder", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg("Attempting to save access token..."));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessToken = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)oauthAdapter.fields().get("accessToken")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"[accessTokenSecret = ")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg((Expression)oauthAdapter.fields().get("accessTokenSecret")));
        ifDebugEnabled._then().add((Statement)messageStringBuilder.invoke("append").arg(ExpressionFactory.lit((String)"] ")));
        ifDebugEnabled._then().add((Statement)logger.invoke("debug").arg((Expression)messageStringBuilder.invoke("toString")));
        tryToSave.body().add((Statement)saveAccessToken);
        CatchBlock logIfCannotSave = tryToSave._catch(this.ref(Exception.class));
        Variable e2 = logIfCannotSave.param("e");
        logIfCannotSave.body().add((Statement)logger.invoke("error").arg("Cannot save access token, an unexpected error occurred").arg((Expression)e2));
    }

    private Variable generateProvider(OAuth oauth, Block block, DevKitTypeElement typeElement) {
        Variable requestTokenUrl = block.decl((Type)this.ref(String.class), "requestTokenUrl", ExpressionFactory.lit((String)oauth.requestTokenUrl()));
        if (typeElement.hasFieldAnnotatedWith(OAuthScope.class)) {
            Variable scope = block.decl((Type)this.ref(String.class), "scope", (Expression)ExpressionFactory.invoke((String)this.getterMethodForFieldAnnotatedWith(typeElement, OAuthScope.class)));
            Block ifScopeNotNull = block._if(Op.ne((Expression)scope, (Expression)ExpressionFactory._null()))._then();
            TryStatement tryToEncodeScopeParam = ifScopeNotNull._try();
            Variable scopeParam = tryToEncodeScopeParam.body().decl((Type)this.ref(String.class), "scopeParam", (Expression)ExpressionFactory.lit((String)"?scope=").invoke("concat").arg((Expression)this.ref(URLEncoder.class).staticInvoke("encode").arg((Expression)scope).arg("UTF-8")));
            tryToEncodeScopeParam.body().assign((AssignmentTarget)requestTokenUrl, (Expression)requestTokenUrl.invoke("concat").arg((Expression)scopeParam));
            this.generateReThrow(tryToEncodeScopeParam, UnsupportedEncodingException.class, RuntimeException.class);
        }
        Variable provider = block.decl((Type)this.ref(OAuthProvider.class), "provider", (Expression)ExpressionFactory._new((TypeReference)this.ref(DefaultOAuthProvider.class)).arg((Expression)requestTokenUrl).arg(oauth.accessTokenUrl()).arg(oauth.authorizationUrl()));
        block.invoke((Expression)provider, "setOAuth10a").arg(ExpressionFactory.TRUE);
        return provider;
    }

    private void generateReThrow(TryStatement tryStatement, Class<? extends Exception> exceptionToCatch, Class<? extends Exception> exceptionToThrow) {
        CatchBlock catchBlock = tryStatement._catch(this.ref(exceptionToCatch));
        Variable caughtException = catchBlock.param("e");
        catchBlock.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(exceptionToThrow)).arg((Expression)caughtException));
    }
}

