/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.Capabilities;
import org.mule.api.ConnectionManager;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Cast;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;

public class ConnectionManagerGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        ExecutableElement connectMethod = this.connectMethodForClass(typeElement);
        ExecutableElement disconnectMethod = this.disconnectMethodForClass(typeElement);
        return connectMethod != null && disconnectMethod != null;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        ExecutableElement connectMethod = this.connectMethodForClass(typeElement);
        ExecutableElement disconnectMethod = this.disconnectMethodForClass(typeElement);
        ExecutableElement validateConnectionMethod = this.validateConnectionMethodForClass(typeElement);
        DefinedClass connectionManagerClass = this.getConnectionManagerAdapterClass(typeElement);
        Map<String, AbstractMessageGenerator.FieldVariableElement> fields = this.generateStandardFieldForEachParameter(connectionManagerClass, connectMethod);
        for (VariableElement field : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            FieldVariable configField = connectionManagerClass.field(4, this.ref(field.asType()), field.getSimpleName().toString());
            this.generateSetter(connectionManagerClass, configField);
            this.generateGetter(connectionManagerClass, configField);
        }
        FieldVariable logger = this.generateLoggerField(connectionManagerClass);
        FieldVariable muleContext = this.generateFieldForMuleContext(connectionManagerClass);
        FieldVariable flowConstruct = this.generateFieldForFlowConstruct(connectionManagerClass);
        FieldVariable connectionPool = this.generateFieldForConnectionPool(connectionManagerClass);
        FieldVariable poolingProfile = connectionManagerClass.field(2, (Type)this.ref(PoolingProfile.class), "connectionPoolingProfile");
        this.generateSetter(connectionManagerClass, poolingProfile);
        this.generateGetter(connectionManagerClass, poolingProfile);
        for (String fieldName : fields.keySet()) {
            this.generateSetter(connectionManagerClass, fields.get(fieldName).getField());
            this.generateGetter(connectionManagerClass, fields.get(fieldName).getField());
        }
        this.generateSetFlowConstructMethod(connectionManagerClass, flowConstruct);
        this.generateSetMuleContextMethod(connectionManagerClass, muleContext);
        DefinedClass connectionKeyClass = this.getConnectionParametersClass(typeElement, connectionManagerClass);
        Map<String, AbstractMessageGenerator.FieldVariableElement> keyFields = this.generateStandardFieldForEachParameter(connectionKeyClass, connectMethod);
        this.generateKeyConstructor(connectMethod, connectionKeyClass, keyFields);
        for (String fieldName : keyFields.keySet()) {
            this.generateSetter(connectionKeyClass, keyFields.get(fieldName).getField());
            this.generateGetter(connectionKeyClass, keyFields.get(fieldName).getField());
        }
        this.generateConnectionKeyHashCodeMethod(connectMethod, connectionKeyClass);
        this.generateConnectionKeyEqualsMethod(connectMethod, connectionKeyClass);
        DefinedClass connectionFactoryClass = this.getConnectorFactoryClass(connectionManagerClass);
        FieldVariable connectionManagerInFactory = connectionFactoryClass.field(4, (Type)connectionManagerClass, "connectionManager");
        Method connectionFactoryConstructor = connectionFactoryClass.constructor(1);
        Variable constructorConnectionManager = connectionFactoryConstructor.param((Type)connectionManagerClass, "connectionManager");
        connectionFactoryConstructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)connectionManagerInFactory), (Expression)constructorConnectionManager);
        this.generateMakeObjectMethod(typeElement, connectMethod, connectionFactoryClass, connectionKeyClass, connectionManagerInFactory);
        this.generateDestroyObjectMethod(connectMethod, disconnectMethod, connectionKeyClass, connectionFactoryClass);
        this.generateValidateObjectMethod(connectionFactoryClass, logger, validateConnectionMethod);
        this.generateActivateObjectMethod(connectionFactoryClass, validateConnectionMethod, connectMethod, keyFields, connectionKeyClass);
        this.generatePassivateObjectMethod(connectionFactoryClass);
        this.generateInitialiseMethod(connectionManagerClass, connectionPool, poolingProfile, connectionFactoryClass);
        this.generateBorrowConnectionMethod(connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateReturnConnectionMethod(connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateDestroyConnectionMethod(connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateIsCapableOf(typeElement, connectionManagerClass);
    }

    private void generateConnectionKeyHashCodeMethod(ExecutableElement connect, DefinedClass connectionKeyClass) {
        Method hashCode = connectionKeyClass.method(1, (Type)this.context.getCodeModel().INT, "hashCode");
        Variable hash = hashCode.body().decl((Type)this.context.getCodeModel().INT, "hash", ExpressionFactory.lit((int)1));
        for (VariableElement variableElement : connect.getParameters()) {
            if (variableElement.getAnnotation(ConnectionKey.class) == null) continue;
            String fieldName = variableElement.getSimpleName().toString();
            hashCode.body().assign((AssignmentTarget)hash, Op.plus((Expression)Op.mul((Expression)hash, (Expression)ExpressionFactory.lit((int)31)), (Expression)ExpressionFactory._this().ref(fieldName).invoke("hashCode")));
        }
        hashCode.body()._return((Expression)hash);
    }

    private void generateConnectionKeyEqualsMethod(ExecutableElement connect, DefinedClass connectionKey) {
        Method equals = connectionKey.method(1, (Type)this.context.getCodeModel().BOOLEAN, "equals");
        Variable obj = equals.param((Type)this.ref(Object.class), "obj");
        Expression areEqual = Op._instanceof((Expression)obj, (Type)connectionKey);
        for (VariableElement variableElement : connect.getParameters()) {
            if (variableElement.getAnnotation(ConnectionKey.class) == null) continue;
            String fieldName = variableElement.getSimpleName().toString();
            areEqual = Op.cand((Expression)areEqual, (Expression)Op.eq((Expression)ExpressionFactory._this().ref(fieldName), (Expression)ExpressionFactory.cast((Type)connectionKey, (Expression)obj).ref(fieldName)));
        }
        equals.body()._return(areEqual);
    }

    private void generateBorrowConnectionMethod(ExecutableElement connect, DefinedClass connectionManagerClass, FieldVariable connectionPool, DefinedClass connectionKeyClass) {
        DefinedClass connectorClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)connect.getEnclosingElement()));
        Method borrowConnector = connectionManagerClass.method(1, (Type)connectorClass, "acquireConnection");
        Variable key = borrowConnector.param((Type)connectionKeyClass, "key");
        borrowConnector._throws(this.ref(Exception.class));
        borrowConnector.body()._return((Expression)ExpressionFactory.cast((Type)connectorClass, (Expression)connectionPool.invoke("borrowObject").arg((Expression)key)));
    }

    private void generateReturnConnectionMethod(ExecutableElement connect, DefinedClass connectionManagerClass, FieldVariable connectionPool, DefinedClass connectionKeyClass) {
        DefinedClass connectorClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)connect.getEnclosingElement()));
        Method returnConnector = connectionManagerClass.method(1, (Type)this.context.getCodeModel().VOID, "releaseConnection");
        Variable key = returnConnector.param((Type)connectionKeyClass, "key");
        returnConnector._throws(this.ref(Exception.class));
        Variable connection = returnConnector.param((Type)connectorClass, "connection");
        returnConnector.body().add((Statement)connectionPool.invoke("returnObject").arg((Expression)key).arg((Expression)connection));
    }

    private void generateDestroyConnectionMethod(ExecutableElement connect, DefinedClass connectionManagerClass, FieldVariable connectionPool, DefinedClass connectionKeyClass) {
        DefinedClass connectorClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)connect.getEnclosingElement()));
        Method destroyConnector = connectionManagerClass.method(1, (Type)this.context.getCodeModel().VOID, "destroyConnection");
        Variable key = destroyConnector.param((Type)connectionKeyClass, "key");
        destroyConnector._throws(this.ref(Exception.class));
        Variable connection = destroyConnector.param((Type)connectorClass, "connection");
        destroyConnector.body().add((Statement)connectionPool.invoke("invalidateObject").arg((Expression)key).arg((Expression)connection));
    }

    private void generateInitialiseMethod(DefinedClass connectionManagerClass, FieldVariable connectionPool, FieldVariable connectionPoolingProfile, DefinedClass connectionFactoryClass) {
        Method initialisableMethod = connectionManagerClass.method(1, (Type)this.context.getCodeModel().VOID, "initialise");
        Variable config = initialisableMethod.body().decl((Type)this.ref(GenericKeyedObjectPool.Config.class), "config", (Expression)ExpressionFactory._new((TypeReference)this.ref(GenericKeyedObjectPool.Config.class)));
        Conditional ifNotNull = initialisableMethod.body()._if(Op.ne((Expression)connectionPoolingProfile, (Expression)ExpressionFactory._null()));
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxIdle"), (Expression)connectionPoolingProfile.invoke("getMaxIdle"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxActive"), (Expression)connectionPoolingProfile.invoke("getMaxActive"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxWait"), (Expression)connectionPoolingProfile.invoke("getMaxWait"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("whenExhaustedAction"), (Expression)ExpressionFactory.cast((Type)this.context.getCodeModel().BYTE, (Expression)connectionPoolingProfile.invoke("getExhaustedAction")));
        Invocation newObjectFactory = ExpressionFactory._new((TypeReference)connectionFactoryClass);
        newObjectFactory.arg(ExpressionFactory._this());
        initialisableMethod.body().assign((AssignmentTarget)connectionPool, (Expression)ExpressionFactory._new((TypeReference)this.ref(GenericKeyedObjectPool.class)).arg((Expression)newObjectFactory).arg((Expression)config));
    }

    private void generateActivateObjectMethod(DefinedClass connectionFactoryClass, ExecutableElement validateConnectionMethod, ExecutableElement connect, Map<String, AbstractMessageGenerator.FieldVariableElement> keyFields, DefinedClass connectionKeyClass) {
        DefinedClass connectorClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)validateConnectionMethod.getEnclosingElement()));
        Method activateObject = connectionFactoryClass.method(1, (Type)this.context.getCodeModel().VOID, "activateObject");
        activateObject._throws(this.ref(Exception.class));
        Variable key = activateObject.param(Object.class, "key");
        Variable obj = activateObject.param(Object.class, "obj");
        Conditional ifNotKey = activateObject.body()._if(Op.not((Expression)Op._instanceof((Expression)key, (Type)connectionKeyClass)));
        ifNotKey._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        Conditional ifNotObj = activateObject.body()._if(Op.not((Expression)Op._instanceof((Expression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        Cast casterConnector = ExpressionFactory.cast((Type)connectorClass, (Expression)obj);
        TryStatement tryDisconnect = activateObject.body()._try();
        Conditional ifNotConnected = tryDisconnect.body()._if(Op.not((Expression)casterConnector.invoke(validateConnectionMethod.getSimpleName().toString())));
        Cast castedConnectionKey = ExpressionFactory.cast((Type)connectionKeyClass, (Expression)key);
        Invocation connectInvoke = ExpressionFactory.cast((Type)connectorClass, (Expression)obj).invoke(connect.getSimpleName().toString());
        for (VariableElement variableElement : connect.getParameters()) {
            String fieldName = variableElement.getSimpleName().toString();
            connectInvoke.arg((Expression)castedConnectionKey.invoke("get" + StringUtils.capitalize((String)keyFields.get(fieldName).getField().name())));
        }
        ifNotConnected._then().add((Statement)connectInvoke);
        CatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        Variable variable = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((Expression)variable);
    }

    private void generatePassivateObjectMethod(DefinedClass connectionFactoryClass) {
        Method passivateObject = connectionFactoryClass.method(1, (Type)this.context.getCodeModel().VOID, "passivateObject");
        passivateObject._throws(this.ref(Exception.class));
        passivateObject.param(Object.class, "key");
        passivateObject.param(Object.class, "obj");
    }

    private void generateValidateObjectMethod(DefinedClass connectionFactoryClass, FieldVariable logger, ExecutableElement validateConnectionMethod) {
        DefinedClass connectorClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)validateConnectionMethod.getEnclosingElement()));
        Method validateObject = connectionFactoryClass.method(1, (Type)this.context.getCodeModel().BOOLEAN, "validateObject");
        validateObject.param(Object.class, "key");
        Variable obj = validateObject.param(Object.class, "obj");
        Conditional ifNotObj = validateObject.body()._if(Op.not((Expression)Op._instanceof((Expression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        Cast casterConnector = ExpressionFactory.cast((Type)connectorClass, (Expression)obj);
        TryStatement tryDisconnect = validateObject.body()._try();
        tryDisconnect.body()._return((Expression)casterConnector.invoke(validateConnectionMethod.getSimpleName().toString()));
        CatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        Variable e = catchAndRethrow.param("e");
        catchAndRethrow.body().add((Statement)logger.invoke("error").arg((Expression)e.invoke("getMessage")).arg((Expression)e));
        catchAndRethrow.body()._return(ExpressionFactory.FALSE);
    }

    private void generateDestroyObjectMethod(ExecutableElement connect, ExecutableElement disconnect, DefinedClass connectionKeyClass, DefinedClass connectionFactoryClass) {
        DefinedClass connectorClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)connect.getEnclosingElement()));
        Method destroyObject = connectionFactoryClass.method(1, (Type)this.context.getCodeModel().VOID, "destroyObject");
        destroyObject._throws(this.ref(Exception.class));
        Variable key = destroyObject.param(Object.class, "key");
        Variable obj = destroyObject.param(Object.class, "obj");
        Conditional ifNotKey = destroyObject.body()._if(Op.not((Expression)Op._instanceof((Expression)key, (Type)connectionKeyClass)));
        ifNotKey._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        Conditional ifNotObj = destroyObject.body()._if(Op.not((Expression)Op._instanceof((Expression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        Cast casterConnector = ExpressionFactory.cast((Type)connectorClass, (Expression)obj);
        TryStatement tryDisconnect = destroyObject.body()._try();
        tryDisconnect.body().add((Statement)casterConnector.invoke(disconnect.getSimpleName().toString()));
        CatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        Variable e = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((Expression)e);
        tryDisconnect._finally()._if(Op._instanceof((Expression)casterConnector, (Type)this.ref(Stoppable.class)))._then().add((Statement)casterConnector.invoke("stop"));
        tryDisconnect._finally()._if(Op._instanceof((Expression)casterConnector, (Type)this.ref(Disposable.class)))._then().add((Statement)casterConnector.invoke("dispose"));
    }

    private void generateMakeObjectMethod(DevKitTypeElement typeElement, ExecutableElement connect, DefinedClass connectionFactoryClass, DefinedClass connectionKey, FieldVariable connectionManagerInFactory) {
        DefinedClass connectorClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)connect.getEnclosingElement()));
        Method makeObject = connectionFactoryClass.method(1, Object.class, "makeObject");
        makeObject._throws(this.ref(Exception.class));
        Variable key = makeObject.param(Object.class, "key");
        Conditional ifNotKey = makeObject.body()._if(Op.not((Expression)Op._instanceof((Expression)key, (Type)connectionKey)));
        ifNotKey._then()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        Variable connector = makeObject.body().decl((Type)connectorClass, "connector", (Expression)ExpressionFactory._new((TypeReference)connectorClass));
        for (VariableElement field : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            makeObject.body().add((Statement)connector.invoke("set" + StringUtils.capitalize((String)field.getSimpleName().toString())).arg((Expression)connectionManagerInFactory.invoke("get" + StringUtils.capitalize((String)field.getSimpleName().toString()))));
        }
        makeObject.body()._if(Op._instanceof((Expression)connector, (Type)this.ref(Initialisable.class)))._then().add((Statement)connector.invoke("initialise"));
        makeObject.body()._if(Op._instanceof((Expression)connector, (Type)this.ref(Startable.class)))._then().add((Statement)connector.invoke("start"));
        this.setMuleContextToConnectorIfNecessary(connectionManagerInFactory, connectorClass, makeObject, connector);
        makeObject.body()._return((Expression)connector);
    }

    private void setMuleContextToConnectorIfNecessary(FieldVariable connectionManagerInFactory, DefinedClass connectorClass, Method makeObject, Variable connector) {
        Iterator implementsIterator = connectorClass._implements();
        while (implementsIterator.hasNext()) {
            TypeReference implementedInterface = (TypeReference)implementsIterator.next();
            if (!implementedInterface.equals(this.ref(MuleContextAware.class))) continue;
            makeObject.body()._if(Op._instanceof((Expression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)connector.invoke("setMuleContext").arg(ExpressionFactory.direct((String)(connectionManagerInFactory.name() + "." + "muleContext"))));
        }
    }

    private void generateKeyConstructor(ExecutableElement connect, DefinedClass connectionKeyClass, Map<String, AbstractMessageGenerator.FieldVariableElement> keyFields) {
        Method keyConstructor = connectionKeyClass.constructor(1);
        for (VariableElement variableElement : connect.getParameters()) {
            String fieldName = variableElement.getSimpleName().toString();
            Variable parameter = keyConstructor.param(this.ref(variableElement.asType()), fieldName);
            keyConstructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)keyFields.get(fieldName).getField()), (Expression)parameter);
        }
    }

    private FieldVariable generateFieldForConnectionPool(DefinedClass connectionManagerClass) {
        FieldVariable connectionPool = connectionManagerClass.field(4, (Type)this.ref(GenericKeyedObjectPool.class), "connectionPool");
        connectionPool.javadoc().add((Object)"Connector Pool");
        return connectionPool;
    }

    private DefinedClass getConnectionManagerAdapterClass(TypeElement typeElement) {
        String connectionManagerName = this.context.getNameUtils().generateClassName(typeElement, ".adapters", "ConnectionManager");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(connectionManagerName));
        DefinedClass classToExtend = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        this.context.setClassRole(this.context.getNameUtils().generateConnectorObjectRoleKey(typeElement), classToExtend);
        DefinedClass connectionManagerClass = pkg._class(this.context.getNameUtils().getClassName(connectionManagerName));
        connectionManagerClass._implements(this.ref(Initialisable.class));
        connectionManagerClass._implements(this.ref(Capabilities.class));
        connectionManagerClass._implements(this.ref(MuleContextAware.class));
        connectionManagerClass._implements(this.ref(ConnectionManager.class).narrow((TypeReference)this.getConnectionParametersClass(typeElement, connectionManagerClass)).narrow((TypeReference)classToExtend));
        this.context.setClassRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement), connectionManagerClass);
        connectionManagerClass.javadoc().add((Object)("A {@code " + connectionManagerClass.name() + "} is a wrapper around "));
        connectionManagerClass.javadoc().add((Object)this.ref(typeElement.asType()));
        connectionManagerClass.javadoc().add((Object)" that adds connection management capabilities to the pojo.");
        return connectionManagerClass;
    }

    private DefinedClass getConnectionParametersClass(TypeElement typeElement, DefinedClass connectionManagerClass) {
        try {
            DefinedClass connectionKey = connectionManagerClass._class(17, "ConnectionKey");
            connectionKey.javadoc().add((Object)"A tuple of connection parameters");
            this.context.setClassRole(this.context.getNameUtils().generateConnectionParametersRoleKey(typeElement), connectionKey);
            return connectionKey;
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
    }

    private DefinedClass getConnectorFactoryClass(DefinedClass connectorManagerClass) {
        try {
            DefinedClass objectFactory = connectorManagerClass._class(20, "ConnectionFactory");
            objectFactory._implements(KeyedPoolableObjectFactory.class);
            return objectFactory;
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
    }
}

