/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.ExpressionLanguage;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.TypeElementImpl;

public class DefaultDevKitTypeElement
extends TypeElementImpl
implements DevKitTypeElement {
    public DefaultDevKitTypeElement(TypeElement typeElement) {
        super(typeElement);
    }

    @Override
    public boolean needsConfig() {
        boolean needsConfig = false;
        for (VariableElement variable : this.getFieldsAnnotatedWith(Configurable.class)) {
            needsConfig = true;
        }
        if (this.typeElement.getAnnotation(OAuth.class) != null || this.typeElement.getAnnotation(OAuth2.class) != null) {
            needsConfig = true;
        }
        return needsConfig;
    }

    @Override
    public boolean hasProcessorMethodWithParameter(Class<?> parameterType) {
        for (ExecutableElement method : this.getMethodsAnnotatedWith(Processor.class)) {
            for (VariableElement variableElement : method.getParameters()) {
                if (!((Object)variableElement.asType()).toString().startsWith(parameterType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasProcessorMethodWithParameterListOf(Class<?> listGenericType) {
        for (ExecutableElement method : this.getMethodsAnnotatedWith(Processor.class)) {
            for (VariableElement variableElement : method.getParameters()) {
                List<? extends TypeMirror> typeArguments;
                if (!((Object)variableElement.asType()).toString().startsWith(List.class.getName()) || (typeArguments = ((DeclaredType)variableElement.asType()).getTypeArguments()).isEmpty() || !((Object)typeArguments.get(0)).toString().equals(listGenericType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return this.typeElement.getAnnotation(annotation) != null;
    }

    @Override
    public List<ExecutableElement> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : this.getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    public List<ExecutableElement> getMethodsWhoseParametersAreAnnotatedWith(Class<? extends Annotation> annotation) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : this.getMethods()) {
            for (VariableElement variableElement : method.getParameters()) {
                if (variableElement.getAnnotation(annotation) == null) continue;
                result.add(method);
            }
        }
        return result;
    }

    @Override
    public List<VariableElement> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        ArrayList<VariableElement> result = new ArrayList<VariableElement>();
        for (VariableElement field : this.getFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public boolean hasMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        for (ExecutableElement method : this.getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFieldAnnotatedWith(Class<? extends Annotation> annotation) {
        for (VariableElement field : this.getFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<VariableElement> getFields() {
        return ElementFilter.fieldsIn(this.typeElement.getEnclosedElements());
    }

    public TypeElement unWrap() {
        return this.typeElement;
    }

    @Override
    public List<ExecutableElement> getMethods() {
        return ElementFilter.methodsIn(this.typeElement.getEnclosedElements());
    }

    @Override
    public boolean isInterface() {
        return this.typeElement.getKind() == ElementKind.INTERFACE;
    }

    @Override
    public boolean isParametrized() {
        return !this.typeElement.getTypeParameters().isEmpty();
    }

    @Override
    public boolean isPublic() {
        return this.typeElement.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Override
    public TypeElement getInnerTypeElement() {
        return this.typeElement;
    }

    @Override
    public boolean isModuleOrConnector() {
        return this.hasAnnotation(Module.class) || this.hasAnnotation(Connector.class);
    }

    @Override
    public boolean isPoolable() {
        return this.hasAnnotation(Module.class) && this.getAnnotation(Module.class).poolable();
    }

    @Override
    public String minMuleVersion() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).minMuleVersion();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).minMuleVersion();
        }
        if (this.hasAnnotation(ExpressionLanguage.class)) {
            return this.getAnnotation(ExpressionLanguage.class).minMuleVersion();
        }
        return null;
    }

    @Override
    public String namespace() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).namespace();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).namespace();
        }
        return null;
    }

    @Override
    public String name() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).name();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).name();
        }
        return null;
    }

    @Override
    public String schemaLocation() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).schemaLocation();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).schemaLocation();
        }
        return null;
    }

    @Override
    public String schemaVersion() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).schemaVersion();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).schemaVersion();
        }
        return null;
    }

    @Override
    public boolean usesConnectionManager() {
        return this.hasMethodsAnnotatedWith(Connect.class) && this.hasMethodsAnnotatedWith(Disconnect.class);
    }

    @Override
    public String friendlyName() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).friendlyName();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).friendlyName();
        }
        return null;
    }

    @Override
    public String description() {
        if (this.hasAnnotation(Module.class)) {
            return this.getAnnotation(Module.class).description();
        }
        if (this.hasAnnotation(Connector.class)) {
            return this.getAnnotation(Connector.class).description();
        }
        return null;
    }
}

