/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.rest.RestCall;
import org.mule.api.annotations.rest.RestExceptionOn;
import org.mule.api.annotations.rest.RestHeaderParam;
import org.mule.api.annotations.rest.RestHttpClient;
import org.mule.api.annotations.rest.RestQueryParam;
import org.mule.api.annotations.rest.RestUriParam;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class RestValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.isModuleOrConnector() && typeElement.hasMethodsAnnotatedWith(RestCall.class);
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(RestCall.class)) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new ValidationException((Element)method, "@RestCall can only be applied to abstract methods");
            }
            if (method.getThrownTypes().size() != 1) {
                throw new ValidationException((Element)method, "@RestCall abstract method must throw IOException");
            }
            RestExceptionOn restExceptionOn = method.getAnnotation(RestExceptionOn.class);
            if (restExceptionOn != null) {
                if (restExceptionOn.statusCodeIs().length != 0 && restExceptionOn.statusCodeIsNot().length != 0) {
                    throw new ValidationException((Element)method, "@RestExceptionOn can only be used with statusCodeIs or statusCodeIsNot. Not both.");
                }
                if (restExceptionOn.statusCodeIs().length == 0 && restExceptionOn.statusCodeIsNot().length == 0) {
                    throw new ValidationException((Element)method, "@RestExceptionOn must have either statusCodeIs or statusCodeIsNot.");
                }
            }
            int nonAnnotatedParameterCount = 0;
            for (VariableElement variableElement : method.getParameters()) {
                if (variableElement.getAnnotation(RestUriParam.class) != null || variableElement.getAnnotation(RestHeaderParam.class) != null || variableElement.getAnnotation(RestQueryParam.class) != null) continue;
                ++nonAnnotatedParameterCount;
            }
            if (nonAnnotatedParameterCount <= true) continue;
            throw new ValidationException((Element)method, "Only one parameter can be used as payload, everything else must be annotated with @RestUriParam, @RestQueryParam or @RestHeaderParam.");
        }
        for (VariableElement field : typeElement.getFieldsAnnotatedWith(RestUriParam.class)) {
            boolean getterFound = false;
            for (ExecutableElement method : typeElement.getMethods()) {
                if (!method.getSimpleName().toString().equals("get" + StringUtils.capitalize((String)field.getSimpleName().toString()))) continue;
                getterFound = true;
                break;
            }
            if (getterFound) continue;
            throw new ValidationException((Element)field, "Cannot find a getter method for " + field.getSimpleName().toString() + " but its being marked as URI parameter of a REST call.");
        }
        if (typeElement.getFieldsAnnotatedWith(RestHttpClient.class).size() > 1) {
            throw new ValidationException((Element)typeElement, "There can only be one field annotated with @RestHttpClient.");
        }
        if (typeElement.getFieldsAnnotatedWith(RestHttpClient.class).size() > 0 && !((Object)typeElement.getFieldsAnnotatedWith(RestHttpClient.class).get(0).asType()).toString().equals(HttpClient.class.getName())) {
            throw new ValidationException((Element)typeElement.getFieldsAnnotatedWith(RestHttpClient.class).get(0), "A field annotated with @RestHttpClient must be of type " + HttpClient.class.getName());
        }
        for (VariableElement field : typeElement.getFieldsAnnotatedWith(RestHttpClient.class)) {
            boolean getterFound = false;
            for (ExecutableElement method : typeElement.getMethods()) {
                if (!method.getSimpleName().toString().equals("get" + StringUtils.capitalize((String)field.getSimpleName().toString()))) continue;
                getterFound = true;
                break;
            }
            if (getterFound) continue;
            throw new ValidationException((Element)field, "Cannot find a getter method for " + field.getSimpleName().toString() + " but its being marked with @RestHttpClient.");
        }
    }
}

