/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio.editor;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.xml.bind.JAXBElement;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.generation.mule.studio.editor.MethodComparator;
import org.mule.devkit.generation.mule.studio.editor.PatternTypes;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.PatternType;

public class PatternTypeOperationsBuilder
extends BaseStudioXmlBuilder {
    private static final String ALIAS_ID_PREFIX = "org.mule.tooling.ui.modules.core.pattern.";
    private static final MethodComparator METHOD_COMPARATOR = new MethodComparator();
    private PatternTypes patternTypeToUse;

    public PatternTypeOperationsBuilder(GeneratorContext context, DevKitTypeElement typeElement, PatternTypes patternTypeToUse) {
        super(context, typeElement);
        if (!patternTypeToUse.equals((Object)PatternTypes.CLOUD_CONNECTOR) && !patternTypeToUse.equals((Object)PatternTypes.TRANSFORMER)) {
            throw new IllegalArgumentException("PatternType not supported: " + (Object)((Object)patternTypeToUse));
        }
        this.patternTypeToUse = patternTypeToUse;
    }

    public JAXBElement<PatternType> build() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption("General"));
        attributeCategory.setDescription(this.helper.formatDescription("General"));
        attributeCategory.getGroup().add(this.createGroupWithModeSwitch(this.getMethods()));
        PatternType patternType = new PatternType();
        patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().add(attributeCategory);
        patternType.setCaption(this.helper.getFormattedCaption(this.typeElement));
        if (this.patternTypeToUse.equals((Object)PatternTypes.CLOUD_CONNECTOR)) {
            patternType.setLocalId(this.typeElement.name() + "-connector");
            patternType.setExtends("http://www.mulesoft.org/schema/mule/" + this.typeElement.name() + '/' + this.helper.getGlobalRefId(this.typeElement.name()));
        } else {
            patternType.setLocalId(this.typeElement.name() + "-transformer");
        }
        patternType.setDescription(this.helper.getFormattedDescription(this.typeElement));
        patternType.setAliasId(ALIAS_ID_PREFIX + this.typeElement.name());
        patternType.setIcon(this.getIcon());
        patternType.setImage(this.getImage());
        if (this.patternTypeToUse.equals((Object)PatternTypes.CLOUD_CONNECTOR)) {
            return this.objectFactory.createNamespaceTypeCloudConnector(patternType);
        }
        return this.objectFactory.createNamespaceTypeTransformer(patternType);
    }

    private String getImage() {
        if (this.patternTypeToUse.equals((Object)PatternTypes.TRANSFORMER)) {
            return this.helper.getTransformerImage(this.typeElement);
        }
        return this.helper.getConnectorImage(this.typeElement);
    }

    private String getIcon() {
        if (this.patternTypeToUse.equals((Object)PatternTypes.TRANSFORMER)) {
            return this.helper.getTransformerIcon(this.typeElement);
        }
        return this.helper.getConnectorIcon(this.typeElement);
    }

    private List<ExecutableElement> getMethods() {
        List<ExecutableElement> methods = this.patternTypeToUse.equals((Object)PatternTypes.CLOUD_CONNECTOR) ? this.typeElement.getMethodsAnnotatedWith(Processor.class) : this.typeElement.getMethodsAnnotatedWith(Transformer.class);
        Collections.sort(methods, METHOD_COMPARATOR);
        return methods;
    }
}

