/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mule.api.annotations.Source;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.editor.GlobalTypeBuilder;
import org.mule.devkit.generation.mule.studio.editor.MethodComparator;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.GlobalType;

public class GlobalEndpointTypeOperationsBuilder
extends GlobalTypeBuilder {
    public GlobalEndpointTypeOperationsBuilder(GeneratorContext context, DevKitTypeElement typeElement) {
        super(context, typeElement);
    }

    @Override
    public GlobalType build() {
        GlobalType globalEndpointListingOps = super.build();
        globalEndpointListingOps.setExtends("http://www.mulesoft.org/schema/mule/" + this.typeElement.name() + '/' + "abstractGlobalEndpoint");
        return globalEndpointListingOps;
    }

    @Override
    protected List<AttributeCategory> getAttributeCategories() {
        AttributeCategory attributeCategory = new AttributeCategory();
        attributeCategory.setCaption(this.helper.formatCaption("General"));
        attributeCategory.setDescription(this.helper.formatDescription("General"));
        attributeCategory.getGroup().add(this.createGroupWithModeSwitch(this.getTransformerMethodsSorted()));
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        attributeCategories.add(attributeCategory);
        return attributeCategories;
    }

    private List<ExecutableElement> getTransformerMethodsSorted() {
        List<ExecutableElement> transformer = this.typeElement.getMethodsAnnotatedWith(Source.class);
        Collections.sort(transformer, new MethodComparator());
        return transformer;
    }

    @Override
    protected String getDescriptionBasedOnType() {
        return this.helper.formatDescription("Global endpoint");
    }

    @Override
    protected String getExtendsBasedOnType() {
        return "";
    }

    @Override
    protected String getLocalIdBasedOnType() {
        return "global-endpoint";
    }

    @Override
    protected String getCaptionBasedOnType() {
        return this.helper.getFormattedCaption(this.typeElement);
    }

    @Override
    protected String getNameDescriptionBasedOnType() {
        return "Identifies the endpoint so that other elements can reference it.";
    }

    @Override
    protected String getImage() {
        return this.helper.getEndpointImage(this.typeElement);
    }

    @Override
    protected String getIcon() {
        return this.helper.getEndpointIcon(this.typeElement);
    }
}

