/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.oauth;

import javax.lang.model.element.TypeElement;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;

public class DefaultSaveAccessTokenCallbackFactoryGenerator
extends AbstractMessageGenerator {
    public static final String ROLE = "SaveAccessTokenCallbackFactoryBean";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass factory = this.getDefaultSaveAccessTokenCallbackFactoryClass(typeElement);
        DefinedClass callback = this.context.getClassForRole("DefaultSaveAccessTokenCallback");
        Method getObjectType = factory.method(1, (Type)this.ref(Class.class), "getObjectType");
        getObjectType.body()._return(callback.dotclass());
        Method getObject = factory.method(1, (Type)this.ref(Object.class), "getObject");
        getObject._throws(this.ref(Exception.class));
        Variable callbackVariable = getObject.body().decl((Type)callback, "callback", (Expression)ExpressionFactory._new((TypeReference)callback));
        getObject.body().add((Statement)callbackVariable.invoke("setMessageProcessor").arg((Expression)ExpressionFactory.cast((Type)this.ref(MessageProcessor.class), (Expression)ExpressionFactory._super().invoke("getObject"))));
        getObject.body()._return((Expression)callbackVariable);
    }

    private DefinedClass getDefaultSaveAccessTokenCallbackFactoryClass(TypeElement type) {
        String callbackClassName = this.context.getNameUtils().generateClassNameInPackage(type, ".config", ROLE);
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(callbackClassName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(callbackClassName));
        clazz._extends(this.ref(MessageProcessorChainFactoryBean.class));
        this.context.setClassRole(ROLE, clazz);
        return clazz;
    }
}

