/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.oauth;

import javax.lang.model.element.TypeElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.oauth.UnableToAcquireAccessTokenException;
import org.mule.api.oauth.UnableToAcquireRequestTokenException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;

public class AuthorizeMessageProcessorGenerator
extends AbstractMessageGenerator {
    public static final String AUTHORIZE_MESSAGE_PROCESSOR_ROLE = "AuthorizeMessageProcessor";
    private static final String HTTP_STATUS_PROPERTY = "http.status";
    private static final String REDIRECT_HTTP_STATUS = "302";
    private static final String LOCATION_PROPERTY = "Location";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        Invocation messageException;
        Invocation failedToInvoke;
        TypeReference coreMessages;
        Variable exception;
        DefinedClass messageProcessorClass = this.getAuthorizeMessageProcessorClass(typeElement);
        FieldVariable object = this.generateFieldForModuleObject(messageProcessorClass, typeElement);
        FieldVariable muleContext = this.generateFieldForMuleContext(messageProcessorClass);
        FieldVariable flowConstruct = this.generateFieldForFlowConstruct(messageProcessorClass);
        this.generateInitialiseMethod(messageProcessorClass, null, typeElement, muleContext, null, null, object, null, true);
        this.generateStartMethod(messageProcessorClass, null);
        this.generateStopMethod(messageProcessorClass, null);
        this.generateDiposeMethod(messageProcessorClass, null);
        this.generateSetMuleContextMethod(messageProcessorClass, muleContext, null);
        this.generateSetFlowConstructMethod(messageProcessorClass, flowConstruct, null);
        this.generateSetModuleObjectMethod(messageProcessorClass, object);
        TypeReference muleEvent = this.ref(MuleEvent.class);
        Method process = messageProcessorClass.method(1, (Type)muleEvent, "process");
        process.javadoc().add((Object)"Starts the OAuth authorization process");
        process.javadoc().addParam("event MuleEvent to be processed");
        process.javadoc().addThrows(this.ref(MuleException.class));
        process._throws(MuleException.class);
        Variable event = process.param((Type)muleEvent, "event");
        DefinedClass moduleObjectClass = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        Variable moduleObject = process.body().decl((Type)moduleObjectClass, "castedModuleObject", ExpressionFactory._null());
        this.findConfig(process.body(), muleContext, object, "authorize", event, moduleObjectClass, moduleObject);
        OAuth2 oauth2 = typeElement.getAnnotation(OAuth2.class);
        if (oauth2 != null && !StringUtils.isEmpty((String)oauth2.expirationRegex())) {
            Block ifTokenExpired = process.body()._if((Expression)moduleObject.invoke("hasTokenExpired"))._then();
            ifTokenExpired.invoke((Expression)moduleObject, "reset");
        }
        TryStatement tryToAuthorize = process.body()._try();
        Invocation oauthVerifier = moduleObject.invoke("get" + StringUtils.capitalize((String)"oauthVerifier"));
        Block ifOauthVerifierIsNull = tryToAuthorize.body()._if(this.isNull((Expression)oauthVerifier))._then();
        Variable authorizationUrl = ifOauthVerifierIsNull.decl((Type)this.ref(String.class), "authorizationUrl", (Expression)ExpressionFactory.invoke((Expression)moduleObject, (String)"getAuthorizationUrl"));
        ifOauthVerifierIsNull.invoke((Expression)event.invoke("getMessage"), "setOutboundProperty").arg(HTTP_STATUS_PROPERTY).arg(REDIRECT_HTTP_STATUS);
        ifOauthVerifierIsNull.invoke((Expression)event.invoke("getMessage"), "setOutboundProperty").arg(LOCATION_PROPERTY).arg((Expression)authorizationUrl);
        ifOauthVerifierIsNull._return((Expression)event);
        Invocation accessToken = moduleObject.invoke("get" + StringUtils.capitalize((String)"accessToken"));
        Block ifAccessTokenIsNull = tryToAuthorize.body()._if(this.isNull((Expression)accessToken))._then();
        ifAccessTokenIsNull.invoke((Expression)moduleObject, "fetchAccessToken");
        tryToAuthorize.body()._return((Expression)event);
        if (typeElement.hasAnnotation(OAuth.class)) {
            CatchBlock unableToAcquireRequestTokenException = tryToAuthorize._catch(this.ref(UnableToAcquireRequestTokenException.class));
            exception = unableToAcquireRequestTokenException.param("e");
            coreMessages = this.ref(CoreMessages.class);
            failedToInvoke = coreMessages.staticInvoke("failedToInvoke");
            failedToInvoke.arg(ExpressionFactory.lit((String)"authorize"));
            messageException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
            messageException.arg((Expression)failedToInvoke);
            messageException.arg((Expression)event);
            messageException.arg((Expression)exception);
            unableToAcquireRequestTokenException.body()._throw((Expression)messageException);
        }
        CatchBlock unableToAcquireAccessTokenException = tryToAuthorize._catch(this.ref(UnableToAcquireAccessTokenException.class));
        exception = unableToAcquireAccessTokenException.param("e2");
        coreMessages = this.ref(CoreMessages.class);
        failedToInvoke = coreMessages.staticInvoke("failedToInvoke");
        failedToInvoke.arg(ExpressionFactory.lit((String)"authorize"));
        messageException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
        messageException.arg((Expression)failedToInvoke);
        messageException.arg((Expression)event);
        messageException.arg((Expression)exception);
        unableToAcquireAccessTokenException.body()._throw((Expression)messageException);
    }

    private DefinedClass getAuthorizeMessageProcessorClass(TypeElement type) {
        String httpCallbackClassName = this.context.getNameUtils().generateClassNameInPackage(type, ".processors", AUTHORIZE_MESSAGE_PROCESSOR_ROLE);
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(httpCallbackClassName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(httpCallbackClassName), new Class[]{Initialisable.class, Startable.class, Disposable.class, Stoppable.class, MessageProcessor.class, MuleContextAware.class, FlowConstructAware.class});
        this.context.setClassRole(AUTHORIZE_MESSAGE_PROCESSOR_ROLE, clazz);
        return clazz;
    }
}

