/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.mule.api.annotations.Source;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class SourceValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.isModuleOrConnector() && typeElement.hasMethodsAnnotatedWith(Source.class);
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Source.class)) {
            if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new ValidationException((Element)method, "@Source cannot be applied to a static method");
            }
            if (!method.getTypeParameters().isEmpty()) {
                throw new ValidationException((Element)method, "@Source cannot be applied to a generic method");
            }
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new ValidationException((Element)method, "@Source cannot be applied to a non-public method");
            }
            boolean containsSourceCallback = false;
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                if (!((Object)variableElement.asType()).toString().startsWith(SourceCallback.class.getName())) continue;
                containsSourceCallback = true;
            }
            if (containsSourceCallback) continue;
            throw new ValidationException((Element)method, "@Source method must contain a SourceCallback as one of its parameters");
        }
    }
}

