/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class ProcessorValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.isModuleOrConnector();
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new ValidationException((Element)method, "@Processor cannot be applied to a static method");
            }
            if (!method.getTypeParameters().isEmpty()) {
                throw new ValidationException((Element)method, "@Processor cannot be applied to a generic method");
            }
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new ValidationException((Element)method, "@Processor cannot be applied to a non-public method");
            }
            this.validateIntercepting(method);
            for (VariableElement variableElement : method.getParameters()) {
                int count = 0;
                if (variableElement.getAnnotation(InboundHeaders.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(OutboundHeaders.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(InvocationHeaders.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(SessionHeaders.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(Payload.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(ExceptionPayload.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(CorrelationId.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(CorrelationSequence.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(CorrelationGroupSize.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(MessageUniqueId.class) != null) {
                    ++count;
                }
                if (variableElement.getAnnotation(MessageRootId.class) != null) {
                    ++count;
                }
                if (count > 1) {
                    throw new ValidationException((Element)variableElement, "You cannot have more than one of InboundHeader, InvocationHeaders or Payload annotation");
                }
                if (variableElement.getAnnotation(Payload.class) != null || variableElement.asType().getKind() != TypeKind.ARRAY) continue;
                throw new ValidationException((Element)variableElement, "@Processor parameter cannot be arrays, use List instead");
            }
        }
    }

    private void validateIntercepting(ExecutableElement method) throws ValidationException {
        if (method.getAnnotation(Processor.class).intercepting()) {
            boolean containsSourceCallback = false;
            List<? extends VariableElement> parameters = method.getParameters();
            for (VariableElement variableElement : parameters) {
                if (!((Object)variableElement.asType()).toString().startsWith(SourceCallback.class.getName())) continue;
                containsSourceCallback = true;
            }
            if (!containsSourceCallback) {
                throw new ValidationException((Element)method, "An intercepting method method must contain a SourceCallback as one of its parameters");
            }
        }
    }
}

