/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.annotations.oauth.OAuthConsumerKey;
import org.mule.api.annotations.oauth.OAuthConsumerSecret;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class OAuthValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.isModuleOrConnector();
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        if (typeElement.hasAnnotation(OAuth.class)) {
            this.validateOAuth1Class(typeElement);
        } else if (typeElement.hasAnnotation(OAuth2.class)) {
            this.validateOAuth2Class(typeElement);
        } else {
            this.validateNonOAuthClass(typeElement);
        }
    }

    private void validateOAuth1Class(DevKitTypeElement typeElement) throws ValidationException {
        if (typeElement.hasAnnotation(Connector.class)) {
            throw new ValidationException((Element)typeElement, "It is not possible to use OAuth support in @Connector annotated classes, use @Module instead");
        }
        if (!typeElement.hasFieldAnnotatedWith(OAuthConsumerKey.class)) {
            throw new ValidationException((Element)typeElement, "@OAuth class must contain a field annotated with @OAuthConsumerKey");
        }
        if (!typeElement.hasFieldAnnotatedWith(OAuthConsumerSecret.class)) {
            throw new ValidationException((Element)typeElement, "@OAuth class must contain a field annotated with @OAuthConsumerSecret");
        }
        if (!this.classHasMethodWithParameterAnnotated(typeElement, OAuthAccessToken.class)) {
            throw new ValidationException((Element)typeElement, "@OAuth class must have at least one method parameter annotated with @OAuthAccessToken");
        }
    }

    private void validateOAuth2Class(DevKitTypeElement typeElement) throws ValidationException {
        if (typeElement.hasAnnotation(Connector.class)) {
            throw new ValidationException((Element)typeElement, "It is not possible to use OAuth support in @Connector annotated classes, use @Module instead");
        }
        if (!typeElement.hasFieldAnnotatedWith(OAuthConsumerKey.class)) {
            throw new ValidationException((Element)typeElement, "@OAuth2 class must contain a field annotated with @OAuthConsumerKey");
        }
        if (!typeElement.hasFieldAnnotatedWith(OAuthConsumerSecret.class)) {
            throw new ValidationException((Element)typeElement, "@OAuth2 class must contain a field annotated with @OAuthConsumerSecret");
        }
        if (!this.classHasMethodWithParameterAnnotated(typeElement, OAuthAccessToken.class)) {
            throw new ValidationException((Element)typeElement, "@OAuth2 class must have at least one method parameter annotated with @OAuthAccessToken");
        }
        if (this.classHasMethodWithParameterAnnotated(typeElement, OAuthAccessTokenSecret.class)) {
            throw new ValidationException((Element)typeElement, "@OAuth2 class cannot have method parameters annotated with @OAuthAccessTokenSecret");
        }
    }

    private void validateNonOAuthClass(DevKitTypeElement typeElement) throws ValidationException {
        if (this.classHasMethodWithParameterAnnotated(typeElement, OAuthAccessToken.class)) {
            throw new ValidationException((Element)typeElement, "Cannot annotate parameter with @OAuthAccessToken without annotating the class with @OAuth or @OAuth2");
        }
        if (this.classHasMethodWithParameterAnnotated(typeElement, OAuthAccessTokenSecret.class)) {
            throw new ValidationException((Element)typeElement, "Cannot annotate parameter with @OAuthAccessTokenSecret without annotating the class with @OAuth");
        }
    }

    private boolean classHasMethodWithParameterAnnotated(DevKitTypeElement typeElement, Class<? extends Annotation> annotation) {
        for (ExecutableElement method : typeElement.getMethods()) {
            for (VariableElement variableElement : method.getParameters()) {
                if (variableElement.getAnnotation(annotation) == null) continue;
                return true;
            }
        }
        return false;
    }
}

