/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transfomer;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class EnumTransformerGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(Module.class) || typeElement.hasAnnotation(Connector.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        for (VariableElement field : typeElement.getFields()) {
            if (!this.context.getTypeMirrorUtils().isEnum(field.asType()) || this.context.isEnumRegistered(field.asType())) continue;
            this.registerEnumTransformer(field);
            this.context.registerEnum(field.asType());
        }
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            for (VariableElement variableElement : method.getParameters()) {
                if (this.context.getTypeMirrorUtils().isEnum(variableElement.asType()) && !this.context.isEnumRegistered(variableElement.asType())) {
                    this.registerEnumTransformer(variableElement);
                    this.context.registerEnum(variableElement.asType());
                    continue;
                }
                if (!this.context.getTypeMirrorUtils().isCollection(variableElement.asType())) continue;
                DeclaredType variableType = (DeclaredType)variableElement.asType();
                for (TypeMirror typeMirror : variableType.getTypeArguments()) {
                    if (!this.context.getTypeMirrorUtils().isEnum(typeMirror) || this.context.isEnumRegistered(typeMirror)) continue;
                    Element enumElement = this.context.getTypeUtils().asElement(typeMirror);
                    this.registerEnumTransformer(enumElement);
                    this.context.registerEnum(typeMirror);
                }
            }
        }
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Source.class)) {
            for (VariableElement variableElement : method.getParameters()) {
                if (!this.context.getTypeMirrorUtils().isEnum(variableElement.asType()) || this.context.isEnumRegistered(variableElement.asType())) continue;
                this.registerEnumTransformer(variableElement);
                this.context.registerEnum(variableElement.asType());
            }
        }
    }

    private void registerEnumTransformer(Element variableElement) {
        DefinedClass transformerClass = this.getEnumTransformerClass(variableElement);
        FieldVariable muleContext = this.generateFieldForMuleContext(transformerClass);
        FieldVariable weighting = transformerClass.field(4, (Type)this.context.getCodeModel().INT, "weighting", (Expression)this.ref(DiscoverableTransformer.class).staticRef("DEFAULT_PRIORITY_WEIGHTING"));
        this.generateConstructor(transformerClass, variableElement);
        this.generateSetMuleContextMethod(transformerClass, muleContext);
        this.generateDoTransform(transformerClass, variableElement);
        this.generateGetPriorityWeighting(transformerClass, weighting);
        this.generateSetPriorityWeighting(transformerClass, weighting);
        this.context.registerAtBoot(transformerClass);
    }

    private void generateSetPriorityWeighting(DefinedClass jaxbTransformerClass, FieldVariable weighting) {
        Method setPriorityWeighting = jaxbTransformerClass.method(1, (Type)this.context.getCodeModel().VOID, "setPriorityWeighting");
        Variable localWeighting = setPriorityWeighting.param((Type)this.context.getCodeModel().INT, "weighting");
        setPriorityWeighting.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)weighting), (Expression)localWeighting);
    }

    private void generateGetPriorityWeighting(DefinedClass jaxbTransformerClass, FieldVariable weighting) {
        Method getPriorityWeighting = jaxbTransformerClass.method(1, (Type)this.context.getCodeModel().INT, "getPriorityWeighting");
        getPriorityWeighting.body()._return((Expression)weighting);
    }

    private void generateDoTransform(DefinedClass jaxbTransformerClass, Element variableElement) {
        Method doTransform = jaxbTransformerClass.method(2, (Type)this.ref(Object.class), "doTransform");
        doTransform._throws(TransformerException.class);
        Variable src = doTransform.param((Type)this.ref(Object.class), "src");
        doTransform.param((Type)this.ref(String.class), "encoding");
        Variable result = doTransform.body().decl((Type)this.ref(variableElement.asType()).boxify(), "result", ExpressionFactory._null());
        Invocation valueOf = this.ref(Enum.class).staticInvoke("valueOf");
        valueOf.arg(this.ref(variableElement.asType()).boxify().dotclass());
        valueOf.arg((Expression)ExpressionFactory.cast((Type)this.ref(String.class), (Expression)src));
        doTransform.body().assign((AssignmentTarget)result, (Expression)valueOf);
        doTransform.body()._return((Expression)result);
    }

    private void generateConstructor(DefinedClass transformerClass, Element variableElement) {
        Method constructor = transformerClass.constructor(1);
        this.registerSourceTypes(constructor);
        this.registerDestinationType(constructor, this.ref(variableElement.asType()).boxify());
        constructor.body().invoke("setName").arg(transformerClass.name());
    }

    private void registerDestinationType(Method constructor, TypeReference clazz) {
        Invocation setReturnClass = constructor.body().invoke("setReturnClass");
        setReturnClass.arg(ExpressionFactory.dotclass((TypeReference)clazz));
    }

    private void registerSourceTypes(Method constructor) {
        Invocation registerSourceType = constructor.body().invoke("registerSourceType");
        registerSourceType.arg((Expression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(String.class).boxify().dotclass()));
    }

    private DefinedClass getEnumTransformerClass(Element variableElement) {
        Element enumElement = this.context.getTypeUtils().asElement(variableElement.asType());
        String transformerClassName = this.context.getNameUtils().generateClassNameInPackage(variableElement, enumElement.getSimpleName().toString() + "EnumTransformer");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(transformerClassName) + ".transformers");
        DefinedClass transformer = pkg._class(this.context.getNameUtils().getClassName(transformerClassName), AbstractTransformer.class, new Class[]{DiscoverableTransformer.class, MuleContextAware.class});
        return transformer;
    }
}

