/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio.editor;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.editor.BaseStudioXmlBuilder;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.PatternType;
import org.mule.util.StringUtils;

public class PatternTypeBuilder
extends BaseStudioXmlBuilder {
    public PatternTypeBuilder(GeneratorContext context, ExecutableElement executableElement, DevKitTypeElement typeElement) {
        super(context, executableElement, typeElement);
    }

    public PatternType build() {
        PatternType patternType = this.createPatternType();
        if (this.executableElement.getAnnotation(Processor.class) != null) {
            List<AttributeCategory> attributeCategories = this.processMethodParameters();
            patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().addAll(attributeCategories);
        }
        return patternType;
    }

    private PatternType createPatternType() {
        PatternType patternType = new PatternType();
        patternType.setLocalId(this.nameUtils.uncamel(this.executableElement.getSimpleName().toString()));
        patternType.setCaption(this.helper.getFormattedCaption(this.executableElement));
        patternType.setAbstract(Boolean.valueOf(true));
        if (this.executableElement.getAnnotation(Processor.class) != null) {
            patternType.setExtends(this.helper.getUrl(this.typeElement) + this.helper.getGlobalRefId(this.typeElement.name()));
            patternType.setReturnType(this.typeMirrorUtils.getJavaType(this.executableElement));
        } else if (this.executableElement.getAnnotation(Transformer.class) != null) {
            patternType.setExtends(this.helper.getUrl(this.typeElement) + "abstractTransformer");
            patternType.setDescription(this.helper.formatDescription(this.javaDocUtils.getSummary(this.executableElement)));
        }
        patternType.setIcon(this.getIcon());
        patternType.setImage(this.getImage());
        return patternType;
    }

    private String getImage() {
        if (this.executableElement.getAnnotation(Transformer.class) != null) {
            return this.helper.getTransformerImage(this.typeElement);
        }
        return this.helper.getConnectorImage(this.typeElement);
    }

    private String getIcon() {
        if (this.executableElement.getAnnotation(Transformer.class) != null) {
            return this.helper.getTransformerIcon(this.typeElement);
        }
        return this.helper.getConnectorIcon(this.typeElement);
    }

    @Override
    protected void processConnectionAttributes(Map<String, Group> groupsByName, Map<String, AttributeCategory> attributeCategoriesByName) {
        if (this.typeElement.usesConnectionManager()) {
            Group connectionAttributesGroup = new Group();
            connectionAttributesGroup.setCaption(this.helper.formatCaption("Connection"));
            connectionAttributesGroup.setId(StringUtils.uncapitalize((String)"Connection"));
            AttributeType label = new AttributeType();
            label.setCaption(String.format("Use these fields to override the credentials defined in the %s connector.", this.helper.getFormattedCaption(this.typeElement)));
            AttributeType newLine = new AttributeType();
            newLine.setCaption("");
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupLabel(label));
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupLabel(newLine));
            groupsByName.put("Connection", connectionAttributesGroup);
            List<AttributeType> connectionAttributes = this.getConnectionAttributes(this.typeElement);
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().addAll(this.helper.createJAXBElements(connectionAttributes));
            AttributeCategory connectionAttributeCategory = new AttributeCategory();
            connectionAttributeCategory.setCaption(this.helper.formatCaption("Connection"));
            connectionAttributeCategory.setDescription(this.helper.formatDescription("Connection"));
            attributeCategoriesByName.put("Connection", connectionAttributeCategory);
            connectionAttributeCategory.getGroup().add(connectionAttributesGroup);
        }
    }
}

