/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.utils.NameUtils;
import org.osgi.framework.BundleContext;

public class MuleStudioPluginActivatorGenerator
extends AbstractMessageGenerator {
    public static final String ACTIVATOR_PATH = "org/mule/tooling/ui/contribution/Activator.class";
    private static final String ACTIVATOR_FQN = "org.mule.tooling.ui.contribution.Activator";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.context.hasOption("skipStudioPluginPackage");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass activatorClass = this.getActivatorClass();
        activatorClass.javadoc().add((Object)"The activator class controls the plug-in life cycle");
        new FieldBuilder(activatorClass).publicVisibility().staticField().finalField().type(String.class).name("PLUGIN_ID").initialValue("org.mule.tooling.ui.contribution." + typeElement.name()).build();
        TypeReference activatorTypeRef = this.context.getCodeModel().directClass(ACTIVATOR_FQN);
        FieldVariable plugin = new FieldBuilder(activatorClass).staticField().type((Type)activatorTypeRef).name("plugin").build();
        this.generateStartMethod(activatorClass, plugin);
        this.generateStopMethod(activatorClass, plugin);
        Method getDefault = activatorClass.method(17, (Type)activatorTypeRef, "getDefault");
        getDefault.body()._return((Expression)plugin);
    }

    private DefinedClass getActivatorClass() {
        NameUtils nameUtils = this.context.getNameUtils();
        String activatorFQN = ACTIVATOR_FQN;
        Package pkg = this.context.getCodeModel()._package(nameUtils.getPackageName(activatorFQN));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(activatorFQN));
        clazz._extends(AbstractUIPlugin.class);
        return clazz;
    }

    private void generateStartMethod(DefinedClass activatorClass, FieldVariable plugin) {
        Method start = activatorClass.method(1, (Type)this.context.getCodeModel().VOID, "start");
        start._throws(Exception.class);
        Variable context = start.param(BundleContext.class, "context");
        start.body().invoke(ExpressionFactory._super(), "start").arg((Expression)context);
        start.body().assign((AssignmentTarget)plugin, ExpressionFactory._this());
    }

    private void generateStopMethod(DefinedClass activatorClass, FieldVariable plugin) {
        Method stop = activatorClass.method(1, (Type)this.context.getCodeModel().VOID, "stop");
        stop._throws(Exception.class);
        Variable context = stop.param(BundleContext.class, "context");
        stop.body().assign((AssignmentTarget)plugin, ExpressionFactory._null());
        stop.body().invoke(ExpressionFactory._super(), "stop").arg((Expression)context);
    }
}

