/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.util.IOUtils;

public class MuleStudioManifestGenerator
extends AbstractMessageGenerator {
    public static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.context.hasOption("skipStudioPluginPackage");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        PrintStream printStream = null;
        try {
            OutputStream outputStream = this.context.getCodeModel().getCodeWriter().openBinary(null, MANIFEST_FILE_NAME);
            printStream = new PrintStream(outputStream);
            printStream.append(this.getManifestContents(typeElement));
            printStream.flush();
        }
        catch (IOException e) {
            try {
                throw new GenerationException("Could not create MANIFEST for Studio plugin: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(printStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)printStream);
    }

    private String getManifestContents(DevKitTypeElement typeElement) {
        StringBuilder manfiestContentBuilder = new StringBuilder(100);
        manfiestContentBuilder.append("Manifest-Version: 1.0\n");
        manfiestContentBuilder.append("Bundle-ManifestVersion: 2\n");
        manfiestContentBuilder.append("Bundle-Name: ").append(this.context.getNameUtils().friendlyNameFromCamelCase(typeElement.name())).append("\n");
        manfiestContentBuilder.append("Bundle-SymbolicName: org.mule.tooling.ui.contribution.").append(typeElement.name()).append(";singleton:=true\n");
        manfiestContentBuilder.append("Bundle-Version: 1.0.0.qualifier\n");
        manfiestContentBuilder.append("Bundle-Activator: org.mule.tooling.ui.contribution.Activator\n");
        manfiestContentBuilder.append("Bundle-Vendor: ").append(this.context.getJavaDocUtils().getTagContent("author", typeElement.getInnerTypeElement())).append("\n");
        manfiestContentBuilder.append("Require-Bundle: org.eclipse.ui,\n");
        manfiestContentBuilder.append(" org.eclipse.core.runtime,\n");
        manfiestContentBuilder.append(" org.mule.tooling.core;bundle-version=\"1.0.0\"\n");
        manfiestContentBuilder.append("Bundle-RequiredExecutionEnvironment: JavaSE-1.6\n");
        manfiestContentBuilder.append("Bundle-ActivationPolicy: lazy\n");
        manfiestContentBuilder.append("Eclipse-BundleShape: dir\n");
        return manfiestContentBuilder.toString();
    }
}

