/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.display.Icons;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.util.IOUtils;

public class MuleStudioIconsGenerator
extends AbstractMessageGenerator {
    public static final String ICONS_FOLDER = "icons/";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.context.hasOption("skipStudioPluginPackage");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        Icons icons = typeElement.getAnnotation(Icons.class);
        if (icons != null) {
            this.copyFile(icons.connectorSmall(), "icons/small", typeElement);
            this.copyFile(icons.endpointSmall(), "icons/small", typeElement);
            this.copyFile(icons.transformerSmall(), "icons/small", typeElement);
            this.copyFile(icons.connectorLarge(), "icons/large", typeElement);
            this.copyFile(icons.endpointLarge(), "icons/large", typeElement);
            this.copyFile(icons.transformerLarge(), "icons/large", typeElement);
        } else {
            this.copyFile(String.format("../../../icons/%s-connector-24x16.png", typeElement.name()), "icons/small", typeElement);
            this.copyFile(String.format("../../../icons/%s-endpoint-24x16.png", typeElement.name()), "icons/small", typeElement);
            this.copyFile(String.format("../../../icons/%s-transformer-24x16.png", typeElement.name()), "icons/small", typeElement);
            this.copyFile(String.format("../../../icons/%s-connector-48x32.png", typeElement.name()), "icons/large", typeElement);
            this.copyFile(String.format("../../../icons/%s-endpoint-48x32.png", typeElement.name()), "icons/large", typeElement);
            this.copyFile(String.format("../../../icons/%s-transformer-48x32.png", typeElement.name()), "icons/large", typeElement);
        }
    }

    private void copyFile(String fileName, String folder, DevKitTypeElement typeElement) throws GenerationException {
        String sourcePath = this.context.getSourceUtils().getPath(typeElement.getInnerTypeElement());
        for (int packageCount = StringUtils.countMatches((String)typeElement.getQualifiedName().toString(), (String)".") + 1; packageCount > 0; --packageCount) {
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf("/"));
        }
        OutputStream outputStream = null;
        try {
            outputStream = this.createFile(folder, fileName);
            File fileToCopy = new File(sourcePath, fileName);
            if (!fileToCopy.exists()) {
                throw new GenerationException("The following icon file does not exist: " + fileToCopy.getAbsolutePath());
            }
            IOUtils.copy((InputStream)new FileInputStream(fileToCopy), (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new GenerationException("Error copying icons to output folder: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    private OutputStream createFile(String folder, String fileName) throws GenerationException {
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        try {
            return this.context.getCodeModel().getCodeWriter().openBinary(null, folder + '/' + fileName);
        }
        catch (IOException e) {
            throw new GenerationException("Could not create file or folder " + fileName + ": " + e.getMessage(), e);
        }
    }
}

