/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.oauth;

import javax.lang.model.element.TypeElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.Variable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class AuthorizeBeanDefinitionParserGenerator
extends AbstractMessageGenerator {
    public static final String AUTHORIZE_DEFINITION_PARSER_ROLE = "AuthorizeDefinitionParser";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass beanDefinitionParser = this.getAuthorizeBeanDefinitionParserClass(typeElement);
        DefinedClass messageProcessorClass = this.context.getClassForRole("AuthorizeMessageProcessor");
        Method parse = beanDefinitionParser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        Variable element = parse.param((Type)this.ref(Element.class), "element");
        Variable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContent");
        Variable builder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "builder", (Expression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((Expression)messageProcessorClass.dotclass().invoke("getName")));
        Variable configRef = parse.body().decl((Type)this.ref(String.class), "configRef", (Expression)element.invoke("getAttribute").arg("config-ref"));
        Conditional ifConfigRef = parse.body()._if(Op.cand((Expression)Op.ne((Expression)configRef, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)configRef))));
        ifConfigRef._then().add((Statement)builder.invoke("addPropertyValue").arg("moduleObject").arg((Expression)configRef));
        Variable definition = parse.body().decl((Type)this.ref(BeanDefinition.class), "definition", (Expression)builder.invoke("getBeanDefinition"));
        parse.body().add((Statement)definition.invoke("setAttribute").arg((Expression)this.ref(MuleHierarchicalBeanDefinitionParserDelegate.class).staticRef("MULE_NO_RECURSE")).arg((Expression)this.ref(Boolean.class).staticRef("TRUE")));
        this.generateAttachMessageProcessor(parse, definition, parserContext);
        parse.body()._return((Expression)definition);
    }

    private DefinedClass getAuthorizeBeanDefinitionParserClass(TypeElement type) {
        String httpCallbackClassName = this.context.getNameUtils().generateClassNameInPackage(type, ".config", AUTHORIZE_DEFINITION_PARSER_ROLE);
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(httpCallbackClassName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(httpCallbackClassName), new Class[]{BeanDefinitionParser.class});
        this.context.setClassRole(AUTHORIZE_DEFINITION_PARSER_ROLE, clazz);
        return clazz;
    }
}

