/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.DefinedClass;

public class RegistryBootstrapGenerator
extends AbstractModuleGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return true;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        OutputStreamWriter registryBootstrapStreamOut = null;
        try {
            OutputStream registryBootstrapStream = this.context.getCodeModel().getRegistryBootstrapStream();
            registryBootstrapStreamOut = new OutputStreamWriter(registryBootstrapStream, "UTF-8");
            for (DefinedClass clazz : this.context.getRegisterAtBoot()) {
                this.context.note("Adding registry bootstrap entry for " + clazz.fullName() + " as " + clazz.name());
                registryBootstrapStreamOut.write(clazz.name() + "=" + clazz.fullName() + "\n");
            }
            registryBootstrapStreamOut.flush();
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
    }
}

