/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.SourceThreadingModel;
import org.mule.api.callback.SourceCallback;
import org.mule.api.callback.StopSourceCallback;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.spring.SchemaTypeConversion;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.Cast;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.WhileLoop;

public class MessageSourceGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return (typeElement.hasAnnotation(Module.class) || typeElement.hasAnnotation(Connector.class)) && typeElement.hasMethodsAnnotatedWith(Source.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Source.class)) {
            this.generateMessageSource(typeElement, executableElement);
        }
    }

    private void generateMessageSource(DevKitTypeElement typeElement, ExecutableElement executableElement) {
        DefinedClass poolObjectClass;
        Source sourceAnnotation = executableElement.getAnnotation(Source.class);
        DefinedClass messageSourceClass = this.getMessageSourceClass(executableElement, sourceAnnotation.threadingModel() == SourceThreadingModel.SINGLE_THREAD);
        messageSourceClass.javadoc().add((Object)(messageSourceClass.name() + " wraps "));
        messageSourceClass.javadoc().add((Object)("{@link " + ((TypeElement)executableElement.getEnclosingElement()).getQualifiedName().toString() + "#"));
        messageSourceClass.javadoc().add((Object)(executableElement.getSimpleName().toString() + "("));
        boolean first = true;
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (!first) {
                messageSourceClass.javadoc().add((Object)", ");
            }
            messageSourceClass.javadoc().add((Object)((Object)variableElement.asType()).toString().replaceAll("<[a-zA-Z\\-\\.\\<\\>\\s\\,]*>", ""));
            first = false;
        }
        messageSourceClass.javadoc().add((Object)")} method in ");
        messageSourceClass.javadoc().add((Object)this.ref(executableElement.getEnclosingElement().asType()));
        messageSourceClass.javadoc().add((Object)" as a message source capable of generating Mule events. ");
        messageSourceClass.javadoc().add((Object)" The POJO's method is invoked in its own thread.");
        Map<String, AbstractMessageGenerator.FieldVariableElement> fields = this.generateProcessorFieldForEachParameter(messageSourceClass, executableElement);
        ExecutableElement executableElement2 = this.connectMethodForClass(typeElement);
        Map<String, AbstractMessageGenerator.FieldVariableElement> connectFields = null;
        if (executableElement2 != null) {
            connectFields = this.generateProcessorFieldForEachParameter(messageSourceClass, executableElement2);
        }
        FieldVariable object = this.generateFieldForModuleObject(messageSourceClass, typeElement);
        FieldVariable muleContext = this.generateFieldForMuleContext(messageSourceClass);
        FieldVariable flowConstruct = this.generateFieldForFlowConstruct(messageSourceClass);
        FieldVariable messageProcessor = this.generateFieldForMessageProcessorListener(messageSourceClass);
        FieldVariable stopSourceCallback = null;
        if (((Object)executableElement.getReturnType()).toString().contains("StopSourceCallback")) {
            stopSourceCallback = messageSourceClass.field(4, (Type)this.ref(StopSourceCallback.class), "stopSourceCallback");
        }
        FieldVariable thread = null;
        if (sourceAnnotation.threadingModel() == SourceThreadingModel.SINGLE_THREAD) {
            thread = messageSourceClass.field(4, (Type)this.ref(Thread.class), "thread");
            thread.javadoc().add((Object)"Thread under which this message source will execute");
        }
        this.generateInitialiseMethod(messageSourceClass, fields, typeElement, muleContext, null, null, object, null, !typeElement.needsConfig());
        this.generateSetMuleContextMethod(messageSourceClass, muleContext);
        this.generateSetModuleObjectMethod(messageSourceClass, object);
        this.generateSetListenerMethod(messageSourceClass, messageProcessor);
        this.generateSetFlowConstructMethod(messageSourceClass, flowConstruct);
        for (String fieldName : fields.keySet()) {
            this.generateSetter(messageSourceClass, fields.get(fieldName).getField());
        }
        if (connectFields != null) {
            for (String fieldName : connectFields.keySet()) {
                this.generateSetter(messageSourceClass, connectFields.get(fieldName).getField());
            }
        }
        this.generateSourceCallbackProcessMethod(messageSourceClass, messageProcessor, muleContext, flowConstruct);
        this.generateSourceCallbackProcessWithPropertiesMethod(messageSourceClass, messageProcessor, muleContext, flowConstruct);
        this.generateSourceCallbackProcessMethodWithNoPayload(messageSourceClass, messageProcessor, muleContext, flowConstruct);
        if (sourceAnnotation.threadingModel() == SourceThreadingModel.SINGLE_THREAD) {
            this.generateSingleThreadStartMethod(messageSourceClass, thread);
            this.generateSingleThreadStopMethod(messageSourceClass, thread);
        } else {
            if (typeElement.isPoolable()) {
                poolObjectClass = this.context.getClassForRole(this.context.getNameUtils().generatePoolObjectRoleKey(typeElement));
                this.generateNoThreadStartMethod(messageSourceClass, executableElement, fields, connectFields, object, muleContext, poolObjectClass, flowConstruct, stopSourceCallback);
            } else {
                this.generateNoThreadStartMethod(messageSourceClass, executableElement, fields, connectFields, object, muleContext, flowConstruct, stopSourceCallback);
            }
            this.generateNoThreadStopMethod(messageSourceClass, stopSourceCallback, executableElement);
        }
        if (sourceAnnotation.threadingModel() == SourceThreadingModel.SINGLE_THREAD) {
            if (typeElement.isPoolable()) {
                poolObjectClass = this.context.getClassForRole(this.context.getNameUtils().generatePoolObjectRoleKey(typeElement));
                this.generateRunMethod(messageSourceClass, executableElement, fields, connectFields, object, muleContext, poolObjectClass, flowConstruct, stopSourceCallback);
            } else {
                this.generateRunMethod(messageSourceClass, executableElement, fields, connectFields, object, muleContext, flowConstruct, stopSourceCallback);
            }
        }
    }

    private void generateRunMethod(DefinedClass messageSourceClass, ExecutableElement executableElement, Map<String, AbstractMessageGenerator.FieldVariableElement> fields, Map<String, AbstractMessageGenerator.FieldVariableElement> connectFields, FieldVariable object, FieldVariable muleContext, FieldVariable flowConstruct, FieldVariable stopSourceCallback) {
        this.generateRunMethod(messageSourceClass, executableElement, fields, connectFields, object, muleContext, null, flowConstruct, stopSourceCallback);
    }

    private void generateRunMethod(DefinedClass messageSourceClass, ExecutableElement executableElement, Map<String, AbstractMessageGenerator.FieldVariableElement> fields, Map<String, AbstractMessageGenerator.FieldVariableElement> connectFields, FieldVariable object, FieldVariable muleContext, DefinedClass poolObjectClass, FieldVariable flowConstruct, FieldVariable stopSourceCallback) {
        String methodName = executableElement.getSimpleName().toString();
        Source sourceAnnotation = executableElement.getAnnotation(Source.class);
        Method run = messageSourceClass.method(1, (Type)this.context.getCodeModel().VOID, "run");
        run.javadoc().add((Object)"Implementation {@link Runnable#run()} that will invoke the method on the pojo that this message source wraps.");
        this.generateSourceExecution(run.body(), executableElement, fields, connectFields, object, muleContext, poolObjectClass, flowConstruct, methodName, sourceAnnotation, stopSourceCallback);
    }

    /*
     * WARNING - void declaration
     */
    private void generateSourceExecution(Block body, ExecutableElement executableElement, Map<String, AbstractMessageGenerator.FieldVariableElement> fields, Map<String, AbstractMessageGenerator.FieldVariableElement> connectFields, FieldVariable object, FieldVariable muleContext, DefinedClass poolObjectClass, FieldVariable flowConstruct, String methodName, Source sourceAnnotation, FieldVariable stopSourceCallback) {
        void var20_27;
        void var21_36;
        Variable transformed;
        DefinedClass moduleObjectClass = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey((TypeElement)executableElement.getEnclosingElement()));
        Variable moduleObject = body.decl((Type)moduleObjectClass, "castedModuleObject", ExpressionFactory._null());
        Variable poolObject = null;
        if (poolObjectClass != null) {
            poolObject = body.decl((Type)poolObjectClass, "poolObject", ExpressionFactory._null());
        }
        HashMap<String, Variable> connectionParameters = new HashMap<String, Variable>();
        ExecutableElement connectMethod = this.connectForMethod(executableElement);
        Variable connection = null;
        if (connectMethod != null) {
            DefinedClass connectionClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectorObjectRoleKey((TypeElement)connectMethod.getEnclosingElement()));
            connection = body.decl((Type)connectionClass, "connection", ExpressionFactory._null());
            for (VariableElement variableElement : connectMethod.getParameters()) {
                String string = variableElement.getSimpleName().toString();
                TypeReference type = this.ref(connectFields.get(string).getVariableElement().asType()).boxify();
                String name = "transformed" + StringUtils.capitalize((String)string);
                transformed = body.decl((Type)type, name, ExpressionFactory._null());
                connectionParameters.put(string, transformed);
            }
        }
        TryStatement callSource = body._try();
        if (sourceAnnotation.primaryNodeOnly()) {
            WhileLoop ifNotPrimary = callSource.body()._while(Op.not((Expression)muleContext.invoke("isPrimaryPollingInstance")));
            ifNotPrimary.body().add((Statement)this.ref(Thread.class).staticInvoke("sleep").arg(ExpressionFactory.lit((int)5000)));
        }
        this.findConfig(callSource.body(), muleContext, object, methodName, null, moduleObjectClass, moduleObject);
        if (connectMethod != null) {
            for (VariableElement variableElement : connectMethod.getParameters()) {
                String string = variableElement.getSimpleName().toString();
                Conditional ifNotNull = callSource.body()._if(Op.ne((Expression)connectFields.get(string).getField(), (Expression)ExpressionFactory._null()));
                TypeReference type = this.ref(connectFields.get(string).getVariableElement().asType()).boxify();
                transformed = (Variable)connectionParameters.get(string);
                Cast cast = ExpressionFactory.cast((Type)type, (Expression)connectFields.get(string).getField());
                ifNotNull._then().assign((AssignmentTarget)transformed, (Expression)cast);
                Cast castLocal = ExpressionFactory.cast((Type)type, (Expression)moduleObject.invoke("get" + StringUtils.capitalize((String)string)));
                Conditional ifConfigAlsoNull = ifNotNull._else()._if(Op.eq((Expression)moduleObject.invoke("get" + StringUtils.capitalize((String)string)), (Expression)ExpressionFactory._null()));
                TypeReference coreMessages = this.ref(CoreMessages.class);
                Invocation failedToInvoke = coreMessages.staticInvoke("failedToCreate");
                if (methodName != null) {
                    failedToInvoke.arg(ExpressionFactory.lit((String)methodName));
                }
                Invocation messageException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
                messageException.arg((Expression)failedToInvoke);
                messageException.arg((Expression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (Expression)ExpressionFactory._null()));
                messageException.arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("You must provide a " + string + " at the config or the message processor level."));
                ifConfigAlsoNull._then()._throw((Expression)messageException);
                ifNotNull._else().assign((AssignmentTarget)transformed, (Expression)castLocal);
            }
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (((Object)variableElement.asType()).toString().startsWith(SourceCallback.class.getName())) {
                parameters.add(ExpressionFactory._this());
                continue;
            }
            String fieldName2 = variableElement.getSimpleName().toString();
            if (SchemaTypeConversion.isSupported(((Object)fields.get(fieldName2).getVariableElement().asType()).toString()) || this.context.getTypeMirrorUtils().isXmlType(fields.get(fieldName2).getVariableElement().asType()) || this.context.getTypeMirrorUtils().isCollection(fields.get(fieldName2).getVariableElement().asType()) || this.context.getTypeMirrorUtils().isEnum(fields.get(fieldName2).getVariableElement().asType())) {
                Variable transformed2 = callSource.body().decl((Type)this.ref(fields.get(fieldName2).getVariableElement().asType()).boxify(), "transformed" + StringUtils.capitalize((String)fieldName2), ExpressionFactory._null());
                Conditional notNull = callSource.body()._if(Op.ne((Expression)fields.get(fieldName2).getField(), (Expression)ExpressionFactory._null()));
                this.generateTransform(notNull._then(), transformed2, (Variable)fields.get(fieldName2).getField(), fields.get(fieldName2).getVariableElement().asType(), muleContext);
                parameters.add(transformed2);
                continue;
            }
            parameters.add(fields.get(fieldName2).getField());
        }
        if (poolObject != null) {
            callSource.body().assign((AssignmentTarget)poolObject, (Expression)ExpressionFactory.cast((Type)poolObject.type(), (Expression)moduleObject.invoke("getLifecyleEnabledObjectPool").invoke("borrowObject")));
            Invocation invocation = poolObject.invoke(methodName);
        } else if (connectMethod != null) {
            DefinedClass definedClass = this.context.getClassForRole(this.context.getNameUtils().generateConnectionParametersRoleKey((TypeElement)executableElement.getEnclosingElement()));
            Invocation newKey = ExpressionFactory._new((TypeReference)definedClass);
            Invocation createConnection = moduleObject.invoke("acquireConnection");
            for (VariableElement variableElement : connectMethod.getParameters()) {
                String fieldName3 = variableElement.getSimpleName().toString();
                newKey.arg((Expression)connectionParameters.get(fieldName3));
            }
            createConnection.arg((Expression)newKey);
            callSource.body().assign((AssignmentTarget)connection, (Expression)createConnection);
            Conditional ifConnectionIsNull = callSource.body()._if(Op.eq((Expression)connection, (Expression)ExpressionFactory._null()));
            TypeReference typeReference = this.ref(CoreMessages.class);
            Invocation failedToInvoke = typeReference.staticInvoke("failedToCreate");
            if (methodName != null) {
                failedToInvoke.arg(ExpressionFactory.lit((String)methodName));
            }
            Invocation messageException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
            messageException.arg((Expression)failedToInvoke);
            messageException.arg((Expression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (Expression)ExpressionFactory._null()));
            messageException.arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Cannot create connection"));
            ifConnectionIsNull._then()._throw((Expression)messageException);
            Invocation invocation = connection.invoke(methodName);
        } else {
            Invocation invocation = moduleObject.invoke(methodName);
        }
        boolean bl = false;
        while (var21_36 < parameters.size()) {
            var20_27.arg((Expression)parameters.get((int)var21_36));
            ++var21_36;
        }
        if (((Object)executableElement.getReturnType()).toString().contains("StopSourceCallback")) {
            callSource.body().assign((AssignmentTarget)stopSourceCallback, (Expression)var20_27);
        } else {
            callSource.body().add((Statement)var20_27);
        }
        if (sourceAnnotation.primaryNodeOnly()) {
            callSource._catch(this.ref(InterruptedException.class));
        }
        CatchBlock catchBlock = callSource._catch(this.ref(MessagingException.class));
        Variable messagingException = catchBlock.param("e");
        catchBlock.body().add((Statement)flowConstruct.invoke("getExceptionListener").invoke("handleException").arg((Expression)messagingException).arg((Expression)messagingException.invoke("getEvent")));
        CatchBlock catchException = callSource._catch(this.ref(Exception.class));
        Variable exception = catchException.param("e");
        catchException.body().add((Statement)muleContext.invoke("getExceptionListener").invoke("handleException").arg((Expression)exception));
        if (poolObjectClass != null) {
            Block block = callSource._finally();
            Block poolObjectNotNull = block._if(Op.ne((Expression)poolObject, (Expression)ExpressionFactory._null()))._then();
            poolObjectNotNull.add((Statement)moduleObject.invoke("getLifecyleEnabledObjectPool").invoke("returnObject").arg((Expression)poolObject));
        }
        if (connectMethod != null) {
            Block block = callSource._finally();
            Block connectionNotNull = block._if(Op.ne((Expression)connection, (Expression)ExpressionFactory._null()))._then();
            TryStatement tryToReleaseSession = connectionNotNull._try();
            DefinedClass connectionKey = this.context.getClassForRole(this.context.getNameUtils().generateConnectionParametersRoleKey((TypeElement)executableElement.getEnclosingElement()));
            Invocation newKey = ExpressionFactory._new((TypeReference)connectionKey);
            for (String field : connectionParameters.keySet()) {
                newKey.arg((Expression)connectionParameters.get(field));
            }
            Invocation returnConnection = moduleObject.invoke("releaseConnection");
            returnConnection.arg((Expression)newKey);
            returnConnection.arg((Expression)connection);
            tryToReleaseSession.body().add((Statement)returnConnection);
            tryToReleaseSession._catch(this.ref(Exception.class));
        }
    }

    private void generateSingleThreadStartMethod(DefinedClass messageSourceClass, FieldVariable thread) {
        Method start = messageSourceClass.method(1, (Type)this.context.getCodeModel().VOID, "start");
        start.javadoc().add((Object)"Method to be called when Mule instance gets started.");
        start._throws(this.ref(MuleException.class));
        Conditional ifNoThread = start.body()._if(Op.eq((Expression)thread, (Expression)ExpressionFactory._null()));
        Invocation newThread = ExpressionFactory._new((TypeReference)this.ref(Thread.class));
        newThread.arg(ExpressionFactory._this());
        newThread.arg("Receiving Thread");
        ifNoThread._then().assign((AssignmentTarget)thread, (Expression)newThread);
        start.body().add((Statement)thread.invoke("start"));
    }

    private void generateSingleThreadStopMethod(DefinedClass messageSourceClass, FieldVariable thread) {
        Method stop = messageSourceClass.method(1, (Type)this.context.getCodeModel().VOID, "stop");
        stop.javadoc().add((Object)"Method to be called when Mule instance gets stopped.");
        stop._throws(this.ref(MuleException.class));
        stop.body().add((Statement)thread.invoke("interrupt"));
    }

    private void generateNoThreadStartMethod(DefinedClass messageSourceClass, ExecutableElement executableElement, Map<String, AbstractMessageGenerator.FieldVariableElement> fields, Map<String, AbstractMessageGenerator.FieldVariableElement> connectFields, FieldVariable object, FieldVariable muleContext, FieldVariable flowConstruct, FieldVariable stopSourceCallback) {
        this.generateNoThreadStartMethod(messageSourceClass, executableElement, fields, connectFields, object, muleContext, null, flowConstruct, stopSourceCallback);
    }

    private void generateNoThreadStartMethod(DefinedClass messageSourceClass, ExecutableElement executableElement, Map<String, AbstractMessageGenerator.FieldVariableElement> fields, Map<String, AbstractMessageGenerator.FieldVariableElement> connectFields, FieldVariable object, FieldVariable muleContext, DefinedClass poolObjectClass, FieldVariable flowConstruct, FieldVariable stopSourceCallback) {
        String methodName = executableElement.getSimpleName().toString();
        Source sourceAnnotation = executableElement.getAnnotation(Source.class);
        Method start = messageSourceClass.method(1, (Type)this.context.getCodeModel().VOID, "start");
        start.javadoc().add((Object)"Method to be called when Mule instance gets started.");
        start._throws(this.ref(MuleException.class));
        this.generateSourceExecution(start.body(), executableElement, fields, connectFields, object, muleContext, poolObjectClass, flowConstruct, methodName, sourceAnnotation, stopSourceCallback);
    }

    private void generateNoThreadStopMethod(DefinedClass messageSourceClass, FieldVariable stopSourceCallback, ExecutableElement executableElement) {
        String methodName = executableElement.getSimpleName().toString();
        Method stop = messageSourceClass.method(1, (Type)this.context.getCodeModel().VOID, "stop");
        stop.javadoc().add((Object)"Method to be called when Mule instance gets stopped.");
        stop._throws(this.ref(MuleException.class));
        if (stopSourceCallback != null) {
            Conditional ifStopCallbackNotNull = stop.body()._if(Op.ne((Expression)stopSourceCallback, (Expression)ExpressionFactory._null()));
            TryStatement tryToStop = ifStopCallbackNotNull._then()._try();
            tryToStop.body().add((Statement)stopSourceCallback.invoke("stop"));
            CatchBlock catchException = tryToStop._catch(this.ref(Exception.class));
            Variable e = catchException.param("e");
            Invocation messagingException = ExpressionFactory._new((TypeReference)this.ref(MessagingException.class));
            messagingException.arg((Expression)this.ref(CoreMessages.class).staticInvoke("failedToStop").arg(methodName));
            messagingException.arg((Expression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (Expression)ExpressionFactory._null()));
            messagingException.arg((Expression)e);
            catchException.body()._throw((Expression)messagingException);
        }
    }
}

