/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.client.MuleClient;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreManager;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.Cast;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.util.queue.QueueManager;

public class InjectAdapterGenerator
extends AbstractModuleGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.getFieldsAnnotatedWith(Inject.class).size() > 0;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass adapter = this.getMuleContextAwareAdapter(typeElement);
        adapter.javadoc().add((Object)("A <code>" + adapter.name() + "</code> is a wrapper around "));
        adapter.javadoc().add((Object)this.ref(typeElement.asType()));
        adapter.javadoc().add((Object)" that allows the injection of several Mule facilities when a MuleContext is set.");
        Method setMuleContext = adapter.method(1, (Type)this.context.getCodeModel().VOID, "setMuleContext");
        setMuleContext.annotate(Override.class);
        Variable context = setMuleContext.param((Type)this.ref(MuleContext.class), "context");
        for (VariableElement variable : typeElement.getFieldsAnnotatedWith(Inject.class)) {
            if (((Object)variable.asType()).toString().startsWith(MuleContext.class.getName())) {
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)context));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(ObjectStoreManager.class.getName())) {
                Cast getObjectStoreManager = ExpressionFactory.cast((Type)this.ref(ObjectStoreManager.class), (Expression)context.invoke("getRegistry").invoke("get").arg((Expression)this.ref(MuleProperties.class).staticRef("OBJECT_STORE_MANAGER")));
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getObjectStoreManager));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(TransactionManager.class.getName())) {
                Invocation getTransactionManager = context.invoke("getTransactionManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getTransactionManager));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(QueueManager.class.getName())) {
                Invocation getQueueManager = context.invoke("getQueueManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getQueueManager));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(ObjectStore.class.getName())) {
                Conditional notNull = setMuleContext.body()._if(Op.eq((Expression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)variable.getSimpleName().toString()))), (Expression)ExpressionFactory._null()));
                Invocation getObjectStore = context.invoke("getRegistry").invoke("lookupObject").arg((Expression)this.ref(MuleProperties.class).staticRef("OBJECT_STORE_DEFAULT_IN_MEMORY_NAME"));
                notNull._then().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)ExpressionFactory.cast((Type)this.ref(ObjectStore.class), (Expression)getObjectStore)));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(MuleConfiguration.class.getName())) {
                Invocation getConfiguration = context.invoke("getConfiguration");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getConfiguration));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(LifecycleManager.class.getName())) {
                Invocation getLifecycleManager = context.invoke("getLifecycleManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getLifecycleManager));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(ClassLoader.class.getName())) {
                Invocation getExecutionClassLoader = context.invoke("getExecutionClassLoader");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getExecutionClassLoader));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(ExpressionManager.class.getName())) {
                Invocation getExpressionManager = context.invoke("getExpressionManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getExpressionManager));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(EndpointFactory.class.getName())) {
                Invocation getEndpointFactory = context.invoke("getEndpointFactory");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getEndpointFactory));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(MuleClient.class.getName())) {
                Invocation getClient = context.invoke("getClient");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getClient));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(SystemExceptionHandler.class.getName())) {
                Invocation getExceptionListener = context.invoke("getExceptionListener");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getExceptionListener));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(SecurityManager.class.getName())) {
                Invocation getSecurityManager = context.invoke("getSecurityManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getSecurityManager));
                continue;
            }
            if (((Object)variable.asType()).toString().startsWith(WorkManager.class.getName())) {
                Invocation getWorkManager = context.invoke("getWorkManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getWorkManager));
                continue;
            }
            if (!((Object)variable.asType()).toString().startsWith(Registry.class.getName())) continue;
            Invocation getRegistry = context.invoke("getRegistry");
            setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("set" + StringUtils.capitalize((String)variable.getSimpleName().toString())).arg((Expression)getRegistry));
        }
    }

    private DefinedClass getMuleContextAwareAdapter(TypeElement typeElement) {
        String muleContextAwareAdapter = this.context.getNameUtils().generateClassName(typeElement, ".adapters", "InjectionAdapter");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(muleContextAwareAdapter));
        DefinedClass previous = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        if (previous == null) {
            previous = (TypeReference)this.ref(typeElement.asType());
        }
        int modifiers = 1;
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            modifiers |= 0x20;
        }
        DefinedClass clazz = pkg._class(modifiers, this.context.getNameUtils().getClassName(muleContextAwareAdapter), (TypeReference)previous);
        clazz._implements(this.ref(MuleContextAware.class));
        this.context.setClassRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement), clazz);
        return clazz;
    }
}

