/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.annotations.oauth.OAuthAccessToken;
import org.mule.api.annotations.oauth.OAuthAccessTokenSecret;
import org.mule.api.callback.HttpCallback;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.oauth.NotAuthorizedException;
import org.mule.api.oauth.RestoreAccessTokenCallback;
import org.mule.api.oauth.SaveAccessTokenCallback;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.devkit.model.code.builders.FieldBuilder;

public abstract class AbstractOAuthAdapterGenerator
extends AbstractModuleGenerator {
    public static final String VERIFIER_FIELD_NAME = "oauthVerifier";
    public static final String HAS_TOKEN_EXPIRED_METHOD_NAME = "hasTokenExpired";
    public static final String RESET_METHOD_NAME = "reset";
    public static final String OAUTH_ACCESS_TOKEN_FIELD_NAME = "accessToken";
    public static final String OAUTH_ACCESS_TOKEN_SECRET_FIELD_NAME = "accessTokenSecret";
    public static final String GET_AUTHORIZATION_URL_METHOD_NAME = "getAuthorizationUrl";
    public static final String FETCH_ACCESS_TOKEN_METHOD_NAME = "fetchAccessToken";
    public static final String OAUTH_VERIFIER_FIELD_NAME = "oauthVerifier";
    protected static final String REDIRECT_URL_FIELD_NAME = "redirectUrl";
    protected static final String ACCESS_TOKEN_FIELD_NAME = "accessToken";
    protected static final String ENCODING = "UTF-8";
    protected static final String GRANT_TYPE = "authorization_code";
    protected static final String ACCESS_CODE_PATTERN_FIELD_NAME = "ACCESS_CODE_PATTERN";
    protected static final String CALLBACK_FIELD_NAME = "oauthCallback";
    protected static final String AUTH_CODE_PATTERN_FIELD_NAME = "AUTH_CODE_PATTERN";
    protected static final String EXPIRATION_TIME_PATTERN_FIELD_NAME = "EXPIRATION_TIME_PATTERN";
    protected static final String EXPIRATION_FIELD_NAME = "expiration";
    public static final String OAUTH_SAVE_ACCESS_TOKEN_CALLBACK_FIELD_NAME = "oauthSaveAccessToken";
    public static final String OAUTH_RESTORE_ACCESS_TOKEN_CALLBACK_FIELD_NAME = "oauthRestoreAccessToken";

    protected DefinedClass getOAuthAdapterClass(TypeElement typeElement, String classSuffix, Class<?> interf) {
        String oauthAdapterName = this.context.getNameUtils().generateClassName(typeElement, ".adapters", classSuffix);
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(oauthAdapterName));
        DefinedClass classToExtend = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        DefinedClass oauthAdapter = pkg._class(this.context.getNameUtils().getClassName(oauthAdapterName), (TypeReference)classToExtend);
        oauthAdapter._implements(MuleContextAware.class);
        oauthAdapter._implements(Startable.class);
        oauthAdapter._implements(Initialisable.class);
        oauthAdapter._implements(Stoppable.class);
        oauthAdapter._implements(interf);
        this.context.setClassRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement), oauthAdapter);
        oauthAdapter.javadoc().add((Object)("A {@code " + oauthAdapter.name() + "} is a wrapper around "));
        oauthAdapter.javadoc().add((Object)this.ref(typeElement.asType()));
        oauthAdapter.javadoc().add((Object)" that adds OAuth capabilites to the pojo.");
        return oauthAdapter;
    }

    protected FieldVariable authorizationCodePatternConstant(DefinedClass oauthAdapter, String regex) {
        return new FieldBuilder(oauthAdapter).type(Pattern.class).name(AUTH_CODE_PATTERN_FIELD_NAME).staticField().finalField().initialValue((Expression)this.ref(Pattern.class).staticInvoke("compile").arg(regex)).build();
    }

    protected FieldVariable authorizationCodeField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("oauthVerifier").getterAndSetter().build();
    }

    protected FieldVariable saveAccessTokenCallbackField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(SaveAccessTokenCallback.class).name(OAUTH_SAVE_ACCESS_TOKEN_CALLBACK_FIELD_NAME).getterAndSetter().build();
    }

    protected FieldVariable restoreAccessTokenCallbackField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(RestoreAccessTokenCallback.class).name(OAUTH_RESTORE_ACCESS_TOKEN_CALLBACK_FIELD_NAME).getterAndSetter().build();
    }

    protected FieldVariable redirectUrlField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name(REDIRECT_URL_FIELD_NAME).getter().build();
    }

    protected FieldVariable accessTokenField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(String.class).name("accessToken").getterAndSetter().build();
    }

    protected FieldVariable oauthCallbackField(DefinedClass oauthAdapter) {
        return new FieldBuilder(oauthAdapter).type(HttpCallback.class).name(CALLBACK_FIELD_NAME).build();
    }

    protected void generateStartMethod(DefinedClass oauthAdapter) {
        Method start = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "start");
        start._throws(MuleException.class);
        start.body().invoke(ExpressionFactory._super(), "start");
        start.body().invoke((Expression)oauthAdapter.fields().get(CALLBACK_FIELD_NAME), "start");
        start.body().assign((AssignmentTarget)oauthAdapter.fields().get(REDIRECT_URL_FIELD_NAME), (Expression)((FieldVariable)oauthAdapter.fields().get(CALLBACK_FIELD_NAME)).invoke("getUrl"));
    }

    protected void generateStopMethod(DefinedClass oauthAdapter) {
        Method start = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "stop");
        start._throws(MuleException.class);
        start.body().invoke(ExpressionFactory._super(), "stop");
        start.body().invoke((Expression)oauthAdapter.fields().get(CALLBACK_FIELD_NAME), "stop");
    }

    protected Method generateInitialiseMethod(DefinedClass oauthAdapter, DefinedClass messageProcessor, String callbackPath) {
        Method initialise = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "initialise");
        if (this.ref(Initialisable.class).isAssignableFrom(oauthAdapter._extends())) {
            initialise.body().invoke(ExpressionFactory._super(), "initialise");
        }
        Invocation domain = ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)"domain")));
        Invocation localPort = ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)"localPort")));
        Invocation remotePort = ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)"remotePort")));
        Invocation async = ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)"async")));
        Invocation connector = ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)"connector")));
        FieldVariable callback = (FieldVariable)oauthAdapter.fields().get(CALLBACK_FIELD_NAME);
        FieldVariable muleContext = (FieldVariable)oauthAdapter.fields().get("muleContext");
        if (StringUtils.isEmpty((String)callbackPath)) {
            initialise.body().assign((AssignmentTarget)callback, (Expression)ExpressionFactory._new((TypeReference)this.context.getClassForRole("HttpCallback")).arg((Expression)ExpressionFactory._new((TypeReference)messageProcessor)).arg((Expression)muleContext).arg((Expression)domain).arg((Expression)localPort).arg((Expression)remotePort).arg((Expression)async).arg((Expression)connector));
        } else {
            initialise.body().assign((AssignmentTarget)callback, (Expression)ExpressionFactory._new((TypeReference)this.context.getClassForRole("HttpCallback")).arg((Expression)ExpressionFactory._new((TypeReference)messageProcessor)).arg((Expression)muleContext).arg((Expression)domain).arg((Expression)localPort).arg((Expression)remotePort).arg(callbackPath).arg((Expression)async));
        }
        return initialise;
    }

    protected DefinedClass generateMessageProcessorInnerClass(DefinedClass oauthAdapter) throws GenerationException {
        DefinedClass messageProcessor;
        try {
            messageProcessor = oauthAdapter._class(4, "OnOAuthCallbackMessageProcessor")._implements(this.ref(MessageProcessor.class));
        }
        catch (ClassAlreadyExistsException e) {
            throw new GenerationException(e);
        }
        Method processMethod = messageProcessor.method(1, (Type)this.ref(MuleEvent.class), "process")._throws(this.ref(MuleException.class));
        Variable event = processMethod.param((Type)this.ref(MuleEvent.class), "event");
        TryStatement tryToExtractVerifier = processMethod.body()._try();
        tryToExtractVerifier.body().assign((AssignmentTarget)oauthAdapter.fields().get("oauthVerifier"), (Expression)ExpressionFactory.invoke((String)"extractAuthorizationCode").arg((Expression)event.invoke("getMessageAsString")));
        tryToExtractVerifier.body().add((Statement)ExpressionFactory.invoke((String)FETCH_ACCESS_TOKEN_METHOD_NAME));
        CatchBlock catchBlock = tryToExtractVerifier._catch(this.ref(Exception.class));
        Variable exceptionCaught = catchBlock.param("e");
        catchBlock.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(MessagingException.class)).arg((Expression)this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Could not extract OAuth verifier")).arg((Expression)event).arg((Expression)exceptionCaught));
        processMethod.body()._return((Expression)event);
        Method extractMethod = messageProcessor.method(4, (Type)this.ref(String.class), "extractAuthorizationCode")._throws(this.ref(Exception.class));
        Variable response = extractMethod.param(String.class, "response");
        Variable matcher = extractMethod.body().decl((Type)this.ref(Matcher.class), "matcher", (Expression)((FieldVariable)oauthAdapter.fields().get(AUTH_CODE_PATTERN_FIELD_NAME)).invoke("matcher").arg((Expression)response));
        Conditional ifVerifierFound = extractMethod.body()._if(Op.cand((Expression)matcher.invoke("find"), (Expression)Op.gte((Expression)matcher.invoke("groupCount"), (Expression)ExpressionFactory.lit((int)1))));
        Invocation group = matcher.invoke("group").arg(ExpressionFactory.lit((int)1));
        ifVerifierFound._then()._return((Expression)this.ref(URLDecoder.class).staticInvoke("decode").arg((Expression)group).arg(ENCODING));
        ifVerifierFound._else()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(Exception.class)).arg((Expression)this.ref(String.class).staticInvoke("format").arg("OAuth authorization code could not be extracted from: %s").arg((Expression)response)));
        return messageProcessor;
    }

    protected void muleContextField(DefinedClass oauthAdapter) {
        new FieldBuilder(oauthAdapter).name("muleContext").type(MuleContext.class).setter().build();
    }

    protected void generateOverrides(DevKitTypeElement typeElement, DefinedClass oauthAdapter, FieldVariable oauthAccessToken, FieldVariable oauthAccessTokenSecret) {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (ExecutableElement executableElement : typeElement.getMethodsWhoseParametersAreAnnotatedWith(OAuthAccessToken.class)) {
            Method override = oauthAdapter.method(1, this.ref(executableElement.getReturnType()), executableElement.getSimpleName().toString());
            override._throws(this.ref(NotAuthorizedException.class));
            override.body().invoke("hasBeenAuthorized");
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (variableElement.getAnnotation(OAuthAccessToken.class) != null || variableElement.getAnnotation(OAuthAccessTokenSecret.class) != null) continue;
                variables.put(variableElement.getSimpleName().toString(), override.param(this.ref(variableElement.asType()), variableElement.getSimpleName().toString()));
            }
            Invocation callSuper = ExpressionFactory._super().invoke(executableElement.getSimpleName().toString());
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (variableElement.getAnnotation(OAuthAccessToken.class) != null) {
                    callSuper.arg((Expression)oauthAccessToken);
                    continue;
                }
                if (variableElement.getAnnotation(OAuthAccessTokenSecret.class) != null) {
                    callSuper.arg((Expression)oauthAccessTokenSecret);
                    continue;
                }
                callSuper.arg((Expression)variables.get(variableElement.getSimpleName().toString()));
            }
            if (this.ref(executableElement.getReturnType()) != this.context.getCodeModel().VOID) {
                override.body()._return((Expression)callSuper);
                continue;
            }
            override.body().add((Statement)callSuper);
        }
    }

    protected void generateHasBeenAuthorizedMethod(DefinedClass oauthAdapter, FieldVariable oauthAccessToken) {
        Method hasBeenAuthorized = oauthAdapter.method(1, (Type)this.context.getCodeModel().VOID, "hasBeenAuthorized");
        hasBeenAuthorized._throws(this.ref(NotAuthorizedException.class));
        Block ifAccessTokenIsNull = hasBeenAuthorized.body()._if(this.isNull((Expression)oauthAccessToken))._then();
        ifAccessTokenIsNull.invoke("restoreAccessToken");
        Block ifAccessTokenIsNull2 = ifAccessTokenIsNull._if(this.isNull((Expression)oauthAccessToken))._then();
        Invocation newNotAuthorizedException = ExpressionFactory._new((TypeReference)this.ref(NotAuthorizedException.class));
        newNotAuthorizedException.arg("This connector has not yet been authorized, please authorize by calling \"authorize\".");
        ifAccessTokenIsNull2._throw((Expression)newNotAuthorizedException);
    }
}

