/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.apt;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DefaultDevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.generation.Generator;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public abstract class AbstractAnnotationProcessor
extends AbstractProcessor {
    private GeneratorContext context;

    public abstract List<Validator> getValidators();

    public abstract List<Generator> getGenerators();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.createContext();
        for (TypeElement typeElement : annotations) {
            DefaultDevKitTypeElement devKitTypeElement;
            this.context.note("Searching for classes annotated with @" + typeElement.getSimpleName().toString());
            Set<? extends Element> elements = env.getElementsAnnotatedWith(typeElement);
            Set<TypeElement> typeElements = ElementFilter.typesIn(elements);
            for (TypeElement e : typeElements) {
                devKitTypeElement = new DefaultDevKitTypeElement(e);
                this.context.note("Validating " + devKitTypeElement.getSimpleName().toString() + " class");
                for (Validator validator : this.getValidators()) {
                    try {
                        if (!validator.shouldValidate(devKitTypeElement, this.context)) continue;
                        validator.validate(devKitTypeElement, this.context);
                    }
                    catch (ValidationException tve) {
                        this.context.error(tve.getMessage(), tve.getElement());
                        return false;
                    }
                }
            }
            for (TypeElement e : typeElements) {
                devKitTypeElement = new DefaultDevKitTypeElement(e);
                this.context.note("Generating code for " + devKitTypeElement.getSimpleName().toString() + " class");
                for (Generator generator : this.getGenerators()) {
                    try {
                        generator.generate(devKitTypeElement, this.context);
                    }
                    catch (GenerationException ge) {
                        this.context.error(ge.getMessage());
                        return false;
                    }
                }
            }
        }
        try {
            this.context.getCodeModel().build();
        }
        catch (IOException e) {
            this.context.error(e.getMessage());
            return false;
        }
        try {
            this.context.getSchemaModel().build();
        }
        catch (IOException e) {
            this.context.error(e.getMessage());
            return false;
        }
        try {
            this.context.getStudioModel().build();
        }
        catch (IOException e) {
            this.context.error(e.getMessage());
            return false;
        }
        return true;
    }

    private void createContext() {
        this.context = new GeneratorContext(this.processingEnv);
    }

    protected GeneratorContext getContext() {
        return this.context;
    }
}

