/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;
import org.mule.util.IOUtils;

public class JavaDocValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.isModuleOrConnector() && !context.isEnvOptionSet("skipJavaDocValidation");
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        if (!this.hasComment(typeElement.getInnerTypeElement(), context)) {
            throw new ValidationException((Element)typeElement, "Class " + typeElement.getQualifiedName().toString() + " is not properly documented. A summary is missing.");
        }
        if (!context.getJavaDocUtils().hasTag("author", typeElement.getInnerTypeElement())) {
            throw new ValidationException((Element)typeElement, "Class " + typeElement.getQualifiedName().toString() + " needs to have an @author tag.");
        }
        for (VariableElement variable : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            if (this.hasComment(variable, context)) continue;
            throw new ValidationException((Element)variable, "Field " + variable.getSimpleName().toString() + " is not properly documented. The description is missing.");
        }
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            this.validateMethod(typeElement, context, method);
        }
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Source.class)) {
            this.validateMethod(typeElement, context, method);
        }
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Transformer.class)) {
            this.validateMethod(typeElement, context, method);
        }
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Connect.class)) {
            this.validateAllParameters(context, method);
        }
        for (ExecutableElement method : typeElement.getMethodsAnnotatedWith(Disconnect.class)) {
            this.validateAllParameters(context, method);
        }
    }

    private void validateAllParameters(GeneratorContext context, ExecutableElement method) throws ValidationException {
        for (VariableElement variableElement : method.getParameters()) {
            if (this.hasParameterComment(variableElement.getSimpleName().toString(), variableElement.getEnclosingElement(), context)) continue;
            throw new ValidationException((Element)variableElement, "Parameter " + variableElement.getSimpleName().toString() + " of method " + method.getSimpleName().toString() + " is not properly documented. A matching @param in the method documentation was not found. ");
        }
    }

    private void validateMethod(DevKitTypeElement typeElement, GeneratorContext context, ExecutableElement method) throws ValidationException {
        if (!this.hasComment(method, context)) {
            throw new ValidationException((Element)method, "Method " + method.getSimpleName().toString() + " is not properly documented. A description of what it can do is missing.");
        }
        if (!context.getJavaDocUtils().hasTag("sample.xml", method)) {
            throw new ValidationException((Element)typeElement, "Method " + method.getSimpleName().toString() + " does not contain an example using {@sample.xml} tag.");
        }
        if (!((Object)method.getReturnType()).toString().equals("void") && !context.getJavaDocUtils().hasTag("return", method)) {
            throw new ValidationException((Element)typeElement, "The return type of a non-void method must be documented. Method " + method.getSimpleName().toString() + " is at fault. Missing @return.");
        }
        if (this.exampleDoesNotExist(context, method)) {
            throw new ValidationException((Element)typeElement, "Method " + method.getSimpleName().toString() + " does not have the example pointed by the {@sample.xml} tag");
        }
        this.validateAllParameters(context, method);
    }

    private boolean hasComment(Element element, GeneratorContext context) {
        String comment = context.getJavaDocUtils().getSummary(element);
        return StringUtils.isNotBlank((String)comment);
    }

    private boolean hasParameterComment(String paramName, Element element, GeneratorContext context) {
        String comment = context.getJavaDocUtils().getParameterSummary(paramName, element);
        return StringUtils.isNotBlank((String)comment);
    }

    private boolean exampleDoesNotExist(GeneratorContext context, ExecutableElement method) throws ValidationException {
        boolean found = false;
        String sample = context.getJavaDocUtils().getTagContent("sample.xml", method);
        String[] split = sample.split(" ");
        if (split.length != 2) {
            throw new ValidationException((Element)method, "Check @sample.xml javadoc tag because is not well formed for method: " + method.getSimpleName());
        }
        String pathToExamplesFile = split[0];
        String exampleName = split[1];
        TypeElement typeElement = (TypeElement)method.getEnclosingElement();
        String sourcePath = context.getSourceUtils().getPath(typeElement);
        for (int packageCount = StringUtils.countMatches((String)typeElement.getQualifiedName().toString(), (String)".") + 1; packageCount > 0; --packageCount) {
            sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf("/"));
        }
        try {
            File docFile = new File(sourcePath, pathToExamplesFile);
            String examplesFileContent = IOUtils.toString((InputStream)new FileInputStream(docFile));
            if (examplesFileContent.contains("BEGIN_INCLUDE(" + exampleName + ")")) {
                found = true;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return !found;
    }
}

