/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.client.MuleClient;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.store.ObjectStoreManager;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;
import org.mule.util.queue.QueueManager;

public class InjectValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.getFieldsAnnotatedWith(Inject.class).size() > 0;
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        for (VariableElement variable : typeElement.getFieldsAnnotatedWith(Inject.class)) {
            if (!(((Object)variable.asType()).toString().startsWith(MuleContext.class.getName()) || ((Object)variable.asType()).toString().startsWith(ObjectStoreManager.class.getName()) || ((Object)variable.asType()).toString().startsWith(TransactionManager.class.getName()) || ((Object)variable.asType()).toString().startsWith(QueueManager.class.getName()) || ((Object)variable.asType()).toString().startsWith(MuleConfiguration.class.getName()) || ((Object)variable.asType()).toString().startsWith(LifecycleManager.class.getName()) || ((Object)variable.asType()).toString().startsWith(ClassLoader.class.getName()) || ((Object)variable.asType()).toString().startsWith(ExpressionManager.class.getName()) || ((Object)variable.asType()).toString().startsWith(EndpointFactory.class.getName()) || ((Object)variable.asType()).toString().startsWith(MuleClient.class.getName()) || ((Object)variable.asType()).toString().startsWith(SystemExceptionHandler.class.getName()) || ((Object)variable.asType()).toString().startsWith(SecurityManager.class.getName()) || ((Object)variable.asType()).toString().startsWith(WorkManager.class.getName()) || ((Object)variable.asType()).toString().startsWith(Registry.class.getName()))) {
                throw new ValidationException((Element)variable, "I don't know how to inject the type " + ((Object)variable.asType()).toString() + " in field " + variable.getSimpleName().toString() + ". " + "The only types I know how to inject are: MuleContext, ObjectStoreManager, TransactionManager, QueueManager, MuleConfiguration, LifecycleManager, ClassLoader," + "ExpressionManager, EndpointFactory, MuleClient, SystemExceptionHandler, SecurityManager, WorkManager, Registry");
            }
            boolean found = false;
            for (ExecutableElement method : typeElement.getMethods()) {
                if (!method.getSimpleName().toString().equals("set" + StringUtils.capitalize((String)variable.getSimpleName().toString()))) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new ValidationException((Element)variable, "Cannot find a setter method for " + variable.getSimpleName().toString() + " but its being marked as injectable.");
        }
    }
}

