/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.ValidateConnection;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class ConnectorValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.isModuleOrConnector();
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        List<ExecutableElement> connectMethods = typeElement.getMethodsAnnotatedWith(Connect.class);
        List<ExecutableElement> validateConnectionMethods = typeElement.getMethodsAnnotatedWith(ValidateConnection.class);
        List<ExecutableElement> disconnectMethods = typeElement.getMethodsAnnotatedWith(Disconnect.class);
        List<ExecutableElement> connectionIdentifierMethods = typeElement.getMethodsAnnotatedWith(ConnectionIdentifier.class);
        if (typeElement.hasAnnotation(Module.class)) {
            if (!connectMethods.isEmpty()) {
                throw new ValidationException((Element)typeElement, "@Connect methods not allowed for @Module classes, use class level annotation @Connector instead");
            }
            if (!validateConnectionMethods.isEmpty()) {
                throw new ValidationException((Element)typeElement, "@Connect methods not allowed for @Module classes, use class level annotation @Connector instead");
            }
            if (!disconnectMethods.isEmpty()) {
                throw new ValidationException((Element)typeElement, "@Connect methods not allowed for @Module classes, use class level annotation @Connector instead");
            }
            if (!connectionIdentifierMethods.isEmpty()) {
                throw new ValidationException((Element)typeElement, "@Connect methods not allowed for @Module classes, use class level annotation @Connector instead");
            }
            return;
        }
        this.checkConnectMethod(typeElement, connectMethods);
        this.checkDisconnetcMethod(typeElement, disconnectMethods);
        this.checkConnectionIdentifierMethod(typeElement, connectionIdentifierMethods);
        this.checkValidateConnectionMethod(typeElement, validateConnectionMethods);
    }

    private void checkConnectMethod(DevKitTypeElement typeElement, List<ExecutableElement> connectMethods) throws ValidationException {
        if (connectMethods.size() != 1) {
            throw new ValidationException((Element)typeElement, "You must have exactly one method annotated with @Connect");
        }
        ExecutableElement connectMethod = connectMethods.get(0);
        if (!connectMethod.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationException((Element)typeElement, "A @Connect method must be public.");
        }
        if (connectMethod.getThrownTypes().size() != 1) {
            throw new ValidationException((Element)typeElement, "A @Connect method can only throw a single type of exception. That exception must be ConnectionException.");
        }
        if (!((Object)connectMethod.getThrownTypes().get(0)).toString().equals("org.mule.api.ConnectionException")) {
            throw new ValidationException((Element)typeElement, "A @Connect method can only throw a single type of exception. That exception must be ConnectionException.");
        }
        if (!((Object)connectMethod.getReturnType()).toString().equals("void")) {
            throw new ValidationException((Element)typeElement, "A @Connect method cannot return anything.");
        }
    }

    private void checkDisconnetcMethod(DevKitTypeElement typeElement, List<ExecutableElement> disconnectMethods) throws ValidationException {
        if (disconnectMethods.size() != 1) {
            throw new ValidationException((Element)typeElement, "You must have exactly one method annotated with @Disconnect");
        }
        ExecutableElement disconnectMethod = disconnectMethods.get(0);
        if (!disconnectMethod.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationException((Element)typeElement, "A @Disconnect method must be public.");
        }
        if (!disconnectMethod.getParameters().isEmpty()) {
            throw new ValidationException((Element)typeElement, "The @Disconnect method cannot receive any arguments");
        }
        if (!((Object)disconnectMethod.getReturnType()).toString().equals("void")) {
            throw new ValidationException((Element)typeElement, "A @Disconnect method cannot return anything.");
        }
    }

    private void checkValidateConnectionMethod(DevKitTypeElement typeElement, List<ExecutableElement> validateConnectionMethods) throws ValidationException {
        if (validateConnectionMethods.size() != 1) {
            throw new ValidationException((Element)typeElement, "You must have exactly one method annotated with @ValidateConnection");
        }
        ExecutableElement validateConnectionMethod = validateConnectionMethods.get(0);
        if (!validateConnectionMethod.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationException((Element)typeElement, "A @ValidateConnection method must be public.");
        }
        if (!((Object)validateConnectionMethod.getReturnType()).toString().equals("boolean") && !((Object)validateConnectionMethod.getReturnType()).toString().equals("java.lang.Boolean")) {
            throw new ValidationException((Element)typeElement, "A @ValidateConnection method must return a boolean.");
        }
        if (!validateConnectionMethod.getParameters().isEmpty()) {
            throw new ValidationException((Element)typeElement, "The @ValidateConnection method cannot receive any arguments");
        }
    }

    private void checkConnectionIdentifierMethod(DevKitTypeElement typeElement, List<ExecutableElement> connectionIdentifierMethods) throws ValidationException {
        if (connectionIdentifierMethods.size() != 1) {
            throw new ValidationException((Element)typeElement, "You must have exactly one method annotated with @ConnectionIdentifier");
        }
        ExecutableElement connectionIdentifierMethod = connectionIdentifierMethods.get(0);
        if (!((Object)connectionIdentifierMethod.getReturnType()).toString().equals("java.lang.String")) {
            throw new ValidationException((Element)typeElement, "A @ConnectionIdentifier must return java.lang.String.");
        }
        if (!connectionIdentifierMethod.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ValidationException((Element)typeElement, "A @ConnectionIdentifier method must be public.");
        }
        if (connectionIdentifierMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ValidationException((Element)typeElement, "A @ConnectionIdentifier cannot be static.");
        }
        if (!connectionIdentifierMethod.getParameters().isEmpty()) {
            throw new ValidationException((Element)typeElement, "The @ConnectionIdentifier method cannot receive any arguments");
        }
    }
}

