/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.validation;

import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.validation.ValidationException;
import org.mule.devkit.validation.Validator;

public class BasicValidator
implements Validator {
    @Override
    public boolean shouldValidate(DevKitTypeElement typeElement, GeneratorContext context) {
        return typeElement.isModuleOrConnector();
    }

    @Override
    public void validate(DevKitTypeElement typeElement, GeneratorContext context) throws ValidationException {
        if (typeElement.isInterface()) {
            throw new ValidationException((Element)typeElement, "@Module/@Connector cannot be applied to an interface");
        }
        if (typeElement.isParametrized()) {
            throw new ValidationException((Element)typeElement, "@Module/@Connector type cannot have type parameters");
        }
        if (!typeElement.isPublic()) {
            throw new ValidationException((Element)typeElement, "@Module/@Connector must be public");
        }
        for (VariableElement variable : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            if (variable.getModifiers().contains((Object)Modifier.FINAL)) {
                throw new ValidationException((Element)variable, "@Configurable cannot be applied to field with final modifier");
            }
            if (variable.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new ValidationException((Element)variable, "@Configurable cannot be applied to field with static modifier");
            }
            if (variable.asType().getKind() == TypeKind.ARRAY) {
                throw new ValidationException((Element)variable, "@Configurable cannot be applied to arrays");
            }
            Optional optional = variable.getAnnotation(Optional.class);
            Default def = variable.getAnnotation(Default.class);
            if (variable.asType().getKind().isPrimitive() && optional != null && (def == null || def.value().length() == 0)) {
                throw new ValidationException((Element)variable, "@Optional @Configurable fields can only be applied to non-primitive types with a @Default value");
            }
            if (def == null || optional != null) continue;
            throw new ValidationException((Element)variable, "@Default @Configurable fields must also include @Optional, otherwise the @Default will never take place.");
        }
    }
}

