/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring;

import java.io.StringWriter;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.SourceCallback;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.PoolingProfile;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.spring.SchemaTypeConversion;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.Block;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.ForEach;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class BeanDefinitionParserGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return true;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        this.generateConfigBeanDefinitionParserFor(typeElement);
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            this.generateBeanDefinitionParserForProcessor(executableElement);
        }
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Source.class)) {
            this.generateBeanDefinitionParserForSource(executableElement);
        }
    }

    private void generateConfigBeanDefinitionParserFor(DevKitTypeElement typeElement) {
        DefinedClass beanDefinitionparser = this.getConfigBeanDefinitionParserClass(typeElement);
        DefinedClass pojo = this.context.getClassForRole(this.context.getNameUtils().generateModuleObjectRoleKey(typeElement));
        FieldVariable patternInfo = this.generateFieldForPatternInfo(beanDefinitionparser);
        Method constructor = beanDefinitionparser.constructor(1);
        constructor.body().assign((AssignmentTarget)patternInfo, (Expression)this.ref(TemplateParser.class).staticInvoke("createMuleStyleParser").invoke("getStyle"));
        Method parse = beanDefinitionparser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        Variable element = parse.param((Type)this.ref(Element.class), "element");
        Variable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContent");
        Variable name = parse.body().decl((Type)this.ref(String.class), "name", (Expression)element.invoke("getAttribute").arg("name"));
        Conditional ifNotNamed = parse.body()._if(Op.cor((Expression)Op.eq((Expression)name, (Expression)ExpressionFactory._null()), (Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)name)));
        ifNotNamed._then().add((Statement)element.invoke("setAttribute").arg("name").arg((Expression)this.ref(AutoIdUtils.class).staticInvoke("getUniqueName").arg((Expression)element).arg("mule-bean")));
        Variable builder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "builder", (Expression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((Expression)pojo.dotclass().invoke("getName")));
        Conditional isInitialisable = parse.body()._if((Expression)this.ref(Initialisable.class).dotclass().invoke("isAssignableFrom").arg(pojo.dotclass()));
        isInitialisable._then().add((Statement)builder.invoke("setInitMethodName").arg((Expression)this.ref(Initialisable.class).staticRef("PHASE_NAME")));
        Conditional isDisposable = parse.body()._if((Expression)this.ref(Disposable.class).dotclass().invoke("isAssignableFrom").arg(pojo.dotclass()));
        isDisposable._then().add((Statement)builder.invoke("setDestroyMethodName").arg((Expression)this.ref(Disposable.class).staticRef("PHASE_NAME")));
        for (VariableElement variable : typeElement.getFieldsAnnotatedWith(Configurable.class)) {
            Variable listElement;
            String string = variable.getSimpleName().toString();
            if (SchemaTypeConversion.isSupported(((Object)variable.asType()).toString())) {
                this.generateParseSupportedType(parse.body(), element, builder, string);
                continue;
            }
            if (this.context.getTypeMirrorUtils().isXmlType(variable.asType())) {
                this.generateParseXmlType(parse.body(), element, builder, string);
                continue;
            }
            if (this.context.getTypeMirrorUtils().isArrayOrList(variable.asType())) {
                listElement = parse.body().decl((Type)this.ref(Element.class), string + "ListElement", ExpressionFactory._null());
                parse.body().assign((AssignmentTarget)listElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(string)));
                UpperBlockClosure managedList = this.generateParseArrayOrList(parse.body(), variable.asType(), listElement, builder, string, (Variable)patternInfo, parserContext);
                managedList.getNotRefBlock().add((Statement)builder.invoke("addPropertyValue").arg(string).arg((Expression)managedList.getManagedCollection()));
                continue;
            }
            if (this.context.getTypeMirrorUtils().isMap(variable.asType())) {
                listElement = parse.body().decl((Type)this.ref(Element.class), string + "ListElement", ExpressionFactory._null());
                parse.body().assign((AssignmentTarget)listElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(string)));
                UpperBlockClosure managedMap = this.generateParseMap(parse.body(), variable.asType(), listElement, builder, string, (Variable)patternInfo, parserContext);
                managedMap.getNotRefBlock().add((Statement)builder.invoke("addPropertyValue").arg(string).arg((Expression)managedMap.getManagedCollection()));
                continue;
            }
            if (this.context.getTypeMirrorUtils().isEnum(variable.asType())) {
                this.generateParseEnum(parse.body(), element, builder, string);
                continue;
            }
            Invocation getAttribute = element.invoke("getAttribute").arg(string + "-ref");
            Conditional ifNotNull = parse.body()._if(Op.cand((Expression)Op.ne((Expression)getAttribute, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)getAttribute))));
            ifNotNull._then().add((Statement)builder.invoke("addPropertyValue").arg(string).arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((Expression)element.invoke("getAttribute").arg(string + "-ref"))));
        }
        ExecutableElement connect = this.connectMethodForClass(typeElement);
        if (connect != null) {
            for (VariableElement variableElement : connect.getParameters()) {
                Variable listElement;
                String fieldName = variableElement.getSimpleName().toString();
                if (SchemaTypeConversion.isSupported(((Object)variableElement.asType()).toString())) {
                    this.generateParseSupportedType(parse.body(), element, builder, fieldName);
                    continue;
                }
                if (this.context.getTypeMirrorUtils().isArrayOrList(variableElement.asType())) {
                    listElement = parse.body().decl((Type)this.ref(Element.class), fieldName + "ListElement", ExpressionFactory._null());
                    parse.body().assign((AssignmentTarget)listElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(fieldName)));
                    UpperBlockClosure managedList = this.generateParseArrayOrList(parse.body(), variableElement.asType(), listElement, builder, fieldName, (Variable)patternInfo, parserContext);
                    managedList.getNotRefBlock().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)managedList.getManagedCollection()));
                    continue;
                }
                if (this.context.getTypeMirrorUtils().isMap(variableElement.asType())) {
                    listElement = parse.body().decl((Type)this.ref(Element.class), fieldName + "ListElement", ExpressionFactory._null());
                    parse.body().assign((AssignmentTarget)listElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(fieldName)));
                    UpperBlockClosure managedMap = this.generateParseMap(parse.body(), variableElement.asType(), listElement, builder, fieldName, (Variable)patternInfo, parserContext);
                    managedMap.getNotRefBlock().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)managedMap.getManagedCollection()));
                    continue;
                }
                if (!this.context.getTypeMirrorUtils().isEnum(variableElement.asType())) continue;
                this.generateParseEnum(parse.body(), element, builder, fieldName);
            }
        }
        if (typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class)) {
            this.generateParseHttpCallback("oauth-callback-config", parse, element, builder);
            DefinedClass saveAccessTokenCallbackFactory = this.context.getClassForRole("SaveAccessTokenCallbackFactoryBean");
            DefinedClass definedClass = this.context.getClassForRole("RestoreAccessTokenCallbackFactoryBean");
            this.generateParseNestedProcessor(parse.body(), element, parserContext, builder, "oauthSaveAccessToken", false, false, false, (TypeReference)saveAccessTokenCallbackFactory);
            this.generateParseNestedProcessor(parse.body(), element, parserContext, builder, "oauthRestoreAccessToken", false, false, false, (TypeReference)definedClass);
            this.generateGenerateChildBeanNameMethod(beanDefinitionparser);
        }
        if (typeElement.hasProcessorMethodWithParameter(HttpCallback.class)) {
            this.generateParseHttpCallback("http-callback-config", parse, element, builder);
        }
        if (connect != null) {
            this.generateParsePoolingProfile("connection-pooling-profile", "connectionPoolingProfile", parse, element, builder);
        }
        if (typeElement.isPoolable()) {
            this.generateParsePoolingProfile("pooling-profile", "poolingProfile", parse, element, builder);
        }
        Variable definition = parse.body().decl((Type)this.ref(BeanDefinition.class), "definition", (Expression)builder.invoke("getBeanDefinition"));
        parse.body().add((Statement)definition.invoke("setAttribute").arg((Expression)this.ref(MuleHierarchicalBeanDefinitionParserDelegate.class).staticRef("MULE_NO_RECURSE")).arg((Expression)this.ref(Boolean.class).staticRef("TRUE")));
        parse.body()._return((Expression)definition);
    }

    private void generateParseHttpCallback(String elementName, Method parse, Variable element, Variable builder) {
        Variable listElement = parse.body().decl((Type)this.ref(Element.class), "httpCallbackConfigElement", (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(elementName));
        Block ifHttpCallbackConfigPresent = parse.body()._if(Op.ne((Expression)listElement, (Expression)ExpressionFactory._null()))._then();
        this.generateParseSupportedType(ifHttpCallbackConfigPresent, listElement, builder, "domain");
        this.generateParseSupportedType(ifHttpCallbackConfigPresent, listElement, builder, "localPort");
        this.generateParseSupportedType(ifHttpCallbackConfigPresent, listElement, builder, "remotePort");
        this.generateParseSupportedType(ifHttpCallbackConfigPresent, listElement, builder, "async");
    }

    private void generateParsePoolingProfile(String elementName, String propertyName, Method parse, Variable element, Variable builder) {
        Variable poolingProfileBuilder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), propertyName + "Builder", (Expression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((Expression)this.ref(PoolingProfile.class).dotclass().invoke("getName")));
        Variable poolingProfileElement = parse.body().decl((Type)this.ref(Element.class), propertyName + "Element", (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(elementName));
        Conditional ifElementNotNull = parse.body()._if(Op.ne((Expression)poolingProfileElement, (Expression)ExpressionFactory._null()));
        this.generateParseSupportedType(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxActive");
        this.generateParseSupportedType(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxIdle");
        this.generateParseSupportedType(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxWait");
        Invocation getAttribute = poolingProfileElement.invoke("getAttribute").arg("exhaustedAction");
        Conditional ifNotNull = ifElementNotNull._then()._if(Op.cand((Expression)Op.ne((Expression)getAttribute, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)getAttribute))));
        ifNotNull._then().add((Statement)poolingProfileBuilder.invoke("addPropertyValue").arg("exhaustedAction").arg((Expression)this.ref(PoolingProfile.class).staticRef("POOL_EXHAUSTED_ACTIONS").invoke("get").arg((Expression)poolingProfileElement.invoke("getAttribute").arg("exhaustedAction"))));
        getAttribute = poolingProfileElement.invoke("getAttribute").arg("exhaustedAction");
        ifNotNull = ifElementNotNull._then()._if(Op.cand((Expression)Op.ne((Expression)getAttribute, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)getAttribute))));
        ifNotNull._then().add((Statement)poolingProfileBuilder.invoke("addPropertyValue").arg("initialisationPolicy").arg((Expression)this.ref(PoolingProfile.class).staticRef("POOL_INITIALISATION_POLICIES").invoke("get").arg((Expression)poolingProfileElement.invoke("getAttribute").arg("initialisationPolicy"))));
        ifElementNotNull._then().add((Statement)builder.invoke("addPropertyValue").arg(propertyName).arg((Expression)poolingProfileBuilder.invoke("getBeanDefinition")));
    }

    private void generateBeanDefinitionParserForSource(ExecutableElement executableElement) {
        DefinedClass beanDefinitionparser = this.getBeanDefinitionParserClass(executableElement);
        DefinedClass messageSourceClass = this.getMessageSourceClass(executableElement);
        FieldVariable patternInfo = this.generateFieldForPatternInfo(beanDefinitionparser);
        Method constructor = beanDefinitionparser.constructor(1);
        constructor.body().assign((AssignmentTarget)patternInfo, (Expression)this.ref(TemplateParser.class).staticInvoke("createMuleStyleParser").invoke("getStyle"));
        this.generateSourceParseMethod(beanDefinitionparser, messageSourceClass, executableElement, (Variable)patternInfo);
        this.generateGenerateChildBeanNameMethod(beanDefinitionparser);
    }

    private void generateBeanDefinitionParserForProcessor(ExecutableElement executableElement) {
        DefinedClass beanDefinitionparser = this.getBeanDefinitionParserClass(executableElement);
        DefinedClass messageProcessorClass = executableElement.getAnnotation(Processor.class).intercepting() ? this.getInterceptingMessageProcessorClass(executableElement) : this.getMessageProcessorClass(executableElement);
        FieldVariable patternInfo = this.generateFieldForPatternInfo(beanDefinitionparser);
        Method constructor = beanDefinitionparser.constructor(1);
        constructor.body().assign((AssignmentTarget)patternInfo, (Expression)this.ref(TemplateParser.class).staticInvoke("createMuleStyleParser").invoke("getStyle"));
        this.generateProcessorParseMethod(beanDefinitionparser, messageProcessorClass, executableElement, (Variable)patternInfo);
        this.generateGenerateChildBeanNameMethod(beanDefinitionparser);
    }

    private void generateProcessorParseMethod(DefinedClass beanDefinitionparser, DefinedClass messageProcessorClass, ExecutableElement executableElement, Variable patternInfo) {
        Method parse = beanDefinitionparser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        Variable element = parse.param((Type)this.ref(Element.class), "element");
        Variable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContent");
        Variable definition = this.generateParseCommon(beanDefinitionparser, messageProcessorClass, executableElement, parse, element, patternInfo, parserContext);
        this.generateAttachMessageProcessor(parse, definition, parserContext);
        parse.body()._return((Expression)definition);
    }

    private void generateSourceParseMethod(DefinedClass beanDefinitionparser, DefinedClass messageProcessorClass, ExecutableElement executableElement, Variable patternInfo) {
        Method parse = beanDefinitionparser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        Variable element = parse.param((Type)this.ref(Element.class), "element");
        Variable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContent");
        Variable definition = this.generateParseCommon(beanDefinitionparser, messageProcessorClass, executableElement, parse, element, patternInfo, parserContext);
        this.generateAttachMessageSource(parse, definition, parserContext);
        parse.body()._return((Expression)definition);
    }

    private Variable generateParseCommon(DefinedClass beanDefinitionparser, DefinedClass messageProcessorClass, ExecutableElement executableElement, Method parse, Variable element, Variable patternInfo, Variable parserContext) {
        Variable builder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "builder", (Expression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((Expression)messageProcessorClass.dotclass().invoke("getName")));
        Variable configRef = parse.body().decl((Type)this.ref(String.class), "configRef", (Expression)element.invoke("getAttribute").arg("config-ref"));
        Conditional ifConfigRef = parse.body()._if(Op.cand((Expression)Op.ne((Expression)configRef, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)configRef))));
        ifConfigRef._then().add((Statement)builder.invoke("addPropertyValue").arg("moduleObject").arg((Expression)configRef));
        Method getAttributeValue = this.generateGetAttributeValue(beanDefinitionparser);
        int requiredChildElements = 0;
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (this.context.getTypeMirrorUtils().ignoreParameter(variableElement)) continue;
            if (this.context.getTypeMirrorUtils().isNestedProcessor(variableElement.asType())) {
                ++requiredChildElements;
                continue;
            }
            if (this.context.getTypeMirrorUtils().isXmlType(variableElement.asType())) {
                ++requiredChildElements;
                continue;
            }
            if (!this.context.getTypeMirrorUtils().isCollection(variableElement.asType())) continue;
            ++requiredChildElements;
        }
        for (VariableElement variableElement : executableElement.getParameters()) {
            if (((Object)variableElement.asType()).toString().startsWith(SourceCallback.class.getName())) continue;
            String string = variableElement.getSimpleName().toString();
            if (this.context.getTypeMirrorUtils().isNestedProcessor(variableElement.asType())) {
                boolean isList = this.context.getTypeMirrorUtils().isArrayOrList(variableElement.asType());
                if (requiredChildElements == 1) {
                    this.generateParseNestedProcessor(parse.body(), element, parserContext, builder, string, true, isList, true, this.ref(MessageProcessorChainFactoryBean.class));
                    continue;
                }
                this.generateParseNestedProcessor(parse.body(), element, parserContext, builder, string, false, isList, true, this.ref(MessageProcessorChainFactoryBean.class));
                continue;
            }
            if (SchemaTypeConversion.isSupported(((Object)variableElement.asType()).toString())) {
                this.generateParseSupportedType(parse.body(), element, builder, string);
                continue;
            }
            if (this.context.getTypeMirrorUtils().isXmlType(variableElement.asType())) {
                this.generateParseXmlType(parse.body(), element, builder, string);
                continue;
            }
            if (this.context.getTypeMirrorUtils().isArrayOrList(variableElement.asType())) {
                Variable listElement = parse.body().decl((Type)this.ref(Element.class), string + "ListElement", ExpressionFactory._null());
                parse.body().assign((AssignmentTarget)listElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(string)));
                UpperBlockClosure managedList = this.generateParseArrayOrList(parse.body(), variableElement.asType(), listElement, builder, string, patternInfo, parserContext);
                managedList.getNotRefBlock().add((Statement)builder.invoke("addPropertyValue").arg(string).arg((Expression)managedList.getManagedCollection()));
                continue;
            }
            if (this.context.getTypeMirrorUtils().isMap(variableElement.asType())) {
                Variable listElement = parse.body().decl((Type)this.ref(Element.class), string + "ListElement", ExpressionFactory._null());
                parse.body().assign((AssignmentTarget)listElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(string)));
                UpperBlockClosure managedMap = this.generateParseMap(parse.body(), variableElement.asType(), listElement, builder, string, patternInfo, parserContext);
                managedMap.getNotRefBlock().add((Statement)builder.invoke("addPropertyValue").arg(string).arg((Expression)managedMap.getManagedCollection()));
                continue;
            }
            if (this.context.getTypeMirrorUtils().isEnum(variableElement.asType())) {
                this.generateParseEnum(parse.body(), element, builder, string);
                continue;
            }
            if (((Object)variableElement.asType()).toString().startsWith(HttpCallback.class.getName())) {
                Variable callbackFlowName = parse.body().decl((Type)this.ref(String.class), string + "CallbackFlowName", (Expression)ExpressionFactory.invoke((Method)getAttributeValue).arg((Expression)element).arg(this.context.getNameUtils().uncamel(string) + "-flow-ref"));
                Block block = parse.body()._if(Op.ne((Expression)callbackFlowName, (Expression)ExpressionFactory._null()))._then();
                block.invoke((Expression)builder, "addPropertyValue").arg(string + "CallbackFlow").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((Expression)callbackFlowName));
                continue;
            }
            Invocation getAttribute = element.invoke("getAttribute").arg(string + "-ref");
            Conditional ifNotNull = parse.body()._if(Op.cand((Expression)Op.ne((Expression)getAttribute, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)getAttribute))));
            Conditional ifNotExpression = ifNotNull._then()._if((Expression)getAttribute.invoke("startsWith").arg("#"));
            ifNotExpression._else().add((Statement)builder.invoke("addPropertyValue").arg(string).arg(Op.plus((Expression)Op.plus((Expression)ExpressionFactory.lit((String)"#[registry:"), (Expression)element.invoke("getAttribute").arg(string + "-ref")), (Expression)ExpressionFactory.lit((String)"]"))));
            ifNotExpression._then().add((Statement)builder.invoke("addPropertyValue").arg(string).arg((Expression)element.invoke("getAttribute").arg(string + "-ref")));
        }
        ExecutableElement connectMethod = this.connectForMethod(executableElement);
        if (connectMethod != null) {
            this.generateParseSupportedType(parse.body(), element, builder, "retryMax");
            for (VariableElement variableElement : connectMethod.getParameters()) {
                Variable listElement;
                String fieldName = variableElement.getSimpleName().toString();
                if (SchemaTypeConversion.isSupported(((Object)variableElement.asType()).toString())) {
                    this.generateParseSupportedType(parse.body(), element, builder, fieldName);
                    continue;
                }
                if (this.context.getTypeMirrorUtils().isArrayOrList(variableElement.asType())) {
                    listElement = parse.body().decl((Type)this.ref(Element.class), fieldName + "ListElement", ExpressionFactory._null());
                    parse.body().assign((AssignmentTarget)listElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(fieldName)));
                    UpperBlockClosure managedList = this.generateParseArrayOrList(parse.body(), variableElement.asType(), listElement, builder, fieldName, patternInfo, parserContext);
                    managedList.getNotRefBlock().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)managedList.getManagedCollection()));
                    continue;
                }
                if (this.context.getTypeMirrorUtils().isMap(variableElement.asType())) {
                    listElement = parse.body().decl((Type)this.ref(Element.class), fieldName + "ListElement", ExpressionFactory._null());
                    parse.body().assign((AssignmentTarget)listElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(fieldName)));
                    UpperBlockClosure managedMap = this.generateParseMap(parse.body(), variableElement.asType(), listElement, builder, fieldName, patternInfo, parserContext);
                    managedMap.getNotRefBlock().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)managedMap.getManagedCollection()));
                    continue;
                }
                if (!this.context.getTypeMirrorUtils().isEnum(variableElement.asType())) continue;
                this.generateParseEnum(parse.body(), element, builder, fieldName);
            }
        }
        Variable variable = parse.body().decl((Type)this.ref(BeanDefinition.class), "definition", (Expression)builder.invoke("getBeanDefinition"));
        parse.body().add((Statement)variable.invoke("setAttribute").arg((Expression)this.ref(MuleHierarchicalBeanDefinitionParserDelegate.class).staticRef("MULE_NO_RECURSE")).arg((Expression)this.ref(Boolean.class).staticRef("TRUE")));
        return variable;
    }

    private void generateParseNestedProcessor(Block block, Variable element, Variable parserContext, Variable builder, String fieldName, boolean skipElement, boolean isList, boolean allowTextAttribute, TypeReference factoryBean) {
        Variable elements = element;
        if (!skipElement) {
            elements = block.decl((Type)this.ref(Element.class), fieldName + "Element", (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(fieldName)));
        }
        Conditional ifNotNull = block._if(Op.ne((Expression)elements, (Expression)ExpressionFactory._null()));
        Block beanDefinitionBuidlerBlock = null;
        if (allowTextAttribute) {
            Variable text = ifNotNull._then().decl((Type)this.ref(String.class), "text", (Expression)elements.invoke("getAttribute").arg("text"));
            Conditional ifTextElement = ifNotNull._then()._if(Op.cand((Expression)Op.ne((Expression)text, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)text))));
            ifTextElement._then().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)text));
            beanDefinitionBuidlerBlock = ifTextElement._else();
        } else {
            beanDefinitionBuidlerBlock = ifNotNull._then();
        }
        Variable beanDefinitionBuilder = beanDefinitionBuidlerBlock.decl((Type)this.ref(BeanDefinitionBuilder.class), fieldName + "BeanDefinitionBuilder", (Expression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg(factoryBean.dotclass()));
        Variable beanDefinition = beanDefinitionBuidlerBlock.decl((Type)this.ref(BeanDefinition.class), fieldName + "BeanDefinition", (Expression)beanDefinitionBuilder.invoke("getBeanDefinition"));
        beanDefinitionBuidlerBlock.add((Statement)parserContext.invoke("getRegistry").invoke("registerBeanDefinition").arg((Expression)ExpressionFactory.invoke((String)"generateChildBeanName").arg((Expression)elements)).arg((Expression)beanDefinition));
        beanDefinitionBuidlerBlock.add((Statement)elements.invoke("setAttribute").arg("name").arg((Expression)ExpressionFactory.invoke((String)"generateChildBeanName").arg((Expression)elements)));
        beanDefinitionBuidlerBlock.add((Statement)beanDefinitionBuilder.invoke("setSource").arg((Expression)parserContext.invoke("extractSource").arg((Expression)elements)));
        beanDefinitionBuidlerBlock.add((Statement)beanDefinitionBuilder.invoke("setScope").arg((Expression)this.ref(BeanDefinition.class).staticRef("SCOPE_SINGLETON")));
        Variable list = beanDefinitionBuidlerBlock.decl((Type)this.ref(List.class), fieldName + "List", (Expression)parserContext.invoke("getDelegate").invoke("parseListElement").arg((Expression)elements).arg((Expression)beanDefinitionBuilder.invoke("getBeanDefinition")));
        beanDefinitionBuidlerBlock.add((Statement)parserContext.invoke("getRegistry").invoke("removeBeanDefinition").arg((Expression)ExpressionFactory.invoke((String)"generateChildBeanName").arg((Expression)elements)));
        if (!isList) {
            beanDefinitionBuidlerBlock.add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)beanDefinition));
        } else {
            beanDefinitionBuidlerBlock.add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)list));
        }
    }

    private void generateParseXmlType(Block block, Variable element, Variable builder, String fieldName) {
        Variable xmlElement = block.decl((Type)this.ref(Element.class), fieldName + "xmlElement", ExpressionFactory._null());
        block.assign((AssignmentTarget)xmlElement, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((Expression)element).arg(this.context.getNameUtils().uncamel(fieldName)));
        Conditional xmlElementNotNull = block._if(Op.ne((Expression)xmlElement, (Expression)ExpressionFactory._null()));
        TryStatement tryBlock = xmlElementNotNull._then()._try();
        Variable xmlElementChilds = tryBlock.body().decl((Type)this.ref(List.class).narrow(Element.class), "xmlElementChilds", (Expression)this.ref(DomUtils.class).staticInvoke("getChildElements").arg((Expression)xmlElement));
        Conditional xmlElementChildsNotEmpty = tryBlock.body()._if(Op.gt((Expression)xmlElementChilds.invoke("size"), (Expression)ExpressionFactory.lit((int)0)));
        Variable domSource = xmlElementChildsNotEmpty._then().decl((Type)this.ref(DOMSource.class), "domSource", (Expression)ExpressionFactory._new((TypeReference)this.ref(DOMSource.class)).arg((Expression)xmlElementChilds.invoke("get").arg(ExpressionFactory.lit((int)0))));
        Variable stringWriter = xmlElementChildsNotEmpty._then().decl((Type)this.ref(StringWriter.class), "stringWriter", (Expression)ExpressionFactory._new((TypeReference)this.ref(StringWriter.class)));
        Variable streamResult = xmlElementChildsNotEmpty._then().decl((Type)this.ref(StreamResult.class), "result", (Expression)ExpressionFactory._new((TypeReference)this.ref(StreamResult.class)).arg((Expression)stringWriter));
        Variable tf = xmlElementChildsNotEmpty._then().decl((Type)this.ref(TransformerFactory.class), "tf", (Expression)this.ref(TransformerFactory.class).staticInvoke("newInstance"));
        Variable transformer = xmlElementChildsNotEmpty._then().decl((Type)this.ref(Transformer.class), "transformer", (Expression)tf.invoke("newTransformer"));
        Invocation transform = transformer.invoke("transform");
        transform.arg((Expression)domSource);
        transform.arg((Expression)streamResult);
        xmlElementChildsNotEmpty._then().add((Statement)transform);
        xmlElementChildsNotEmpty._then().add((Statement)stringWriter.invoke("flush"));
        xmlElementChildsNotEmpty._then().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)stringWriter.invoke("toString")));
        this.generateReThrow(tryBlock, TransformerConfigurationException.class);
        this.generateReThrow(tryBlock, TransformerException.class);
        this.generateReThrow(tryBlock, TransformerFactoryConfigurationError.class);
    }

    private void generateReThrow(TryStatement tryBlock, Class<?> clazz) {
        CatchBlock catchBlock = tryBlock._catch(this.ref(clazz).boxify());
        Variable e = catchBlock.param("e");
        catchBlock.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(UnhandledException.class)).arg((Expression)e));
    }

    private void generateParseSupportedType(Block block, Variable element, Variable builder, String fieldName) {
        Invocation getAttribute = element.invoke("getAttribute").arg(fieldName);
        Conditional ifNotNull = block._if(Op.cand((Expression)Op.ne((Expression)getAttribute, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)getAttribute))));
        ifNotNull._then().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)element.invoke("getAttribute").arg(fieldName)));
    }

    private void generateParseEnum(Block block, Variable element, Variable builder, String fieldName) {
        Invocation hasAttribute = element.invoke("hasAttribute").arg(fieldName);
        Conditional ifNotNull = block._if((Expression)hasAttribute);
        ifNotNull._then().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)element.invoke("getAttribute").arg(fieldName)));
    }

    private UpperBlockClosure generateParseMap(Block body, TypeMirror typeMirror, Variable listElement, Variable builder, String fieldName, Variable patternInfo, Variable parserContext) {
        DeclaredType variableType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> variableTypeParameters = variableType.getTypeArguments();
        Variable listChilds = body.decl((Type)this.ref(List.class).narrow(this.ref(Element.class)), fieldName.replace("-", "") + "ListChilds", ExpressionFactory._null());
        Conditional listElementNotNull = body._if(Op.ne((Expression)listElement, (Expression)ExpressionFactory._null()));
        Invocation getElementRef = listElement.invoke("getAttribute").arg("ref");
        Variable ref = listElementNotNull._then().decl((Type)this.ref(String.class), fieldName.replace("-", "") + "Ref", (Expression)getElementRef);
        Conditional ifRef = listElementNotNull._then()._if(Op.cand((Expression)Op.ne((Expression)ref, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)ref))));
        Conditional ifRefNotExpresion = ifRef._then()._if(Op.cand((Expression)Op.not((Expression)ref.invoke("startsWith").arg((Expression)patternInfo.invoke("getPrefix"))), (Expression)Op.not((Expression)ref.invoke("endsWith").arg((Expression)patternInfo.invoke("getSuffix")))));
        ifRefNotExpresion._then().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((Expression)ref)));
        ifRefNotExpresion._else().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)ref));
        Variable managedMap = ifRef._else().decl((Type)this.ref(ManagedMap.class), fieldName.replace("-", ""), (Expression)ExpressionFactory._new((TypeReference)this.ref(ManagedMap.class)));
        ifRef._else().assign((AssignmentTarget)listChilds, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementsByTagName").arg((Expression)listElement).arg(this.context.getNameUtils().uncamel(this.context.getNameUtils().singularize(fieldName))));
        String childName = this.context.getNameUtils().uncamel(this.context.getNameUtils().singularize(fieldName));
        Conditional listChildsNotNull = ifRef._else()._if(Op.ne((Expression)listChilds, (Expression)ExpressionFactory._null()));
        Conditional isListEmpty = listChildsNotNull._then()._if(Op.eq((Expression)listChilds.invoke("size"), (Expression)ExpressionFactory.lit((int)0)));
        isListEmpty._then().assign((AssignmentTarget)listChilds, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElements").arg((Expression)listElement));
        ForEach forEach = listChildsNotNull._then().forEach((Type)this.ref(Element.class), fieldName.replace("-", "") + "Child", (Expression)listChilds);
        Invocation getValueRef = forEach.var().invoke("getAttribute").arg("value-ref");
        Invocation getKeyRef = forEach.var().invoke("getAttribute").arg("key-ref");
        Variable valueRef = forEach.body().decl((Type)this.ref(String.class), fieldName.replace("-", "") + "ValueRef", (Expression)getValueRef);
        Variable keyRef = forEach.body().decl((Type)this.ref(String.class), fieldName.replace("-", "") + "KeyRef", (Expression)getKeyRef);
        Variable valueObject = forEach.body().decl((Type)this.ref(Object.class), "valueObject", ExpressionFactory._null());
        Variable keyObject = forEach.body().decl((Type)this.ref(Object.class), "keyObject", ExpressionFactory._null());
        Conditional ifValueRef = forEach.body()._if(Op.cand((Expression)Op.ne((Expression)valueRef, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)valueRef))));
        ifValueRef._then().assign((AssignmentTarget)valueObject, (Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((Expression)valueRef));
        Block ifNotValueRef = ifValueRef._else();
        if (variableTypeParameters.size() > 1 && this.context.getTypeMirrorUtils().isArrayOrList(variableTypeParameters.get(1))) {
            UpperBlockClosure subList = this.generateParseArrayOrList(ifNotValueRef, variableTypeParameters.get(1), forEach.var(), builder, "inner-" + childName, patternInfo, parserContext);
            subList.getNotRefBlock().assign((AssignmentTarget)valueObject, (Expression)subList.getManagedCollection());
        } else if (variableTypeParameters.size() > 1 && this.context.getTypeMirrorUtils().isMap(variableTypeParameters.get(1))) {
            UpperBlockClosure subMap = this.generateParseMap(ifNotValueRef, variableTypeParameters.get(1), forEach.var(), builder, "inner-" + childName, patternInfo, parserContext);
            subMap.getNotRefBlock().assign((AssignmentTarget)valueObject, (Expression)subMap.getManagedCollection());
        } else {
            ifNotValueRef.assign((AssignmentTarget)valueObject, (Expression)forEach.var().invoke("getTextContent"));
        }
        Conditional ifKeyRef = forEach.body()._if(Op.cand((Expression)Op.ne((Expression)keyRef, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)keyRef))));
        ifKeyRef._then().assign((AssignmentTarget)keyObject, (Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((Expression)keyRef));
        ifKeyRef._else().assign((AssignmentTarget)keyObject, (Expression)forEach.var().invoke("getAttribute").arg("key"));
        Conditional noKey = forEach.body()._if(Op.cor((Expression)Op.eq((Expression)keyObject, (Expression)ExpressionFactory._null()), (Expression)Op.cand((Expression)Op._instanceof((Expression)keyObject, (Type)this.ref(String.class)), (Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)ExpressionFactory.cast((Type)this.ref(String.class), (Expression)keyObject)))));
        noKey._then().assign((AssignmentTarget)keyObject, (Expression)forEach.var().invoke("getTagName"));
        forEach.body().add((Statement)managedMap.invoke("put").arg((Expression)keyObject).arg((Expression)valueObject));
        return new UpperBlockClosure(managedMap, ifRef._else());
    }

    private UpperBlockClosure generateParseArrayOrList(Block body, TypeMirror typeMirror, Variable listElement, Variable builder, String fieldName, Variable patternInfo, Variable parserContext) {
        DeclaredType variableType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> variableTypeParameters = variableType.getTypeArguments();
        Variable listChilds = body.decl((Type)this.ref(List.class).narrow(this.ref(Element.class)), fieldName.replace("-", "") + "ListChilds", ExpressionFactory._null());
        Conditional listElementNotNull = body._if(Op.ne((Expression)listElement, (Expression)ExpressionFactory._null()));
        Invocation getElementRef = listElement.invoke("getAttribute").arg("ref");
        Variable ref = listElementNotNull._then().decl((Type)this.ref(String.class), fieldName.replace("-", "") + "Ref", (Expression)getElementRef);
        Conditional ifRef = listElementNotNull._then()._if(Op.cand((Expression)Op.ne((Expression)ref, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)ref))));
        Conditional ifRefNotExpresion = ifRef._then()._if(Op.cand((Expression)Op.not((Expression)ref.invoke("startsWith").arg((Expression)patternInfo.invoke("getPrefix"))), (Expression)Op.not((Expression)ref.invoke("endsWith").arg((Expression)patternInfo.invoke("getSuffix")))));
        ifRefNotExpresion._then().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((Expression)ref)));
        ifRefNotExpresion._else().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((Expression)ref));
        Variable managedList = ifRef._else().decl((Type)this.ref(ManagedList.class), fieldName.replace("-", ""), (Expression)ExpressionFactory._new((TypeReference)this.ref(ManagedList.class)));
        String childName = this.context.getNameUtils().uncamel(this.context.getNameUtils().singularize(fieldName));
        ifRef._else().assign((AssignmentTarget)listChilds, (Expression)this.ref(DomUtils.class).staticInvoke("getChildElementsByTagName").arg((Expression)listElement).arg(childName));
        Conditional listChildsNotNull = ifRef._else()._if(Op.ne((Expression)listChilds, (Expression)ExpressionFactory._null()));
        ForEach forEach = listChildsNotNull._then().forEach((Type)this.ref(Element.class), fieldName.replace("-", "") + "Child", (Expression)listChilds);
        Invocation getValueRef = forEach.var().invoke("getAttribute").arg("value-ref");
        Variable valueRef = forEach.body().decl((Type)this.ref(String.class), "valueRef", (Expression)getValueRef);
        Conditional ifValueRef = forEach.body()._if(Op.cand((Expression)Op.ne((Expression)valueRef, (Expression)ExpressionFactory._null()), (Expression)Op.not((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)valueRef))));
        ifValueRef._then().add((Statement)managedList.invoke("add").arg((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((Expression)valueRef)));
        if (!variableTypeParameters.isEmpty() && this.context.getTypeMirrorUtils().isArrayOrList(variableTypeParameters.get(0))) {
            UpperBlockClosure subList = this.generateParseArrayOrList(ifValueRef._else(), variableTypeParameters.get(0), forEach.var(), builder, "inner-" + childName, patternInfo, parserContext);
            subList.getNotRefBlock().add((Statement)managedList.invoke("add").arg((Expression)subList.getManagedCollection()));
        } else if (!variableTypeParameters.isEmpty() && this.context.getTypeMirrorUtils().isMap(variableTypeParameters.get(0))) {
            UpperBlockClosure subMap = this.generateParseMap(ifValueRef._else(), variableTypeParameters.get(0), forEach.var(), builder, "inner-" + childName, patternInfo, parserContext);
            subMap.getNotRefBlock().add((Statement)managedList.invoke("add").arg((Expression)subMap.getManagedCollection()));
        } else {
            ifValueRef._else().add((Statement)managedList.invoke("add").arg((Expression)forEach.var().invoke("getTextContent")));
        }
        return new UpperBlockClosure(managedList, ifRef._else());
    }

    private void generateAttachMessageSource(Method parse, Variable definition, Variable parserContext) {
        Variable propertyValues = parse.body().decl((Type)this.ref(MutablePropertyValues.class), "propertyValues", (Expression)parserContext.invoke("getContainingBeanDefinition").invoke("getPropertyValues"));
        parse.body().add((Statement)propertyValues.invoke("addPropertyValue").arg("messageSource").arg((Expression)definition));
    }

    private void generateGenerateChildBeanNameMethod(DefinedClass beanDefinitionparser) {
        Method generateChildBeanName = beanDefinitionparser.method(4, (Type)this.ref(String.class), "generateChildBeanName");
        Variable element = generateChildBeanName.param((Type)this.ref(Element.class), "element");
        Variable id = generateChildBeanName.body().decl((Type)this.ref(String.class), "id", (Expression)this.ref(SpringXMLUtils.class).staticInvoke("getNameOrId").arg((Expression)element));
        Conditional isBlank = generateChildBeanName.body()._if((Expression)this.ref(StringUtils.class).staticInvoke("isBlank").arg((Expression)id));
        Invocation getParentName = this.ref(SpringXMLUtils.class).staticInvoke("getNameOrId").arg((Expression)ExpressionFactory.cast((Type)this.ref(Element.class), (Expression)element.invoke("getParentNode")));
        Variable parentId = isBlank._then().decl((Type)this.ref(String.class), "parentId", (Expression)getParentName);
        isBlank._then()._return(Op.plus((Expression)Op.plus((Expression)Op.plus((Expression)ExpressionFactory.lit((String)"."), (Expression)parentId), (Expression)ExpressionFactory.lit((String)":")), (Expression)element.invoke("getLocalName")));
        isBlank._else()._return((Expression)id);
    }

    private class UpperBlockClosure {
        private Variable managedCollection;
        private Block notRefBlock;

        private UpperBlockClosure(Variable managedCollection, Block notRefBlock) {
            this.managedCollection = managedCollection;
            this.notRefBlock = notRefBlock;
        }

        public Variable getManagedCollection() {
            return this.managedCollection;
        }

        public void setManagedCollection(Variable managedCollection) {
            this.managedCollection = managedCollection;
        }

        public Block getNotRefBlock() {
            return this.notRefBlock;
        }

        public void setNotRefBlock(Block notRefBlock) {
            this.notRefBlock = notRefBlock;
        }
    }
}

