/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transfomer;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.mule.api.annotations.Transformer;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class TransformerGenerator
extends AbstractMessageGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return true;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Transformer.class)) {
            DefinedClass transformerClass = this.getTransformerClass(executableElement);
            Transformer transformer = executableElement.getAnnotation(Transformer.class);
            FieldVariable weighting = transformerClass.field(4, (Type)this.context.getCodeModel().INT, "weighting", Op.plus((Expression)this.ref(DiscoverableTransformer.class).staticRef("DEFAULT_PRIORITY_WEIGHTING"), (Expression)ExpressionFactory.lit((int)transformer.priorityWeighting())));
            this.generateConstructor(transformerClass, executableElement);
            this.generateDoTransform(transformerClass, executableElement);
            this.generateGetPriorityWeighting(transformerClass, weighting);
            this.generateSetPriorityWeighting(transformerClass, weighting);
            this.context.registerAtBoot(transformerClass);
        }
    }

    private void generateSetPriorityWeighting(DefinedClass jaxbTransformerClass, FieldVariable weighting) {
        Method setPriorityWeighting = jaxbTransformerClass.method(1, (Type)this.context.getCodeModel().VOID, "setPriorityWeighting");
        Variable localWeighting = setPriorityWeighting.param((Type)this.context.getCodeModel().INT, "weighting");
        setPriorityWeighting.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)weighting), (Expression)localWeighting);
    }

    private void generateGetPriorityWeighting(DefinedClass jaxbTransformerClass, FieldVariable weighting) {
        Method getPriorityWeighting = jaxbTransformerClass.method(1, (Type)this.context.getCodeModel().INT, "getPriorityWeighting");
        getPriorityWeighting.body()._return((Expression)weighting);
    }

    private void generateDoTransform(DefinedClass transformerClass, ExecutableElement executableElement) {
        Method doTransform = transformerClass.method(2, (Type)this.ref(Object.class), "doTransform");
        doTransform._throws(TransformerException.class);
        Variable src = doTransform.param((Type)this.ref(Object.class), "src");
        doTransform.param((Type)this.ref(String.class), "encoding");
        Variable result = doTransform.body().decl((Type)this.ref(executableElement.getReturnType()).boxify(), "result", ExpressionFactory._null());
        TryStatement tryBlock = doTransform.body()._try();
        Invocation invoke = this.ref(executableElement.getEnclosingElement().asType()).boxify().staticInvoke(executableElement.getSimpleName().toString());
        TypeMirror expectedType = executableElement.getParameters().get(0).asType();
        invoke.arg((Expression)ExpressionFactory.cast((Type)this.ref(expectedType), (Expression)src));
        tryBlock.body().assign((AssignmentTarget)result, (Expression)invoke);
        CatchBlock exceptionCatch = tryBlock._catch(this.ref(Exception.class));
        Variable exception = exceptionCatch.param("exception");
        this.generateThrowTransformFailedException(exceptionCatch, exception, src, this.ref(executableElement.getReturnType()).boxify());
        doTransform.body()._return((Expression)result);
    }

    private void generateThrowTransformFailedException(CatchBlock catchBlock, Variable exception, Variable src, TypeReference target) {
        Invocation transformFailedInvoke = this.ref(CoreMessages.class).staticInvoke("transformFailed");
        transformFailedInvoke.arg((Expression)src.invoke("getClass").invoke("getName"));
        transformFailedInvoke.arg(ExpressionFactory.lit((String)target.fullName()));
        Invocation transformerException = ExpressionFactory._new((TypeReference)this.ref(TransformerException.class));
        transformerException.arg((Expression)transformFailedInvoke);
        transformerException.arg(ExpressionFactory._this());
        transformerException.arg((Expression)exception);
        catchBlock.body()._throw((Expression)transformerException);
    }

    private void generateConstructor(DefinedClass transformerClass, ExecutableElement executableElement) {
        Method constructor = transformerClass.constructor(1);
        this.registerSourceTypes(constructor, executableElement);
        this.registerDestinationType(constructor, this.ref(executableElement.getReturnType()).boxify());
        constructor.body().invoke("setName").arg(this.context.getNameUtils().generateClassName(executableElement, "Transformer"));
    }

    private void registerDestinationType(Method constructor, TypeReference clazz) {
        Invocation setReturnClass = constructor.body().invoke("setReturnClass");
        setReturnClass.arg(ExpressionFactory.dotclass((TypeReference)clazz));
    }

    private void registerSourceTypes(Method constructor, ExecutableElement executableElement) {
        String transformerAnnotationName = Transformer.class.getName();
        List sourceTypes = null;
        List<? extends AnnotationMirror> annotationMirrors = executableElement.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!transformerAnnotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"sourceTypes".equals(entry.getKey().getSimpleName().toString())) continue;
                sourceTypes = (List)entry.getValue().getValue();
                continue block0;
            }
        }
        Invocation registerSourceType = constructor.body().invoke("registerSourceType");
        registerSourceType.arg((Expression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(executableElement.getParameters().get(0).asType()).boxify().dotclass()));
        if (sourceTypes != null) {
            for (AnnotationValue sourceType : sourceTypes) {
                registerSourceType = constructor.body().invoke("registerSourceType");
                registerSourceType.arg((Expression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref((TypeMirror)sourceType.getValue()).boxify().dotclass()));
            }
        }
    }

    public DefinedClass getTransformerClass(ExecutableElement executableElement) {
        String transformerClassName = this.context.getNameUtils().generateClassName(executableElement, "Transformer");
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(transformerClassName) + ".config");
        DefinedClass transformer = pkg._class(this.context.getNameUtils().getClassName(transformerClassName), AbstractTransformer.class, new Class[]{DiscoverableTransformer.class});
        return transformer;
    }
}

