/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transfomer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlType;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.Processor;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class JaxbTransformerGenerator
extends AbstractModuleGenerator {
    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return true;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        for (ExecutableElement executableElement : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            for (VariableElement variableElement : executableElement.getParameters()) {
                if (!this.context.getTypeMirrorUtils().isXmlType(variableElement.asType())) continue;
                DefinedClass jaxbTransformerClass = this.getJaxbTransformerClass(executableElement, variableElement);
                FieldVariable weighting = jaxbTransformerClass.field(4, (Type)this.context.getCodeModel().INT, "weighting", Op.plus((Expression)this.ref(DiscoverableTransformer.class).staticRef("DEFAULT_PRIORITY_WEIGHTING"), (Expression)ExpressionFactory.lit((int)1)));
                Method loadJaxbContext = this.generateLoadJaxbContext(jaxbTransformerClass);
                FieldVariable jaxbContext = jaxbTransformerClass.field(20, JAXBContext.class, "JAXB_CONTEXT", (Expression)ExpressionFactory.invoke((Method)loadJaxbContext).arg(this.ref(variableElement.asType()).boxify().dotclass()));
                this.generateConstructor(jaxbTransformerClass, variableElement);
                this.generateDoTransform(jaxbTransformerClass, jaxbContext, variableElement);
                this.generateGetPriorityWeighting(jaxbTransformerClass, weighting);
                this.generateSetPriorityWeighting(jaxbTransformerClass, weighting);
                this.context.registerAtBoot(jaxbTransformerClass);
            }
        }
    }

    private void generateSetPriorityWeighting(DefinedClass jaxbTransformerClass, FieldVariable weighting) {
        Method setPriorityWeighting = jaxbTransformerClass.method(1, (Type)this.context.getCodeModel().VOID, "setPriorityWeighting");
        Variable localWeighting = setPriorityWeighting.param((Type)this.context.getCodeModel().INT, "weighting");
        setPriorityWeighting.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)weighting), (Expression)localWeighting);
    }

    private void generateGetPriorityWeighting(DefinedClass jaxbTransformerClass, FieldVariable weighting) {
        Method getPriorityWeighting = jaxbTransformerClass.method(1, (Type)this.context.getCodeModel().INT, "getPriorityWeighting");
        getPriorityWeighting.body()._return((Expression)weighting);
    }

    private void generateDoTransform(DefinedClass jaxbTransformerClass, FieldVariable jaxbContext, VariableElement variable) {
        Method doTransform = jaxbTransformerClass.method(2, Object.class, "doTransform");
        doTransform._throws(TransformerException.class);
        Variable src = doTransform.param(Object.class, "src");
        Variable encoding = doTransform.param(String.class, "encoding");
        Variable result = doTransform.body().decl((Type)this.ref(variable.asType()).boxify(), "result", ExpressionFactory._null());
        TryStatement tryBlock = doTransform.body()._try();
        Variable unmarshaller = tryBlock.body().decl((Type)this.ref(Unmarshaller.class), "unmarshaller");
        tryBlock.body().assign((AssignmentTarget)unmarshaller, (Expression)jaxbContext.invoke("createUnmarshaller"));
        Variable inputStream = tryBlock.body().decl((Type)this.ref(InputStream.class), "is", (Expression)ExpressionFactory._new((TypeReference)this.ref(ByteArrayInputStream.class)).arg((Expression)ExpressionFactory.invoke((Expression)ExpressionFactory.cast((Type)this.ref(String.class), (Expression)src), (String)"getBytes").arg((Expression)encoding)));
        Variable streamSource = tryBlock.body().decl((Type)this.ref(StreamSource.class), "ss", (Expression)ExpressionFactory._new((TypeReference)this.ref(StreamSource.class)).arg((Expression)inputStream));
        Invocation unmarshal = unmarshaller.invoke("unmarshal");
        unmarshal.arg((Expression)streamSource);
        unmarshal.arg(ExpressionFactory.dotclass((TypeReference)this.ref(variable.asType()).boxify()));
        tryBlock.body().assign((AssignmentTarget)result, (Expression)unmarshal.invoke("getValue"));
        CatchBlock unsupportedEncodingCatch = tryBlock._catch(this.ref(UnsupportedEncodingException.class));
        Variable unsupportedEncoding = unsupportedEncodingCatch.param("unsupportedEncoding");
        this.generateThrowTransformFailedException(unsupportedEncodingCatch, unsupportedEncoding, variable);
        CatchBlock jaxbExceptionCatch = tryBlock._catch(this.ref(JAXBException.class));
        Variable jaxbException = jaxbExceptionCatch.param("jaxbException");
        this.generateThrowTransformFailedException(jaxbExceptionCatch, jaxbException, variable);
        doTransform.body()._return((Expression)result);
    }

    private void generateThrowTransformFailedException(CatchBlock catchBlock, Variable exception, VariableElement variable) {
        Invocation transformFailedInvoke = this.ref(CoreMessages.class).staticInvoke("transformFailed");
        transformFailedInvoke.arg("String");
        transformFailedInvoke.arg(ExpressionFactory.lit((String)this.ref(variable.asType()).boxify().fullName()));
        Invocation transformerException = ExpressionFactory._new((TypeReference)this.ref(TransformerException.class));
        transformerException.arg((Expression)transformFailedInvoke);
        transformerException.arg(ExpressionFactory._this());
        transformerException.arg((Expression)exception);
        catchBlock.body()._throw((Expression)transformerException);
    }

    private Method generateLoadJaxbContext(DefinedClass jaxbTransformerClass) {
        Method loadJaxbContext = jaxbTransformerClass.method(20, (Type)this.ref(JAXBContext.class), "loadJaxbContext");
        Variable clazz = loadJaxbContext.param((Type)this.ref(Class.class), "clazz");
        Variable innerJaxbContext = loadJaxbContext.body().decl((Type)this.ref(JAXBContext.class), "context");
        TryStatement tryBlock = loadJaxbContext.body()._try();
        tryBlock.body().assign((AssignmentTarget)innerJaxbContext, (Expression)this.ref(JAXBContext.class).staticInvoke("newInstance").arg((Expression)clazz));
        CatchBlock catchBlock = tryBlock._catch(this.ref(JAXBException.class));
        Variable e = catchBlock.param("e");
        catchBlock.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((Expression)e));
        loadJaxbContext.body()._return((Expression)innerJaxbContext);
        return loadJaxbContext;
    }

    private void generateConstructor(DefinedClass jaxbTransformerClass, VariableElement variable) {
        Method constructor = jaxbTransformerClass.constructor(1);
        this.registerSourceType(constructor);
        this.registerDestinationType(constructor, variable);
        DeclaredType declaredType = (DeclaredType)variable.asType();
        XmlType xmlType = declaredType.asElement().getAnnotation(XmlType.class);
        constructor.body().invoke("setName").arg(StringUtils.capitalize((String)xmlType.name()) + "JaxbTransformer");
    }

    private void registerDestinationType(Method constructor, VariableElement variable) {
        Invocation setReturnClass = constructor.body().invoke("setReturnClass");
        setReturnClass.arg(ExpressionFactory.dotclass((TypeReference)this.ref(variable.asType()).boxify()));
    }

    private void registerSourceType(Method constructor) {
        Invocation registerSourceType = constructor.body().invoke("registerSourceType");
        registerSourceType.arg((Expression)this.ref(DataTypeFactory.class).staticRef("STRING"));
    }

    private DefinedClass getJaxbTransformerClass(ExecutableElement executableElement, VariableElement variable) {
        DeclaredType declaredType = (DeclaredType)variable.asType();
        XmlType xmlType = declaredType.asElement().getAnnotation(XmlType.class);
        TypeElement parentClass = ElementFilter.typesIn(Arrays.asList(executableElement.getEnclosingElement())).get(0);
        String packageName = this.context.getNameUtils().getPackageName(this.context.getNameUtils().getBinaryName(parentClass)) + ".config";
        Package pkg = this.context.getCodeModel()._package(packageName);
        DefinedClass jaxbTransformer = pkg._class(StringUtils.capitalize((String)xmlType.name()) + "JaxbTransformer", AbstractTransformer.class, new Class[]{DiscoverableTransformer.class});
        return jaxbTransformer;
    }
}

