/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.BaseStudioXmlBuilder;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.PatternType;

public class PatternTypeBuilder
extends BaseStudioXmlBuilder {
    public PatternTypeBuilder(GeneratorContext context, ExecutableElement executableElement, DevKitTypeElement typeElement) {
        super(context, executableElement, typeElement);
    }

    public PatternType build() {
        PatternType patternType = this.createPatternType();
        if (this.executableElement.getAnnotation(Processor.class) != null) {
            List<AttributeCategory> attributeCategories = this.processMethodParameters();
            patternType.getAttributeCategoryOrRequiredSetAlternativesOrFixedAttribute().addAll(attributeCategories);
        }
        return patternType;
    }

    private PatternType createPatternType() {
        PatternType cloudConnector = new PatternType();
        cloudConnector.setLocalId(this.nameUtils.uncamel(this.executableElement.getSimpleName().toString()));
        cloudConnector.setCaption(this.helper.getFormattedCaption(this.executableElement));
        cloudConnector.setAbstract(Boolean.valueOf(true));
        if (this.executableElement.getAnnotation(Processor.class) != null) {
            cloudConnector.setExtends("http://www.mulesoft.org/schema/mule/" + this.typeElement.name() + '/' + this.helper.getGlobalRefId(this.typeElement.name()));
        } else if (this.executableElement.getAnnotation(Transformer.class) != null) {
            cloudConnector.setExtends("http://www.mulesoft.org/schema/mule/" + this.typeElement.name() + '/' + "abstractTransformer");
            cloudConnector.setDescription(this.helper.formatDescription(this.javaDocUtils.getSummary(this.executableElement)));
        }
        cloudConnector.setIcon(this.helper.getIcon(this.typeElement.name()));
        cloudConnector.setImage(this.helper.getImage(this.typeElement.name()));
        return cloudConnector;
    }
}

