/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.JAXBElement;
import org.mule.api.annotations.Configurable;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.BaseStudioXmlBuilder;
import org.mule.devkit.model.studio.AbstractElementType;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.NestedElementType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.TextType;

public class NestedsBuilder
extends BaseStudioXmlBuilder {
    public NestedsBuilder(GeneratorContext context, ExecutableElement executableElement, DevKitTypeElement typeElement) {
        super(context, executableElement, typeElement);
    }

    public NestedsBuilder(GeneratorContext context, DevKitTypeElement typeElement) {
        super(context, typeElement);
    }

    public List<JAXBElement<? extends AbstractElementType>> build() {
        ArrayList<JAXBElement<? extends AbstractElementType>> nesteds = new ArrayList<JAXBElement<? extends AbstractElementType>>();
        for (VariableElement variableElement : this.getVariableElements()) {
            if (!this.needToCreateNestedElement(variableElement)) continue;
            String localId = this.helper.getLocalId(this.executableElement, variableElement);
            NestedElementReference childElement = this.createChildElement(variableElement, localId);
            NestedElementType firstLevelNestedElement = this.createFirstLevelNestedElement(variableElement, localId);
            firstLevelNestedElement.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)childElement));
            NestedElementType secondLevelNestedElement = null;
            NestedElementType thirdLevelNestedElement = null;
            if (this.isSimpleList(variableElement)) {
                secondLevelNestedElement = this.createSecondLevelNestedElement(variableElement, childElement);
                this.handleSimpleList(variableElement, localId, secondLevelNestedElement);
            } else if (this.isSimpleMap(variableElement) || this.isListOfMaps(variableElement)) {
                secondLevelNestedElement = this.createSecondLevelNestedElement(variableElement, childElement);
                this.handleSimpleMap(variableElement, secondLevelNestedElement);
                if (this.isListOfMaps(variableElement)) {
                    childElement.setName(this.nameUtils.singularize(childElement.getName()));
                    thirdLevelNestedElement = new NestedElementType();
                    thirdLevelNestedElement.setCaption(this.helper.formatCaption(this.nameUtils.friendlyNameFromCamelCase(variableElement.getSimpleName().toString())));
                    thirdLevelNestedElement.setLocalId(this.nameUtils.singularize(localId));
                    thirdLevelNestedElement.setXmlname(this.nameUtils.uncamel(this.nameUtils.singularize(variableElement.getSimpleName().toString())));
                    thirdLevelNestedElement.setDescription(this.helper.formatDescription(this.nameUtils.friendlyNameFromCamelCase(variableElement.getSimpleName().toString())));
                    thirdLevelNestedElement.setIcon(this.helper.getIcon(this.moduleName));
                    thirdLevelNestedElement.setImage(this.helper.getImage(this.moduleName));
                    NestedElementReference childElement1 = this.createChildElement(variableElement, "inner-" + this.nameUtils.singularize(localId));
                    childElement1.setCaption(this.nameUtils.singularize(childElement1.getCaption()));
                    childElement1.setDescription(this.nameUtils.singularize(childElement1.getDescription()));
                    thirdLevelNestedElement.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)childElement1));
                }
            }
            nesteds.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNested(firstLevelNestedElement));
            nesteds.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNested(secondLevelNestedElement));
            if (thirdLevelNestedElement == null) continue;
            nesteds.add((JAXBElement<? extends AbstractElementType>)this.objectFactory.createNested(thirdLevelNestedElement));
        }
        return nesteds;
    }

    private List<? extends VariableElement> getVariableElements() {
        if (this.executableElement != null) {
            return this.executableElement.getParameters();
        }
        return this.typeElement.getFieldsAnnotatedWith(Configurable.class);
    }

    private void handleSimpleMap(VariableElement parameter, NestedElementType secondLevelNestedElement) {
        StringAttributeType attributeTypeForMapKey;
        if (((DeclaredType)parameter.asType()).getTypeArguments().isEmpty()) {
            attributeTypeForMapKey = new StringAttributeType();
        } else {
            TypeMirror typeMirror = ((DeclaredType)parameter.asType()).getTypeArguments().get(0);
            attributeTypeForMapKey = this.helper.createAttributeTypeIgnoreEnumsAndCollections(this.typeUtils.asElement(typeMirror));
            if (attributeTypeForMapKey == null) {
                attributeTypeForMapKey = new StringAttributeType();
            }
        }
        attributeTypeForMapKey.setName("key");
        attributeTypeForMapKey.setDescription(this.helper.formatDescription("Key."));
        attributeTypeForMapKey.setCaption(this.helper.formatCaption("Key"));
        secondLevelNestedElement.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)attributeTypeForMapKey));
        TextType attributeTypeForMapValues = new TextType();
        attributeTypeForMapValues.setName("value");
        attributeTypeForMapValues.setDescription(this.helper.formatDescription("Value."));
        attributeTypeForMapValues.setCaption(this.helper.formatCaption("Value"));
        attributeTypeForMapValues.setIsToElement(Boolean.valueOf(true));
        secondLevelNestedElement.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)attributeTypeForMapValues));
    }

    private void handleSimpleList(VariableElement parameter, String localId, NestedElementType secondLevelNestedElement) {
        TextType attributeTypeForListValues;
        if (((DeclaredType)parameter.asType()).getTypeArguments().isEmpty() || this.typeMirrorUtils.isString(this.typeUtils.asElement(((DeclaredType)parameter.asType()).getTypeArguments().get(0)))) {
            TextType textType = new TextType();
            textType.setIsToElement(Boolean.valueOf(true));
            attributeTypeForListValues = textType;
        } else {
            TypeMirror typeParameter = ((DeclaredType)parameter.asType()).getTypeArguments().get(0);
            attributeTypeForListValues = this.helper.createAttributeTypeIgnoreEnumsAndCollections(this.typeUtils.asElement(typeParameter));
        }
        attributeTypeForListValues.setName(this.nameUtils.singularize(localId));
        attributeTypeForListValues.setCaption(this.helper.formatCaption(this.nameUtils.friendlyNameFromCamelCase(parameter.getSimpleName().toString())));
        if (this.executableElement != null) {
            attributeTypeForListValues.setDescription(this.helper.formatDescription(this.javaDocUtils.getParameterSummary(parameter.getSimpleName().toString(), this.executableElement)));
        } else {
            attributeTypeForListValues.setDescription(this.helper.formatDescription(this.javaDocUtils.getSummary(parameter)));
        }
        secondLevelNestedElement.getRegexpOrEncodingOrString().add(this.helper.createJAXBElement((AttributeType)attributeTypeForListValues));
    }

    private NestedElementType createSecondLevelNestedElement(VariableElement parameter, NestedElementReference childElement) {
        NestedElementType nestedElement = new NestedElementType();
        nestedElement.setCaption(this.helper.formatCaption(this.nameUtils.friendlyNameFromCamelCase(parameter.getSimpleName().toString())));
        String localIdSuffix = childElement.getName().substring(childElement.getName().lastIndexOf(47) + 1);
        if (this.isListOfMaps(parameter)) {
            nestedElement.setLocalId("inner-" + this.nameUtils.singularize(localIdSuffix));
            nestedElement.setXmlname("inner-" + this.nameUtils.uncamel(this.nameUtils.singularize(parameter.getSimpleName().toString())));
        } else {
            nestedElement.setLocalId(localIdSuffix);
            nestedElement.setXmlname(this.nameUtils.uncamel(this.nameUtils.singularize(parameter.getSimpleName().toString())));
        }
        nestedElement.setDescription(this.helper.formatDescription(this.nameUtils.friendlyNameFromCamelCase(parameter.getSimpleName().toString())));
        nestedElement.setIcon(this.helper.getIcon(this.moduleName));
        nestedElement.setImage(this.helper.getImage(this.moduleName));
        return nestedElement;
    }

    private NestedElementType createFirstLevelNestedElement(VariableElement parameter, String localId) {
        NestedElementType nestedElement = new NestedElementType();
        nestedElement.setLocalId(localId);
        nestedElement.setXmlname(this.nameUtils.uncamel(parameter.getSimpleName().toString()));
        nestedElement.setCaption(this.helper.formatCaption(this.nameUtils.friendlyNameFromCamelCase(parameter.getSimpleName().toString())));
        nestedElement.setDescription(this.helper.formatDescription(this.nameUtils.friendlyNameFromCamelCase(parameter.getSimpleName().toString())));
        nestedElement.setIcon(this.helper.getIcon(this.moduleName));
        nestedElement.setImage(this.helper.getImage(this.moduleName));
        return nestedElement;
    }

    private boolean isListOfMaps(VariableElement parameter) {
        List<? extends TypeMirror> typeArguments = ((DeclaredType)parameter.asType()).getTypeArguments();
        return this.typeMirrorUtils.isArrayOrList(parameter.asType()) && !typeArguments.isEmpty() && this.typeMirrorUtils.isMap(typeArguments.get(0));
    }

    private boolean isSimpleMap(VariableElement parameter) {
        List<? extends TypeMirror> typeArguments = ((DeclaredType)parameter.asType()).getTypeArguments();
        return this.typeMirrorUtils.isMap(parameter.asType()) && (typeArguments.isEmpty() || !this.typeMirrorUtils.isCollection(typeArguments.get(1)));
    }

    private boolean isSimpleList(VariableElement parameter) {
        List<? extends TypeMirror> typeArguments = ((DeclaredType)parameter.asType()).getTypeArguments();
        return this.typeMirrorUtils.isArrayOrList(parameter.asType()) && (typeArguments.isEmpty() || !this.typeMirrorUtils.isCollection(typeArguments.get(0)));
    }

    private NestedElementReference createChildElement(VariableElement parameter, String localId) {
        NestedElementReference childElement = new NestedElementReference();
        String parameterFriendlyName = this.nameUtils.friendlyNameFromCamelCase(parameter.getSimpleName().toString());
        if (this.isListOfMaps(parameter)) {
            childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + '/' + localId);
            childElement.setDescription(this.helper.formatDescription(this.nameUtils.singularize(parameterFriendlyName)));
            childElement.setCaption(this.helper.formatCaption(this.nameUtils.singularize(parameterFriendlyName)));
        } else {
            String singularizedLocalId = this.nameUtils.singularize(localId);
            if (localId.equals(singularizedLocalId)) {
                singularizedLocalId = singularizedLocalId + "-each";
            }
            childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + '/' + singularizedLocalId);
            childElement.setDescription(this.helper.formatDescription(parameterFriendlyName));
            childElement.setCaption(this.helper.formatCaption(parameterFriendlyName));
        }
        childElement.setAllowMultiple(Boolean.valueOf(true));
        return childElement;
    }

    private boolean needToCreateNestedElement(VariableElement parameter) {
        return (this.typeMirrorUtils.isMap(parameter.asType()) || this.typeMirrorUtils.isArrayOrList(parameter.asType())) && !this.typeMirrorUtils.ignoreParameter(parameter);
    }
}

