/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.AbstractTransformerBuilder;
import org.mule.devkit.generation.mule.studio.ConfigRefBuilder;
import org.mule.devkit.generation.mule.studio.EndpointTypeBuilder;
import org.mule.devkit.generation.mule.studio.EndpointTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.GlobalCloudConnectorTypeBuilder;
import org.mule.devkit.generation.mule.studio.GlobalEndpointTypeBuilder;
import org.mule.devkit.generation.mule.studio.GlobalEndpointTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.GlobalEndpointTypeWithNameBuilder;
import org.mule.devkit.generation.mule.studio.GlobalTransformerTypeBuilder;
import org.mule.devkit.generation.mule.studio.GlobalTransformerTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.NestedsBuilder;
import org.mule.devkit.generation.mule.studio.PatternTypeBuilder;
import org.mule.devkit.generation.mule.studio.PatternTypeOperationsBuilder;
import org.mule.devkit.generation.mule.studio.PatternTypes;
import org.mule.devkit.model.studio.EndpointType;
import org.mule.devkit.model.studio.GlobalType;
import org.mule.devkit.model.studio.NamespaceType;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.PatternType;

public class MuleStudioXmlGenerator
extends AbstractMessageGenerator {
    public static final String URI_PREFIX = "http://www.mulesoft.org/schema/mule/";
    public static final String GLOBAL_CLOUD_CONNECTOR_LOCAL_ID = "config";
    public static final String ATTRIBUTE_CATEGORY_DEFAULT_CAPTION = "General";
    public static final String ATTRIBUTE_CATEGORY_DEFAULT_DESCRIPTION = "General";
    public static final String CONNECTION_ATTRIBUTE_CATEGORY_CAPTION = "Connection";
    public static final String GROUP_DEFAULT_CAPTION = "Generic";
    private ObjectFactory objectFactory = new ObjectFactory();

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.context.hasOption("skipStudioXmlGeneration");
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        String moduleName = typeElement.name();
        NamespaceType namespace = new NamespaceType();
        namespace.setPrefix(moduleName);
        namespace.setUrl(URI_PREFIX + moduleName);
        GlobalType globalCloudConnector = new GlobalCloudConnectorTypeBuilder(this.context, typeElement).build();
        namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalCloudConnector(globalCloudConnector));
        namespace.getConnectorOrEndpointOrGlobal().add(new PatternTypeOperationsBuilder(this.context, typeElement, PatternTypes.CLOUD_CONNECTOR).build());
        namespace.getConnectorOrEndpointOrGlobal().add(new ConfigRefBuilder(this.context, typeElement).build());
        namespace.getConnectorOrEndpointOrGlobal().addAll(new NestedsBuilder(this.context, typeElement).build());
        this.processProcessorMethods(typeElement, namespace);
        this.processTransformerMethods(typeElement, namespace);
        this.processSourceMethods(typeElement, namespace);
        this.context.getStudioModel().setNamespaceType(namespace);
        this.context.getStudioModel().setModuleName(moduleName);
    }

    private void processProcessorMethods(DevKitTypeElement typeElement, NamespaceType namespace) {
        for (ExecutableElement processorMethod : typeElement.getMethodsAnnotatedWith(Processor.class)) {
            PatternType cloudConnector = new PatternTypeBuilder(this.context, processorMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeCloudConnector(cloudConnector));
            namespace.getConnectorOrEndpointOrGlobal().addAll(new NestedsBuilder(this.context, processorMethod, typeElement).build());
        }
    }

    private void processTransformerMethods(DevKitTypeElement typeElement, NamespaceType namespace) {
        List<ExecutableElement> transformerMethods = typeElement.getMethodsAnnotatedWith(Transformer.class);
        if (!transformerMethods.isEmpty()) {
            namespace.getConnectorOrEndpointOrGlobal().add(new PatternTypeOperationsBuilder(this.context, typeElement, PatternTypes.TRANSFORMER).build());
            namespace.getConnectorOrEndpointOrGlobal().add(new AbstractTransformerBuilder(this.context, typeElement).build());
            GlobalType globalTransformer = new GlobalTransformerTypeOperationsBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalTransformer(globalTransformer));
        }
        for (ExecutableElement transformerMethod : transformerMethods) {
            PatternType transformer = new PatternTypeBuilder(this.context, transformerMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeTransformer(transformer));
            GlobalType globalTransformer = new GlobalTransformerTypeBuilder(this.context, transformerMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalTransformer(globalTransformer));
            namespace.getConnectorOrEndpointOrGlobal().addAll(new NestedsBuilder(this.context, transformerMethod, typeElement).build());
        }
    }

    private void processSourceMethods(DevKitTypeElement typeElement, NamespaceType namespace) {
        List<ExecutableElement> sourceMethods = typeElement.getMethodsAnnotatedWith(Source.class);
        if (!sourceMethods.isEmpty()) {
            GlobalType abstractGlobalEndpoint = new GlobalEndpointTypeWithNameBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalEndpoint(abstractGlobalEndpoint));
            EndpointType endpointTypeListingOps = new EndpointTypeOperationsBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createEndpoint(endpointTypeListingOps));
            GlobalType globalEndpointListingOps = new GlobalEndpointTypeOperationsBuilder(this.context, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalEndpoint(globalEndpointListingOps));
        }
        for (ExecutableElement sourceMethod : sourceMethods) {
            EndpointType endpoint = new EndpointTypeBuilder(this.context, sourceMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createEndpoint(endpoint));
            GlobalType globalEndpoint = new GlobalEndpointTypeBuilder(this.context, sourceMethod, typeElement).build();
            namespace.getConnectorOrEndpointOrGlobal().add(this.objectFactory.createNamespaceTypeGlobalEndpoint(globalEndpoint));
            namespace.getConnectorOrEndpointOrGlobal().addAll(new NestedsBuilder(this.context, sourceMethod, typeElement).build());
        }
    }
}

