/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.WordUtils;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.studio.Display;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.spring.SchemaTypeConversion;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.Booleantype;
import org.mule.devkit.model.studio.EncodingType;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.FlowRefType;
import org.mule.devkit.model.studio.IntegerType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.model.studio.PasswordType;
import org.mule.devkit.model.studio.StringAttributeType;
import org.mule.devkit.model.studio.TextType;
import org.mule.devkit.model.studio.UrlType;
import org.mule.devkit.utils.JavaDocUtils;
import org.mule.devkit.utils.NameUtils;
import org.mule.devkit.utils.TypeMirrorUtils;
import org.mule.util.StringUtils;

public class MuleStudioUtils {
    private static final String IMAGE = "icons/large/%s-connector-48x32.png";
    private static final String ICON = "icons/small/%s-connector-24x16.png";
    private NameUtils nameUtils;
    private JavaDocUtils javaDocUtils;
    private TypeMirrorUtils typeMirrorUtils;

    public MuleStudioUtils(GeneratorContext context) {
        this.nameUtils = context.getNameUtils();
        this.javaDocUtils = context.getJavaDocUtils();
        this.typeMirrorUtils = context.getTypeMirrorUtils();
    }

    public String formatCaption(String caption) {
        return WordUtils.capitalizeFully((String)caption);
    }

    public String formatDescription(String description) {
        if (Character.isLowerCase(description.charAt(0))) {
            description = StringUtils.capitalize((String)description);
        }
        if (!description.endsWith(".")) {
            description = description + '.';
        }
        return description.replaceAll("\\<.*?\\>", "");
    }

    public String getImage(String moduleName) {
        return String.format(IMAGE, moduleName);
    }

    public String getIcon(String moduleName) {
        return String.format(ICON, moduleName);
    }

    public String getGlobalRefId(String moduleName) {
        return "abstract" + StringUtils.capitalize((String)moduleName) + "ConnectorGeneric";
    }

    public List<JAXBElement<? extends AttributeType>> createJAXBElements(List<AttributeType> attributeTypes) {
        ArrayList<JAXBElement<? extends AttributeType>> jaxbElements = new ArrayList<JAXBElement<? extends AttributeType>>();
        for (AttributeType attributeType : attributeTypes) {
            JAXBElement<? extends AttributeType> jaxbElement = this.createJAXBElement(attributeType);
            if (jaxbElement == null) continue;
            jaxbElements.add(jaxbElement);
        }
        return jaxbElements;
    }

    public JAXBElement<? extends AttributeType> createJAXBElement(AttributeType attributeType) {
        ObjectFactory objectFactory = new ObjectFactory();
        if (attributeType instanceof PasswordType) {
            return objectFactory.createGroupPassword((PasswordType)attributeType);
        }
        if (attributeType instanceof StringAttributeType) {
            return objectFactory.createGroupString((StringAttributeType)attributeType);
        }
        if (attributeType instanceof IntegerType) {
            return objectFactory.createGroupInteger((IntegerType)attributeType);
        }
        if (attributeType instanceof EnumType) {
            return objectFactory.createGroupEnum((EnumType)attributeType);
        }
        if (attributeType instanceof Booleantype) {
            return objectFactory.createGroupBoolean((Booleantype)attributeType);
        }
        if (attributeType instanceof TextType) {
            return objectFactory.createGroupText((TextType)attributeType);
        }
        if (attributeType instanceof FlowRefType) {
            return objectFactory.createGroupFlowRef((FlowRefType)attributeType);
        }
        if (attributeType instanceof UrlType) {
            return objectFactory.createGroupUrl((UrlType)attributeType);
        }
        if (attributeType instanceof EncodingType) {
            return objectFactory.createGroupEncoding((EncodingType)attributeType);
        }
        if (attributeType instanceof NestedElementReference) {
            return objectFactory.createNestedElementTypeChildElement((NestedElementReference)attributeType);
        }
        return null;
    }

    public AttributeType createAttributeTypeIgnoreEnumsAndCollections(Element element) {
        if (this.skipAttributeTypeGeneration(element)) {
            return null;
        }
        if (SchemaTypeConversion.isSupported(((Object)element.asType()).toString())) {
            return this.createAttributeTypeOfSupportedType(element);
        }
        if (this.typeMirrorUtils.isHttpCallback(element)) {
            FlowRefType flowRefType = new FlowRefType();
            flowRefType.setSupportFlow(Boolean.valueOf(true));
            flowRefType.setSupportSubflow(Boolean.valueOf(true));
            return flowRefType;
        }
        return new StringAttributeType();
    }

    private boolean skipAttributeTypeGeneration(Element element) {
        return this.typeMirrorUtils.isCollection(element.asType()) || this.typeMirrorUtils.isEnum(element.asType()) || this.typeMirrorUtils.ignoreParameter(element);
    }

    private AttributeType createAttributeTypeOfSupportedType(Element element) {
        Display display = element.getAnnotation(Display.class);
        if (display != null && display.type().equals((Object)Display.Type.PASSWORD)) {
            return new PasswordType();
        }
        if (this.typeMirrorUtils.isString(element) || this.typeMirrorUtils.isDate(element) || this.typeMirrorUtils.isChar(element) || this.typeMirrorUtils.isFloat(element) || this.typeMirrorUtils.isDouble(element)) {
            return new StringAttributeType();
        }
        if (this.typeMirrorUtils.isBoolean(element)) {
            return new Booleantype();
        }
        if (this.typeMirrorUtils.isInteger(element) || this.typeMirrorUtils.isLong(element)) {
            IntegerType integerType = new IntegerType();
            integerType.setMin(0);
            integerType.setStep(1);
            return integerType;
        }
        if (this.typeMirrorUtils.isURL(element)) {
            return new UrlType();
        }
        throw new RuntimeException("Failed to create Studio XML, type not recognized: type=" + ((Object)element.asType()).toString() + " name=" + element.getSimpleName().toString());
    }

    public void setAttributeTypeInfo(VariableElement variableElement, AttributeType attributeType) {
        String parameterName = variableElement.getSimpleName().toString();
        attributeType.setCaption(this.getFormattedCaption(variableElement));
        attributeType.setDescription(this.getFormattedDescription(variableElement));
        if (attributeType instanceof StringAttributeType && !SchemaTypeConversion.isSupported(((Object)variableElement.asType()).toString())) {
            attributeType.setName(parameterName + "-ref");
        } else if (attributeType instanceof FlowRefType) {
            attributeType.setName(this.nameUtils.uncamel(parameterName) + "-flow-ref");
        } else {
            attributeType.setName(parameterName);
        }
        attributeType.setRequired(Boolean.valueOf(variableElement.getAnnotation(Optional.class) == null));
        this.setDefaultValueIfAvailable(variableElement, attributeType);
    }

    public void setDefaultValueIfAvailable(VariableElement variableElement, AttributeType parameter) {
        Default annotation = variableElement.getAnnotation(Default.class);
        if (annotation != null) {
            if (parameter instanceof Booleantype) {
                ((Booleantype)parameter).setDefaultValue(Boolean.valueOf(annotation.value()));
            } else if (parameter instanceof IntegerType) {
                ((IntegerType)parameter).setDefaultValue(Integer.valueOf(annotation.value()));
            } else if (parameter instanceof StringAttributeType) {
                ((StringAttributeType)parameter).setDefaultValue(annotation.value());
            } else if (parameter instanceof EnumType) {
                ((EnumType)parameter).setDefaultValue(annotation.value());
            }
        }
    }

    public String getLocalId(ExecutableElement executableElement, VariableElement variableElement) {
        if (executableElement != null) {
            return this.nameUtils.uncamel(executableElement.getSimpleName().toString()) + '-' + this.nameUtils.uncamel(variableElement.getSimpleName().toString());
        }
        return "configurable-" + this.nameUtils.uncamel(variableElement.getSimpleName().toString());
    }

    public String getFormattedDescription(Element element) {
        Display display = element.getAnnotation(Display.class);
        if (display != null && StringUtils.isNotBlank((String)display.description())) {
            return this.formatDescription(display.description());
        }
        if (element instanceof VariableElement && element.getKind() == ElementKind.PARAMETER) {
            Element executableElement = element.getEnclosingElement();
            return this.formatDescription(this.javaDocUtils.getParameterSummary(element.getSimpleName().toString(), executableElement));
        }
        return this.formatDescription(this.javaDocUtils.getSummary(element));
    }

    public String getFormattedCaption(Element element) {
        Display display = element.getAnnotation(Display.class);
        if (display != null && StringUtils.isNotBlank((String)display.caption())) {
            return display.caption();
        }
        if (element instanceof DevKitTypeElement) {
            return this.formatCaption(((DevKitTypeElement)element).name().replaceAll("-", " "));
        }
        return this.formatCaption(this.nameUtils.friendlyNameFromCamelCase(element.getSimpleName().toString()));
    }
}

