/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.studio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Types;
import javax.xml.bind.JAXBElement;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.Transformer;
import org.mule.api.annotations.studio.Display;
import org.mule.devkit.GeneratorContext;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.mule.studio.GroupComparator;
import org.mule.devkit.generation.mule.studio.MuleStudioUtils;
import org.mule.devkit.generation.mule.studio.VariableComparator;
import org.mule.devkit.model.studio.AttributeCategory;
import org.mule.devkit.model.studio.AttributeType;
import org.mule.devkit.model.studio.EnumElement;
import org.mule.devkit.model.studio.EnumType;
import org.mule.devkit.model.studio.Group;
import org.mule.devkit.model.studio.ModeElementType;
import org.mule.devkit.model.studio.ModeType;
import org.mule.devkit.model.studio.NestedElementReference;
import org.mule.devkit.model.studio.ObjectFactory;
import org.mule.devkit.utils.JavaDocUtils;
import org.mule.devkit.utils.NameUtils;
import org.mule.devkit.utils.TypeMirrorUtils;
import org.mule.util.StringUtils;

public abstract class BaseStudioXmlBuilder {
    public static final String GENERAL_GROUP_NAME = "General";
    private static final String CONNECTION_GROUP_NAME = "Connection";
    private static final String CONNECTION_GROUP_LABEL = "Use these fields to override the credentials defined in the %s connector.";
    protected ObjectFactory objectFactory;
    protected MuleStudioUtils helper;
    protected DevKitTypeElement typeElement;
    protected ExecutableElement executableElement;
    protected NameUtils nameUtils;
    protected JavaDocUtils javaDocUtils;
    protected TypeMirrorUtils typeMirrorUtils;
    protected Types typeUtils;
    protected String moduleName;
    protected GeneratorContext context;

    protected BaseStudioXmlBuilder(GeneratorContext context) {
        this.context = context;
        this.nameUtils = context.getNameUtils();
        this.javaDocUtils = context.getJavaDocUtils();
        this.typeMirrorUtils = context.getTypeMirrorUtils();
        this.typeUtils = context.getTypeUtils();
        this.helper = new MuleStudioUtils(context);
        this.objectFactory = new ObjectFactory();
    }

    protected BaseStudioXmlBuilder(GeneratorContext context, DevKitTypeElement typeElement) {
        this(context);
        this.typeElement = typeElement;
        this.moduleName = typeElement.name();
    }

    protected Group createGroupWithModeSwitch(List<ExecutableElement> methods) {
        ArrayList<ModeElementType> modes = new ArrayList<ModeElementType>();
        for (ExecutableElement method : methods) {
            ModeElementType mode = new ModeElementType();
            String methodName = method.getSimpleName().toString();
            mode.setModeId("http://www.mulesoft.org/schema/mule/" + this.typeElement.name() + '/' + this.nameUtils.uncamel(methodName));
            mode.setModeLabel(this.nameUtils.friendlyNameFromCamelCase(methodName));
            modes.add(mode);
        }
        ModeType modeSwitch = new ModeType();
        modeSwitch.getMode().addAll(modes);
        modeSwitch.setCaption(this.helper.formatCaption("Operation"));
        modeSwitch.setName(StringUtils.capitalize((String)this.moduleName) + " operations to execute");
        modeSwitch.setDescription(this.helper.formatDescription("Operation"));
        Group group = new Group();
        group.setId(this.typeElement.name() + "ConnectorGeneric");
        group.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupModeSwitch(modeSwitch));
        group.setCaption(this.helper.formatCaption("Generic"));
        return group;
    }

    protected BaseStudioXmlBuilder(GeneratorContext context, ExecutableElement executableElement, DevKitTypeElement typeElement) {
        this(context, typeElement);
        this.executableElement = executableElement;
    }

    protected List<AttributeCategory> processMethodParameters() {
        return this.processVariableElements(this.getParametersSorted());
    }

    protected List<AttributeCategory> processConfigurableFields(Group defaultGroup) {
        List<AttributeCategory> attributeCategories = this.processVariableElements(this.getConfigurableFieldsSorted());
        for (AttributeCategory attributeCategory : attributeCategories) {
            if (!attributeCategory.getCaption().equals(GENERAL_GROUP_NAME)) continue;
            attributeCategory.setCaption(this.helper.getFormattedCaption(this.typeElement));
            attributeCategory.setDescription(this.helper.formatDescription(this.typeElement.name() + " configuration properties"));
            List groups = attributeCategory.getGroup();
            if (groups.isEmpty()) {
                groups.add(defaultGroup);
                continue;
            }
            groups.add(0, defaultGroup);
        }
        if (attributeCategories.isEmpty()) {
            AttributeCategory attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.getFormattedCaption(this.typeElement));
            attributeCategory.setDescription(this.helper.formatDescription(this.typeElement.name() + " configuration properties"));
            attributeCategory.getGroup().add(defaultGroup);
            attributeCategories.add(attributeCategory);
        }
        return attributeCategories;
    }

    private List<AttributeCategory> processVariableElements(List<? extends VariableElement> variableElements) {
        LinkedHashMap<String, Group> groupsByName = new LinkedHashMap<String, Group>();
        LinkedHashMap<String, AttributeCategory> attributeCategoriesByName = new LinkedHashMap<String, AttributeCategory>();
        this.getOrCreateDefaultAttributeCategory(attributeCategoriesByName);
        if (this.typeElement.usesConnectionManager() && (this.executableElement == null || this.executableElement.getAnnotation(Transformer.class) == null)) {
            Group connectionAttributesGroup = new Group();
            connectionAttributesGroup.setCaption(this.helper.formatCaption(CONNECTION_GROUP_NAME));
            connectionAttributesGroup.setId(StringUtils.uncapitalize((String)CONNECTION_GROUP_NAME));
            AttributeType attributeType = new AttributeType();
            attributeType.setCaption(String.format(CONNECTION_GROUP_LABEL, this.helper.getFormattedCaption(this.typeElement)));
            AttributeType newLine = new AttributeType();
            newLine.setCaption("");
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupLabel(attributeType));
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().add(this.objectFactory.createGroupLabel(newLine));
            groupsByName.put(CONNECTION_GROUP_NAME, connectionAttributesGroup);
            List<AttributeType> connectionAttributes = this.getConnectionAttributes(this.typeElement);
            connectionAttributesGroup.getRegexpOrEncodingOrModeSwitch().addAll(this.helper.createJAXBElements(connectionAttributes));
            AttributeCategory connectionAttributeCategory = new AttributeCategory();
            connectionAttributeCategory.setCaption(this.helper.formatCaption(CONNECTION_GROUP_NAME));
            connectionAttributeCategory.setDescription(this.helper.formatDescription(CONNECTION_GROUP_NAME));
            attributeCategoriesByName.put(CONNECTION_GROUP_NAME, connectionAttributeCategory);
            connectionAttributeCategory.getGroup().add(connectionAttributesGroup);
        }
        for (VariableElement variableElement : variableElements) {
            JAXBElement<? extends AttributeType> jaxbElement = this.createJaxbElement(variableElement);
            AttributeCategory attributeCategory = this.getOrCreateAttributeCategory(attributeCategoriesByName, variableElement.getAnnotation(Display.class));
            Group group = this.getOrCreateGroup(groupsByName, variableElement);
            group.getRegexpOrEncodingOrModeSwitch().add(jaxbElement);
            if (attributeCategory.getGroup().contains(group)) continue;
            attributeCategory.getGroup().add(group);
        }
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>(attributeCategoriesByName.values());
        for (AttributeCategory attributeCategory : attributeCategories) {
            Collections.sort(attributeCategory.getGroup(), new GroupComparator());
        }
        return attributeCategories;
    }

    private AttributeCategory getOrCreateDefaultAttributeCategory(Map<String, AttributeCategory> attributeCategoriesByName) {
        return this.getOrCreateAttributeCategory(attributeCategoriesByName, null);
    }

    private AttributeCategory getOrCreateAttributeCategory(Map<String, AttributeCategory> attributeCategoriesByName, Display display) {
        if (display == null || StringUtils.isBlank((String)display.tab())) {
            if (!attributeCategoriesByName.containsKey(GENERAL_GROUP_NAME)) {
                AttributeCategory attributeCategoryGeneral = new AttributeCategory();
                attributeCategoryGeneral.setCaption(this.helper.formatCaption(GENERAL_GROUP_NAME));
                attributeCategoryGeneral.setDescription(this.helper.formatDescription(GENERAL_GROUP_NAME));
                attributeCategoriesByName.put(GENERAL_GROUP_NAME, attributeCategoryGeneral);
            }
            return attributeCategoriesByName.get(GENERAL_GROUP_NAME);
        }
        String attributeCategoryName = StringUtils.isNotBlank((String)display.tab()) ? display.tab() : GENERAL_GROUP_NAME;
        if (!attributeCategoriesByName.containsKey(attributeCategoryName)) {
            AttributeCategory attributeCategory = new AttributeCategory();
            attributeCategory.setCaption(this.helper.formatCaption(attributeCategoryName));
            attributeCategory.setDescription(this.helper.formatDescription(attributeCategoryName));
            attributeCategoriesByName.put(attributeCategoryName, attributeCategory);
        }
        return attributeCategoriesByName.get(attributeCategoryName);
    }

    private Group getOrCreateGroup(Map<String, Group> groupsByName, VariableElement parameter) {
        Display display = parameter.getAnnotation(Display.class);
        if (display == null || StringUtils.isBlank((String)display.inputGroup())) {
            if (!groupsByName.containsKey(GENERAL_GROUP_NAME)) {
                Group groupGeneral = new Group();
                groupGeneral.setCaption(this.helper.formatCaption(GENERAL_GROUP_NAME));
                groupGeneral.setId(StringUtils.uncapitalize((String)GENERAL_GROUP_NAME));
                groupsByName.put(GENERAL_GROUP_NAME, groupGeneral);
            }
            return groupsByName.get(GENERAL_GROUP_NAME);
        }
        String groupName = display.inputGroup();
        if (!groupsByName.containsKey(groupName)) {
            Group group = new Group();
            group.setCaption(groupName);
            group.setId(StringUtils.uncapitalize((String)groupName));
            groupsByName.put(groupName, group);
        }
        return groupsByName.get(groupName);
    }

    private JAXBElement<? extends AttributeType> createJaxbElement(VariableElement parameter) {
        JAXBElement jaxbElement;
        if (this.typeMirrorUtils.isEnum(parameter)) {
            EnumType enumType = this.createEnumType(parameter);
            jaxbElement = this.helper.createJAXBElement((AttributeType)enumType);
        } else if (this.typeMirrorUtils.isCollection(parameter)) {
            NestedElementReference childElement = this.createNestedElementReference(this.executableElement, parameter);
            jaxbElement = this.objectFactory.createGroupChildElement(childElement);
        } else {
            AttributeType attributeType = this.createAttributeType(parameter);
            jaxbElement = this.helper.createJAXBElement(attributeType);
        }
        return jaxbElement;
    }

    private List<? extends VariableElement> getParametersSorted() {
        ArrayList<? extends VariableElement> parameters = new ArrayList<VariableElement>(this.executableElement.getParameters());
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            if (!this.typeMirrorUtils.ignoreParameter((Element)iterator.next())) continue;
            iterator.remove();
        }
        Collections.sort(parameters, new VariableComparator(this.typeMirrorUtils));
        return parameters;
    }

    private AttributeType createAttributeType(VariableElement parameter) {
        AttributeType attributeType = this.helper.createAttributeTypeIgnoreEnumsAndCollections(parameter);
        if (attributeType != null) {
            this.helper.setAttributeTypeInfo(parameter, attributeType);
        }
        return attributeType;
    }

    private List<AttributeType> getConnectionAttributes(DevKitTypeElement typeElement) {
        ArrayList<AttributeType> parameters = new ArrayList<AttributeType>();
        ExecutableElement connectMethod = typeElement.getMethodsAnnotatedWith(Connect.class).get(0);
        for (VariableElement variableElement : connectMethod.getParameters()) {
            AttributeType parameter = this.helper.createAttributeTypeIgnoreEnumsAndCollections(variableElement);
            this.helper.setAttributeTypeInfo(variableElement, parameter);
            parameter.setRequired(Boolean.valueOf(false));
            parameters.add(parameter);
        }
        return parameters;
    }

    private NestedElementReference createNestedElementReference(ExecutableElement executableElement, VariableElement parameter) {
        String prefix;
        NestedElementReference childElement = new NestedElementReference();
        if (executableElement != null) {
            prefix = this.nameUtils.uncamel(executableElement.getSimpleName().toString());
            childElement.setDescription(this.helper.formatDescription(this.javaDocUtils.getParameterSummary(parameter.getSimpleName().toString(), executableElement)));
        } else {
            prefix = "configurable";
            childElement.setDescription(this.helper.formatDescription(this.javaDocUtils.getSummary(parameter)));
        }
        childElement.setName("http://www.mulesoft.org/schema/mule/" + this.moduleName + '/' + prefix + '-' + this.nameUtils.uncamel(parameter.getSimpleName().toString()));
        childElement.setAllowMultiple(Boolean.valueOf(false));
        childElement.setCaption(this.helper.getFormattedCaption(parameter));
        childElement.setInplace(Boolean.valueOf(true));
        return childElement;
    }

    private EnumType createEnumType(VariableElement parameter) {
        EnumType enumType = new EnumType();
        enumType.setSupportsExpressions(Boolean.valueOf(true));
        enumType.setAllowsCustom(Boolean.valueOf(true));
        this.helper.setAttributeTypeInfo(parameter, (AttributeType)enumType);
        for (Element element : this.typeUtils.asElement(parameter.asType()).getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            String enumConstant = element.getSimpleName().toString();
            EnumElement enumElement = new EnumElement();
            enumElement.setCaption(this.helper.formatCaption(this.javaDocUtils.getSummary(element)));
            enumElement.setValue(enumConstant);
            enumType.getOption().add(enumElement);
        }
        return enumType;
    }

    private List<VariableElement> getConfigurableFieldsSorted() {
        List<VariableElement> configurableFields = this.typeElement.getFieldsAnnotatedWith(Configurable.class);
        Collections.sort(configurableFields, new VariableComparator(this.typeMirrorUtils));
        return configurableFields;
    }
}

