/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.oauth;

import javax.lang.model.element.TypeElement;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.oauth.SaveAccessTokenCallback;
import org.mule.devkit.generation.AbstractMessageGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.Conditional;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.Variable;

public class DefaultSaveAccessTokenCallbackGenerator
extends AbstractMessageGenerator {
    public static final String ROLE = "DefaultSaveAccessTokenCallback";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasAnnotation(OAuth.class) || typeElement.hasAnnotation(OAuth2.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass callbackClass = this.getDefaultSaveAccessTokenCallbackClass(typeElement);
        FieldVariable messageProcessor = this.generateFieldForMessageProcessor(callbackClass, "messageProcessor");
        FieldVariable logger = this.generateLoggerField(callbackClass);
        FieldVariable hasBeenStarted = this.generateFieldForBoolean(callbackClass, "hasBeenStarted");
        FieldVariable hasBeenInitialized = this.generateFieldForBoolean(callbackClass, "hasBeenInitialized");
        Method constructor = callbackClass.constructor(1);
        constructor.body().assign((AssignmentTarget)hasBeenStarted, ExpressionFactory.FALSE);
        constructor.body().assign((AssignmentTarget)hasBeenInitialized, ExpressionFactory.FALSE);
        this.generateGetter(callbackClass, messageProcessor);
        this.generateSetter(callbackClass, messageProcessor);
        Method saveAccessTokenMethod = callbackClass.method(1, (Type)this.context.getCodeModel().VOID, "saveAccessToken");
        Variable accessToken = saveAccessTokenMethod.param((Type)this.ref(String.class), "accessToken");
        Variable accessTokenSecret = saveAccessTokenMethod.param((Type)this.ref(String.class), "accessTokenSecret");
        Variable event = saveAccessTokenMethod.body().decl((Type)this.ref(MuleEvent.class), "event", (Expression)this.ref(RequestContext.class).staticInvoke("getEvent"));
        saveAccessTokenMethod.body().add((Statement)event.invoke("getMessage").invoke("setInvocationProperty").arg("OAuthAccessToken").arg((Expression)accessToken));
        saveAccessTokenMethod.body().add((Statement)event.invoke("getMessage").invoke("setInvocationProperty").arg("OAuthAccessTokenSecret").arg((Expression)accessTokenSecret));
        Conditional ifMuleContextAware = saveAccessTokenMethod.body()._if(Op._instanceof((Expression)messageProcessor, (Type)this.ref(MuleContextAware.class)));
        ifMuleContextAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (Expression)messageProcessor).invoke("setMuleContext").arg((Expression)this.ref(RequestContext.class).staticInvoke("getEventContext").invoke("getMuleContext")));
        Conditional ifFlowConstructAware = saveAccessTokenMethod.body()._if(Op._instanceof((Expression)messageProcessor, (Type)this.ref(FlowConstructAware.class)));
        ifFlowConstructAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(FlowConstructAware.class), (Expression)messageProcessor).invoke("setFlowConstruct").arg((Expression)this.ref(RequestContext.class).staticInvoke("getEventContext").invoke("getFlowConstruct")));
        Conditional ifNotInitialized = saveAccessTokenMethod.body()._if(Op.not((Expression)hasBeenInitialized));
        Conditional ifInitialisable = ifNotInitialized._then()._if(Op._instanceof((Expression)messageProcessor, (Type)this.ref(Initialisable.class)));
        TryStatement tryToInitialize = ifInitialisable._then()._try();
        tryToInitialize.body().add((Statement)ExpressionFactory.cast((Type)this.ref(Initialisable.class), (Expression)messageProcessor).invoke("initialise"));
        CatchBlock catchInitlize = tryToInitialize._catch(this.ref(Exception.class));
        Variable exception = catchInitlize.param("e");
        catchInitlize.body().add((Statement)logger.invoke("error").arg((Expression)exception.invoke("getMessage")).arg((Expression)exception));
        ifNotInitialized._then().assign((AssignmentTarget)hasBeenInitialized, ExpressionFactory.TRUE);
        Conditional ifNotStarted = saveAccessTokenMethod.body()._if(Op.not((Expression)hasBeenStarted));
        Conditional ifStartable = ifNotStarted._then()._if(Op._instanceof((Expression)messageProcessor, (Type)this.ref(Startable.class)));
        TryStatement tryToStart = ifStartable._then()._try();
        tryToStart.body().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (Expression)messageProcessor).invoke("start"));
        CatchBlock catchStart = tryToStart._catch(this.ref(Exception.class));
        exception = catchStart.param("e");
        catchStart.body().add((Statement)logger.invoke("error").arg((Expression)exception.invoke("getMessage")).arg((Expression)exception));
        ifNotStarted._then().assign((AssignmentTarget)hasBeenStarted, ExpressionFactory.TRUE);
        TryStatement tryProcess = saveAccessTokenMethod.body()._try();
        tryProcess.body().add((Statement)messageProcessor.invoke("process").arg((Expression)event));
        CatchBlock catchProcess = tryProcess._catch(this.ref(Exception.class));
        exception = catchProcess.param("e");
        catchProcess.body().add((Statement)logger.invoke("error").arg((Expression)exception.invoke("getMessage")).arg((Expression)exception));
    }

    private DefinedClass getDefaultSaveAccessTokenCallbackClass(TypeElement type) {
        String callbackClassName = this.context.getNameUtils().generateClassNameInPackage(type, ".config", ROLE);
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(callbackClassName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(callbackClassName), new Class[]{SaveAccessTokenCallback.class});
        this.context.setClassRole(ROLE, clazz);
        return clazz;
    }
}

