/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.util.IOUtils;

public class RegistryBootstrapGenerator
extends AbstractModuleGenerator {
    private boolean executed;

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return !this.executed;
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        OutputStreamWriter registryBootstrapStreamOut = null;
        try {
            OutputStream registryBootstrapStream = this.context.getCodeModel().getCodeWriter().openBinary(null, "META-INF/services/org/mule/config/registry-bootstrap.properties");
            registryBootstrapStreamOut = new OutputStreamWriter(registryBootstrapStream, "UTF-8");
            for (DefinedClass clazz : this.context.getRegisterAtBoot()) {
                registryBootstrapStreamOut.write(clazz.name() + "=" + clazz.fullName() + "\n");
            }
            registryBootstrapStreamOut.flush();
            this.executed = true;
        }
        catch (IOException ioe) {
            try {
                throw new GenerationException(ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(registryBootstrapStreamOut);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)registryBootstrapStreamOut);
    }
}

