/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.Map;
import javax.lang.model.element.TypeElement;
import org.mule.api.NestedProcessor;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.generation.GenerationException;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.Variable;

public class NestedProcessorStringGenerator
extends AbstractModuleGenerator {
    public static final String ROLE = "NestedProcessorString";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasProcessorMethodWithParameter(NestedProcessor.class) || typeElement.hasProcessorMethodWithParameterListOf(NestedProcessor.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) throws GenerationException {
        DefinedClass callbackClass = this.getNestedProcessorStringClass(typeElement);
        callbackClass._implements(this.ref(NestedProcessor.class));
        FieldVariable output = callbackClass.field(4, (Type)this.ref(String.class), "output");
        output.javadoc().add((Object)"Output string to be returned on process");
        this.generateSetter(callbackClass, output);
        this.generateCallbackConstructor(callbackClass, output);
        this.generateCallbackProcess(callbackClass, output);
        this.generateCallbackProcessWithPayload(callbackClass, output);
        this.generateCallbackProcessWithProperties(callbackClass, output);
        this.generateCallbackProcessWithPayloadAndProperties(callbackClass, output);
        this.context.setClassRole(ROLE, callbackClass);
    }

    private void generateCallbackProcessWithPayload(DefinedClass callbackClass, FieldVariable output) {
        Method process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        process.param((Type)this.ref(Object.class), "payload");
        process.body()._return((Expression)output);
    }

    private void generateCallbackProcessWithPayloadAndProperties(DefinedClass callbackClass, FieldVariable output) {
        Method process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        process.param((Type)this.ref(Object.class), "payload");
        process.param((Type)this.ref(Map.class).narrow(this.ref(String.class)).narrow(this.ref(Object.class)), "properties");
        process.body()._return((Expression)output);
    }

    private void generateCallbackProcessWithProperties(DefinedClass callbackClass, FieldVariable output) {
        Method process = callbackClass.method(1, (Type)this.ref(Object.class), "processWithExtraProperties");
        process._throws(this.ref(Exception.class));
        process.param((Type)this.ref(Map.class).narrow(this.ref(String.class)).narrow(this.ref(Object.class)), "properties");
        process.body()._return((Expression)output);
    }

    private void generateCallbackProcess(DefinedClass callbackClass, FieldVariable output) {
        Method process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        process.body()._return((Expression)output);
    }

    private void generateCallbackConstructor(DefinedClass callbackClass, FieldVariable output) {
        Method constructor = callbackClass.constructor(1);
        Variable output2 = constructor.param((Type)this.ref(String.class), "output");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)output), (Expression)output2);
    }

    private DefinedClass getNestedProcessorStringClass(TypeElement type) {
        String processorCallbackClassName = this.context.getNameUtils().generateClassNameInPackage(type, ".config.spring", ROLE);
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(processorCallbackClassName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(processorCallbackClassName));
        this.context.setClassRole(ROLE, clazz);
        return clazz;
    }
}

