/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.Map;
import javax.lang.model.element.TypeElement;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.generation.AbstractModuleGenerator;
import org.mule.devkit.generation.DevKitTypeElement;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.ForEach;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;

public class NestedProcessorChainGenerator
extends AbstractModuleGenerator {
    public static final String ROLE = "NestedProcessorChain";

    @Override
    protected boolean shouldGenerate(DevKitTypeElement typeElement) {
        return typeElement.hasProcessorMethodWithParameter(NestedProcessor.class) || typeElement.hasProcessorMethodWithParameterListOf(NestedProcessor.class);
    }

    @Override
    protected void doGenerate(DevKitTypeElement typeElement) {
        DefinedClass callbackClass = this.getNestedProcessorChainClass(typeElement);
        callbackClass._implements(this.ref(NestedProcessor.class));
        FieldVariable muleContext = callbackClass.field(4, (Type)this.ref(MuleContext.class), "muleContext");
        muleContext.javadoc().add((Object)"Mule Context");
        this.generateSetter(callbackClass, muleContext);
        FieldVariable chain = callbackClass.field(4, (Type)this.ref(MessageProcessor.class), "chain");
        chain.javadoc().add((Object)"Chain that will be executed upon calling process");
        this.generateSetter(callbackClass, chain);
        FieldVariable event = callbackClass.field(4, (Type)this.ref(MuleEvent.class), "event");
        event.javadoc().add((Object)"Event that will be cloned for dispatching");
        this.generateSetter(callbackClass, event);
        this.generateCallbackConstructor(callbackClass, chain, event, muleContext);
        this.generateCallbackProcess(callbackClass, chain, event);
        this.generateCallbackProcessWithPayload(callbackClass, chain, event, muleContext);
        this.generateCallbackProcessWithProperties(callbackClass, chain, event);
        this.generateCallbackProcessWithPayloadAndProperties(callbackClass, chain, event, muleContext);
        this.context.setClassRole(ROLE, callbackClass);
    }

    private void generateCallbackProcessWithPayload(DefinedClass callbackClass, FieldVariable chain, FieldVariable event, FieldVariable muleContext) {
        Method process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        Variable payload = process.param((Type)this.ref(Object.class), "payload");
        Variable muleMessage = process.body().decl((Type)this.ref(MuleMessage.class), "muleMessage");
        Invocation newMuleMessage = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleMessage.class));
        newMuleMessage.arg((Expression)payload);
        newMuleMessage.arg((Expression)muleContext);
        process.body().assign((AssignmentTarget)muleMessage, (Expression)newMuleMessage);
        Variable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        Invocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((Expression)muleMessage);
        newMuleEvent.arg((Expression)event);
        process.body().assign((AssignmentTarget)muleEvent, (Expression)newMuleEvent);
        process.body()._return((Expression)chain.invoke("process").arg((Expression)muleEvent).invoke("getMessage").invoke("getPayload"));
    }

    private void generateCallbackProcessWithPayloadAndProperties(DefinedClass callbackClass, FieldVariable chain, FieldVariable event, FieldVariable muleContext) {
        Method process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        Variable payload = process.param((Type)this.ref(Object.class), "payload");
        Variable properties = process.param((Type)this.ref(Map.class).narrow(this.ref(String.class)).narrow(this.ref(Object.class)), "properties");
        Variable muleMessage = process.body().decl((Type)this.ref(MuleMessage.class), "muleMessage");
        Invocation newMuleMessage = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleMessage.class));
        newMuleMessage.arg((Expression)payload);
        newMuleMessage.arg((Expression)muleContext);
        process.body().assign((AssignmentTarget)muleMessage, (Expression)newMuleMessage);
        ForEach forEachProperty = process.body().forEach((Type)this.ref(String.class), "property", (Expression)properties.invoke("keySet"));
        forEachProperty.body().add((Statement)muleMessage.invoke("setInvocationProperty").arg((Expression)forEachProperty.var()).arg((Expression)properties.invoke("get").arg((Expression)forEachProperty.var())));
        Variable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        Invocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((Expression)muleMessage);
        newMuleEvent.arg((Expression)event);
        process.body().assign((AssignmentTarget)muleEvent, (Expression)newMuleEvent);
        process.body()._return((Expression)chain.invoke("process").arg((Expression)muleEvent).invoke("getMessage").invoke("getPayload"));
    }

    private void generateCallbackProcessWithProperties(DefinedClass callbackClass, FieldVariable chain, FieldVariable event) {
        Method process = callbackClass.method(1, (Type)this.ref(Object.class), "processWithExtraProperties");
        process._throws(this.ref(Exception.class));
        Variable properties = process.param((Type)this.ref(Map.class).narrow(this.ref(String.class)).narrow(this.ref(Object.class)), "properties");
        Variable muleMessage = process.body().decl((Type)this.ref(MuleMessage.class), "muleMessage");
        process.body().assign((AssignmentTarget)muleMessage, (Expression)event.invoke("getMessage"));
        ForEach forEachProperty = process.body().forEach((Type)this.ref(String.class), "property", (Expression)properties.invoke("keySet"));
        forEachProperty.body().add((Statement)muleMessage.invoke("setInvocationProperty").arg((Expression)forEachProperty.var()).arg((Expression)properties.invoke("get").arg((Expression)forEachProperty.var())));
        Variable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        Invocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((Expression)muleMessage);
        newMuleEvent.arg((Expression)event);
        process.body().assign((AssignmentTarget)muleEvent, (Expression)newMuleEvent);
        process.body()._return((Expression)chain.invoke("process").arg((Expression)muleEvent).invoke("getMessage").invoke("getPayload"));
    }

    private void generateCallbackProcess(DefinedClass callbackClass, FieldVariable chain, FieldVariable event) {
        Method process = callbackClass.method(1, (Type)this.ref(Object.class), "process");
        process._throws(this.ref(Exception.class));
        Variable muleEvent = process.body().decl((Type)this.ref(MuleEvent.class), "muleEvent");
        Invocation newMuleEvent = ExpressionFactory._new((TypeReference)this.ref(DefaultMuleEvent.class));
        newMuleEvent.arg((Expression)event.invoke("getMessage"));
        newMuleEvent.arg((Expression)event);
        process.body().assign((AssignmentTarget)muleEvent, (Expression)newMuleEvent);
        process.body()._return((Expression)chain.invoke("process").arg((Expression)muleEvent).invoke("getMessage").invoke("getPayload"));
    }

    private void generateCallbackConstructor(DefinedClass callbackClass, FieldVariable chain, FieldVariable event, FieldVariable muleContext) {
        Method constructor = callbackClass.constructor(1);
        Variable event2 = constructor.param((Type)this.ref(MuleEvent.class), "event");
        Variable muleContext2 = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        Variable chain2 = constructor.param((Type)this.ref(MessageProcessor.class), "chain");
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)event), (Expression)event2);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)chain), (Expression)chain2);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((Variable)muleContext), (Expression)muleContext2);
    }

    private DefinedClass getNestedProcessorChainClass(TypeElement typeElement) {
        String processorCallbackClassName = this.context.getNameUtils().generateClassNameInPackage(typeElement, ".config.spring", ROLE);
        Package pkg = this.context.getCodeModel()._package(this.context.getNameUtils().getPackageName(processorCallbackClassName));
        DefinedClass clazz = pkg._class(this.context.getNameUtils().getClassName(processorCallbackClassName), new Class[]{MuleContextAware.class});
        this.context.setClassRole(ROLE, clazz);
        return clazz;
    }
}

